/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search.analyzer;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.fr.ElisionFilter;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.fr.FrenchStemFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;
import org.jahia.services.search.analyzer.FrenchSnowballAnalyzer;

public final class JahiaFrenchAnalyzer
extends Analyzer {
    private final Set<?> stoptable;
    private Set<?> excltable = new HashSet();
    private final Version matchVersion;

    public static Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public JahiaFrenchAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public JahiaFrenchAnalyzer(Version matchVersion, Set<?> stopwords) {
        this(matchVersion, stopwords, (Set<?>)CharArraySet.EMPTY_SET);
    }

    public JahiaFrenchAnalyzer(Version matchVersion, Set<?> stopwords, Set<?> stemExclutionSet) {
        this.matchVersion = matchVersion;
        this.stoptable = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy(stopwords));
        this.excltable = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy(stemExclutionSet));
    }

    public JahiaFrenchAnalyzer(Version matchVersion, String ... stopwords) {
        this(matchVersion, StopFilter.makeStopSet((String[])stopwords));
    }

    public JahiaFrenchAnalyzer(Version matchVersion, File stopwords) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet((File)stopwords));
    }

    public void setStemExclusionTable(String ... exclusionlist) {
        this.excltable = StopFilter.makeStopSet((String[])exclusionlist);
        this.setPreviousTokenStream(null);
    }

    public void setStemExclusionTable(Map exclusionlist) {
        this.excltable = new HashSet(exclusionlist.keySet());
        this.setPreviousTokenStream(null);
    }

    public void setStemExclusionTable(File exclusionlist) throws IOException {
        this.excltable = new HashSet(WordlistLoader.getWordSet((File)exclusionlist));
        this.setPreviousTokenStream(null);
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        StandardTokenizer result = new StandardTokenizer(this.matchVersion, reader);
        result = new StandardFilter((TokenStream)result);
        result = new ElisionFilter((TokenStream)result, (Set)FrenchSnowballAnalyzer.DEFAULT_ARTICLES);
        result = new LowerCaseFilter((TokenStream)result);
        result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), (TokenStream)result, this.stoptable);
        result = new FrenchStemFilter((TokenStream)result, this.excltable);
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new StandardTokenizer(this.matchVersion, reader);
            streams.result = new StandardFilter((TokenStream)streams.source);
            streams.result = new ElisionFilter(streams.result, (Set)FrenchSnowballAnalyzer.DEFAULT_ARTICLES);
            streams.result = new LowerCaseFilter(streams.result);
            streams.result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), streams.result, this.stoptable);
            streams.result = new FrenchStemFilter(streams.result, this.excltable);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }

    private static class DefaultSetHolder {
        static final Set<?> DEFAULT_STOP_SET = CharArraySet.unmodifiableSet((CharArraySet)new CharArraySet(Arrays.asList(FrenchAnalyzer.FRENCH_STOP_WORDS), false));

        private DefaultSetHolder() {
        }
    }
}

