/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search.facets;

import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.JahiaNodeIndexer;
import org.apache.jackrabbit.core.query.lucene.NamePathResolverImpl;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.hits.AbstractHitCollector;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.DocIdBitSet;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.OpenBitSetDISI;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.FacetParams;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.schema.BinaryField;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SortableDoubleField;
import org.apache.solr.schema.SortableFloatField;
import org.apache.solr.schema.SortableIntField;
import org.apache.solr.schema.SortableLongField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.DateMathParser;
import org.jahia.exceptions.JahiaException;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.renderer.ChoiceListRenderer;
import org.jahia.services.content.nodetypes.renderer.ChoiceListRendererService;
import org.jahia.services.content.nodetypes.renderer.NodeReferenceChoiceListRenderer;
import org.jahia.services.search.facets.JahiaQueryParser;
import org.jahia.utils.LanguageCodeConverters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJahiaJcrFacets {
    private static final Logger logger = LoggerFactory.getLogger(SimpleJahiaJcrFacets.class);
    public static final String PROPNAME_INDEX_SEPARATOR = "#";
    private static final Pattern PROPERTY_FIELD_PREFIX_PATTERN = Pattern.compile("\\d+:[0-9a-zA-Z]+\\[(.*)");
    private static final Pattern NAME_FIELD_PREFIX_PATTERN = Pattern.compile("(\\d+):(.*)");
    private static final Pattern UUID_PATTERN = Pattern.compile("[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}");
    protected OpenBitSet docs;
    protected SolrParams params;
    protected SolrParams required;
    protected IndexSearcher searcher;
    protected ResponseBuilder rb;
    protected SimpleOrderedMap<Object> facetResponse;
    public final Date NOW = new Date();
    SolrParams localParams;
    String facetValue;
    OpenBitSet base;
    String key;
    protected Analyzer defaultAnalyzer;
    protected final NamePathResolver resolver;
    protected final Session session;
    private NamespaceMappings nsMappings;
    public static final FieldSelector PARENT_AND_TRANSLATION_FIELDS = new FieldSelector(){

        public FieldSelectorResult accept(String fieldName) {
            if (JahiaNodeIndexer.TRANSLATED_NODE_PARENT == fieldName) {
                return FieldSelectorResult.LOAD;
            }
            if (JahiaNodeIndexer.TRANSLATION_LANGUAGE == fieldName) {
                return FieldSelectorResult.LOAD;
            }
            if (FieldNames.PARENT == fieldName) {
                return FieldSelectorResult.LOAD;
            }
            return FieldSelectorResult.NO_LOAD;
        }
    };
    private static final Comparator<String> nullStrComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    };
    public static final FieldSelector TRANSLATION_FIELDS = new FieldSelector(){
        private static final long serialVersionUID = -1570508136556374240L;

        public FieldSelectorResult accept(String fieldName) {
            if (JahiaNodeIndexer.TRANSLATED_NODE_PARENT == fieldName) {
                return FieldSelectorResult.LOAD;
            }
            if (JahiaNodeIndexer.TRANSLATION_LANGUAGE == fieldName) {
                return FieldSelectorResult.LOAD;
            }
            if (FieldNames.PARENT == fieldName) {
                return FieldSelectorResult.LOAD;
            }
            return FieldSelectorResult.NO_LOAD;
        }
    };
    private static Query matchAllDocsQuery = new MatchAllDocsQuery();

    public SimpleJahiaJcrFacets(IndexSearcher searcher, OpenBitSet docs, SolrParams params, SearchIndex index, Session session, NamespaceMappings nsMappings) {
        this.searcher = searcher;
        this.base = this.docs = docs;
        this.params = params;
        this.required = new RequiredSolrParams(params);
        this.resolver = NamePathResolverImpl.create((NamespaceMappings)index.getNamespaceMappings());
        this.defaultAnalyzer = index.getTextAnalyzer();
        this.session = session;
        this.nsMappings = nsMappings;
    }

    void parseParams(String type, String param) throws ParseException, IOException {
        this.localParams = QueryParsing.getLocalParams((String)param, (SolrParams)this.params);
        this.base = this.docs;
        this.facetValue = param;
        this.key = param;
        if (this.localParams == null) {
            return;
        }
        if (!"facet.query".equals(type)) {
            this.facetValue = this.localParams.get("v");
        }
        this.key = this.facetValue;
        this.key = this.localParams.get("key", this.key);
        String excludeStr = this.localParams.get("ex");
        if (excludeStr == null) {
            return;
        }
    }

    public NamedList<Object> getFacetCounts() {
        if (!this.params.getBool("facet", true)) {
            return null;
        }
        this.facetResponse = new SimpleOrderedMap();
        try {
            this.facetResponse.add("facet_queries", this.getFacetQueryCounts());
            this.facetResponse.add("facet_fields", this.getFacetFieldCounts());
            this.facetResponse.add("facet_dates", this.getFacetDateCounts());
            this.facetResponse.add("facet_ranges", this.getFacetRangeCounts());
        }
        catch (Exception e) {
            logger.warn("Exception during facet counts", (Throwable)e);
            this.addException("Exception during facet counts", e);
        }
        return this.facetResponse;
    }

    public void addException(String msg, Exception e) {
        ArrayList<String> exceptions = (ArrayList<String>)this.facetResponse.get("exception");
        if (exceptions == null) {
            exceptions = new ArrayList<String>();
            this.facetResponse.add("exception", exceptions);
        }
        String entry = msg + '\n' + SolrException.toStr((Throwable)e);
        exceptions.add(entry);
    }

    public NamedList<Object> getFacetQueryCounts() throws IOException, ParseException {
        SimpleOrderedMap res = new SimpleOrderedMap();
        String[] facetQs = this.params.getParams("facet.query");
        if (null != facetQs && 0 != facetQs.length) {
            for (String q : facetQs) {
                try {
                    Integer minCount = this.params.getFieldInt(q, "facet.mincount");
                    if (minCount == null) {
                        String[] zeros = this.params.getFieldBool(q, "facet.zeros");
                        minCount = zeros != null && !zeros.booleanValue() ? 1 : 0;
                    }
                    for (String query : this.params.getFieldParams(q, "query")) {
                        this.parseParams("facet.query", query);
                        JahiaQueryParser qp = new JahiaQueryParser(FieldNames.FULLTEXT, (Analyzer)new KeywordAnalyzer());
                        qp.setLowercaseExpandedTerms(false);
                        Query qobj = qp.parse(query);
                        long count = OpenBitSet.intersectionCount((OpenBitSet)this.getDocIdSet(qobj, ""), (OpenBitSet)this.base);
                        if (count < (long)minCount.intValue()) continue;
                        res.add(this.key, (Object)count);
                    }
                }
                catch (Exception e) {
                    String msg = "Exception during facet.query of " + q;
                    logger.warn(msg, (Throwable)e);
                    this.addException(msg, e);
                }
            }
        }
        return res;
    }

    public NamedList<Object> getTermCounts(String field, ExtendedPropertyDefinition epd, String fieldNameInIndex, String locale) throws IOException, RepositoryException {
        int offset = this.params.getFieldInt(field, "facet.offset", 0);
        int limit = this.params.getFieldInt(field, "facet.limit", 100);
        if (limit == 0) {
            return new NamedList();
        }
        Integer mincount = this.params.getFieldInt(field, "facet.mincount");
        if (mincount == null) {
            Boolean zeros = this.params.getFieldBool(field, "facet.zeros");
            mincount = zeros != null && zeros == false ? 1 : 0;
        }
        boolean missing = this.params.getFieldBool(field, "facet.missing", false);
        String sort = this.params.getFieldParam(field, "facet.sort", limit > 0 ? "count" : "index");
        String prefix = this.params.getFieldParam(field, "facet.prefix");
        SchemaField sf = new SchemaField(fieldNameInIndex, this.getType(epd));
        FieldType ft = sf.getType();
        String method = this.params.getFieldParam(field, "facet.method");
        boolean enumMethod = "enum".equals(method);
        if (method == null && ft instanceof BoolField) {
            enumMethod = true;
        }
        boolean multiToken = epd.isMultiple() || epd.isHierarchical();
        boolean bl = enumMethod = enumMethod || multiToken;
        NamedList<Object> counts = enumMethod ? this.getFacetTermEnumCounts(this.searcher, this.docs, field, fieldNameInIndex, offset, limit, mincount, missing, sort, prefix, epd.isInternationalized() ? (locale == null ? "" : locale) : null, epd) : this.getFieldCacheCounts(this.searcher, this.docs, fieldNameInIndex, offset, limit, mincount, missing, sort, prefix, epd.isInternationalized() ? (locale == null ? "" : locale) : null, epd);
        return counts;
    }

    public NamedList<Object> getFacetFieldCounts() throws IOException {
        SimpleOrderedMap res = new SimpleOrderedMap();
        String[] facetFs = this.params.getParams("facet.field");
        if (null != facetFs) {
            for (String f : facetFs) {
                try {
                    String fieldKey;
                    String fieldType = StringUtils.substringBeforeLast((String)f, (String)PROPNAME_INDEX_SEPARATOR);
                    String locale = this.params.getFieldParam(f, "facet.locale");
                    ExtendedPropertyDefinition epd = NodeTypeRegistry.getInstance().getNodeType(this.params.get("f." + f + ".facet.nodetype")).getPropertyDefinition(fieldType);
                    String fieldNameInIndex = this.getFieldNameInIndex(f, fieldType, epd, locale);
                    this.parseParams("facet.field", f);
                    String termList = this.localParams == null ? null : this.localParams.get("terms");
                    String string = fieldKey = this.params.getFieldParam(f, "facet.key") != null ? this.params.getFieldParam(f, "facet.key") : "";
                    if (termList != null) {
                        res.add(fieldType + PROPNAME_INDEX_SEPARATOR + fieldNameInIndex + PROPNAME_INDEX_SEPARATOR + fieldKey, this.ensureSortingAndNameResolution(this.params.getFieldParam(f, "facet.sort"), this.getListedTermCounts(f, epd, fieldNameInIndex, locale, termList), epd, this.params.getFieldParam(f, "facet.labelRenderer"), LanguageCodeConverters.getLocaleFromCode(locale), fieldNameInIndex));
                        continue;
                    }
                    res.add(fieldType + PROPNAME_INDEX_SEPARATOR + fieldNameInIndex + PROPNAME_INDEX_SEPARATOR + fieldKey, this.ensureSortingAndNameResolution(this.params.getFieldParam(f, "facet.sort"), this.getTermCounts(f, epd, fieldNameInIndex, locale), epd, this.params.getFieldParam(f, "facet.labelRenderer"), LanguageCodeConverters.getLocaleFromCode(locale), fieldNameInIndex));
                }
                catch (Exception e) {
                    logger.error("Cant display facets for: " + f, (Throwable)e);
                }
            }
        }
        return res;
    }

    private NamedList<Object> ensureSortingAndNameResolution(String fieldSort, NamedList<Object> values, ExtendedPropertyDefinition fieldPropertyType, String facetValueRenderer, Locale locale, String fieldName) {
        NamedList<Object> resolvedValues = values;
        if (FieldNames.PROPERTIES.equals(fieldName)) {
            resolvedValues = this.resolveFieldNamesWhenUsingPropertiesField(resolvedValues);
        }
        if (fieldPropertyType.getRequiredType() == 7) {
            resolvedValues = this.resolvePropertiesWithNameValues(resolvedValues, fieldName);
        }
        if (resolvedValues.size() > 1 && ("false".equals(fieldSort) || "index".equals(fieldSort))) {
            ChoiceListRenderer renderer;
            ChoiceListRenderer choiceListRenderer = renderer = !StringUtils.isEmpty((String)facetValueRenderer) ? ChoiceListRendererService.getInstance().getRenderers().get(facetValueRenderer) : null;
            if (renderer != null) {
                resolvedValues = this.sortValuesAfterChoiceListRenderer(resolvedValues, renderer, fieldPropertyType, locale);
            }
        }
        return resolvedValues;
    }

    private NamedList<Object> resolveFieldNamesWhenUsingPropertiesField(NamedList<Object> values) {
        NamedList resolvedValues = new NamedList();
        for (Map.Entry facetValueEntry : values) {
            String facetValueKey = (String)facetValueEntry.getKey();
            facetValueKey = PROPERTY_FIELD_PREFIX_PATTERN.matcher(facetValueKey).replaceFirst("$1") + "##q->##" + (String)facetValueEntry.getKey();
            resolvedValues.add(facetValueKey, facetValueEntry.getValue());
        }
        return resolvedValues;
    }

    private NamedList<Object> resolvePropertiesWithNameValues(NamedList<Object> values, String fieldName) {
        NamedList resolvedValues = new NamedList();
        for (Map.Entry facetValueEntry : values) {
            String facetValueKey = (String)facetValueEntry.getKey();
            Matcher matcher = NAME_FIELD_PREFIX_PATTERN.matcher(facetValueKey);
            if (matcher.matches()) {
                String nsPrefix = matcher.group(1);
                try {
                    nsPrefix = this.session.getNamespacePrefix(this.nsMappings.getURI(nsPrefix));
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                StringBuilder facetValueBuilder = new StringBuilder();
                facetValueBuilder.append(nsPrefix);
                if (facetValueBuilder.length() > 0) {
                    facetValueBuilder.append(":");
                }
                facetValueBuilder.append("$2");
                facetValueKey = matcher.replaceFirst(facetValueBuilder.toString());
                if (!FieldNames.PROPERTIES.equals(fieldName)) {
                    facetValueKey = facetValueKey + "##q->##" + (String)facetValueEntry.getKey();
                }
            }
            resolvedValues.add(facetValueKey, facetValueEntry.getValue());
        }
        return resolvedValues;
    }

    private NamedList<Object> sortValuesAfterChoiceListRenderer(NamedList<Object> values, ChoiceListRenderer renderer, ExtendedPropertyDefinition fieldPropertyType, Locale locale) {
        try {
            Collator collator = Collator.getInstance(locale);
            collator.setStrength(2);
            TreeMap<Object, Integer> sortedLabels = new TreeMap<Object, Integer>(collator);
            int i = 0;
            boolean resolveReference = renderer instanceof NodeReferenceChoiceListRenderer;
            JCRSessionWrapper currentUserSession = resolveReference ? JCRSessionFactory.getInstance().getCurrentUserSession(this.session.getWorkspace().getName(), locale) : null;
            for (Map.Entry facetValueEntry : values) {
                String facetValueKey = (String)facetValueEntry.getKey();
                Object propertyValue = facetValueKey;
                if (resolveReference) {
                    propertyValue = facetValueKey.length() == 36 && UUID_PATTERN.matcher(facetValueKey).matches() ? currentUserSession.getNodeByIdentifier(facetValueKey) : currentUserSession.getNode(StringUtils.substring((String)facetValueKey, (int)facetValueKey.indexOf(47)));
                }
                sortedLabels.put(renderer.getStringRendering(locale, fieldPropertyType, propertyValue), i++);
            }
            NamedList sortedValues = new NamedList();
            for (Integer index : sortedLabels.values()) {
                sortedValues.add(values.getName(index.intValue()), values.getVal(index.intValue()));
            }
            return sortedValues;
        }
        catch (UnsupportedOperationException | RepositoryException e) {
            logger.warn("Exception while sorting label rendered facet values, fallback to default sorting", e);
            return values;
        }
    }

    private NamedList<Object> getListedTermCounts(String field, ExtendedPropertyDefinition epd, String fieldNameInIndex, String locale, String termList) throws IOException {
        FieldType ft = this.getType(epd);
        List terms = StrUtils.splitSmart((String)termList, (String)",", (boolean)true);
        NamedList res = new NamedList();
        Term t = new Term(field);
        for (String term : terms) {
            String internal = ft.toInternal(term);
            int count = (int)OpenBitSet.intersectionCount((OpenBitSet)this.getDocIdSet((Query)new TermQuery(t.createTerm(internal)), ""), (OpenBitSet)this.base);
            res.add(term, (Object)count);
        }
        return res;
    }

    public int getFieldMissingCount(IndexSearcher searcher, OpenBitSet docs, String fieldName, String locale) throws IOException {
        TermRangeQuery query = null;
        if (StringUtils.isEmpty((String)locale)) {
            query = new TermRangeQuery(fieldName, null, null, false, false);
        } else {
            BooleanQuery booleanQuery = new BooleanQuery();
            booleanQuery.add((Query)new TermRangeQuery(fieldName, null, null, false, false), BooleanClause.Occur.MUST);
            booleanQuery.add((Query)new TermQuery(new Term(JahiaNodeIndexer.TRANSLATION_LANGUAGE, locale)), BooleanClause.Occur.MUST);
            query = booleanQuery;
        }
        OpenBitSet hasVal = this.getDocIdSet((Query)query, locale);
        return (int)OpenBitSet.andNotCount((OpenBitSet)docs, (OpenBitSet)hasVal);
    }

    public NamedList<Object> getFieldCacheCounts(IndexSearcher searcher, OpenBitSet docs, String fieldName, int offset, int limit, int mincount, boolean missing, String sort, String prefix, String locale, ExtendedPropertyDefinition epd) throws IOException {
        int endTermIndex;
        int startTermIndex;
        FieldType ft = this.getType(epd);
        NamedList res = new NamedList();
        FieldCache.StringIndex si = FieldCache.DEFAULT.getStringIndex(searcher.getIndexReader(), fieldName);
        String[] terms = si.lookup;
        int[] termNum = si.order;
        if (prefix != null && prefix.length() == 0) {
            prefix = null;
        }
        if (prefix != null) {
            startTermIndex = Arrays.binarySearch(terms, prefix, nullStrComparator);
            if (startTermIndex < 0) {
                startTermIndex = -startTermIndex - 1;
            }
            endTermIndex = Arrays.binarySearch(terms, prefix + "\uffff\uffff\uffff\uffff", nullStrComparator);
            endTermIndex = -endTermIndex - 1;
        } else {
            startTermIndex = 1;
            endTermIndex = terms.length;
        }
        int nTerms = endTermIndex - startTermIndex;
        if (nTerms > 0 && docs.size() >= (long)mincount) {
            int lim;
            int[] counts = new int[nTerms];
            DocIdSetIterator iter = docs.iterator();
            while (iter.nextDoc() != Integer.MAX_VALUE) {
                int term = termNum[iter.docID()];
                int arrIdx = term - startTermIndex;
                if (arrIdx < 0 || arrIdx >= nTerms) continue;
                int n = arrIdx;
                counts[n] = counts[n] + 1;
            }
            int off = offset;
            int n = lim = limit >= 0 ? limit : Integer.MAX_VALUE;
            if (sort.equals("count") || sort.equals("true")) {
                int maxsize = limit > 0 ? offset + limit : 0x7FFFFFFE;
                maxsize = Math.min(maxsize, nTerms);
                TreeSet<SimpleFacets.CountPair> queue = new TreeSet<SimpleFacets.CountPair>();
                int min = mincount - 1;
                for (int i = 0; i < nTerms; ++i) {
                    int c = counts[i];
                    if (c <= min) continue;
                    queue.add(new SimpleFacets.CountPair((Comparable)((Object)terms[startTermIndex + i]), (Comparable)Integer.valueOf(c)));
                    if (queue.size() >= maxsize) break;
                }
                for (SimpleFacets.CountPair p : queue) {
                    if (--off >= 0) continue;
                    if (--lim >= 0) {
                        res.add(ft.indexedToReadable((String)((Object)p.key)), (Object)p.val);
                        continue;
                    }
                    break;
                }
            } else {
                int i = 0;
                if (mincount <= 0) {
                    i = off;
                    off = 0;
                }
                while (i < nTerms) {
                    int c = counts[i];
                    if (c >= mincount && --off < 0) {
                        if (--lim < 0) break;
                        res.add(ft.indexedToReadable(terms[startTermIndex + i]), (Object)c);
                    }
                    ++i;
                }
            }
        }
        if (missing) {
            res.add(null, (Object)this.getFieldMissingCount(searcher, docs, fieldName, locale));
        }
        return res;
    }

    public NamedList<Object> getFacetTermEnumCounts(IndexSearcher searcher, OpenBitSet docs, String field, String fieldName, int offset, int limit, int mincount, boolean missing, String sort, String prefix, String locale, ExtendedPropertyDefinition epd) throws IOException {
        int minDfFilterCache = this.params.getFieldInt(field, "facet.enum.cache.minDf", 0);
        IndexReader r = searcher.getIndexReader();
        FieldType ft = this.getType(epd);
        int maxsize = limit >= 0 ? offset + limit : 0x7FFFFFFE;
        TreeSet<SimpleFacets.CountPair> queue = sort.equals("count") || sort.equals("true") ? new TreeSet<SimpleFacets.CountPair>() : null;
        NamedList res = new NamedList();
        int min = mincount - 1;
        int off = offset;
        int lim = limit >= 0 ? limit : Integer.MAX_VALUE;
        String startTerm = prefix == null ? "" : ft.toInternal(prefix);
        TermEnum te = r.terms(new Term(fieldName, startTerm));
        TermDocs td = r.termDocs();
        SolrIndexSearcher.TermDocsState tdState = new SolrIndexSearcher.TermDocsState();
        tdState.tenum = te;
        tdState.tdocs = td;
        if (docs.size() >= (long)mincount) {
            Term t;
            while (null != (t = te.term()) && t.field().equals(fieldName) && (prefix == null || t.text().startsWith(prefix))) {
                int df = te.docFreq();
                if (df > 0 && df > min) {
                    int c;
                    if (df >= minDfFilterCache) {
                        c = (int)OpenBitSet.intersectionCount((OpenBitSet)this.getDocIdSet((Query)new TermQuery(t), locale), (OpenBitSet)docs);
                    } else {
                        td.seek(te);
                        c = 0;
                        while (td.next()) {
                            int doc = td.doc();
                            if (locale != null) {
                                doc = this.getMainDocIdForTranslations(searcher.getIndexReader().document(doc, PARENT_AND_TRANSLATION_FIELDS), locale);
                            }
                            if (!docs.fastGet(doc)) continue;
                            ++c;
                        }
                    }
                    if (sort.equals("count") || sort.equals("true")) {
                        if (c > min) {
                            queue.add(new SimpleFacets.CountPair((Comparable)((Object)t.text()), (Comparable)Integer.valueOf(c)));
                            if (queue.size() >= maxsize) {
                                break;
                            }
                        }
                    } else if (c >= mincount && --off < 0) {
                        if (--lim < 0) break;
                        res.add(ft.indexedToReadable(t.text()), (Object)c);
                    }
                }
                if (te.next()) continue;
            }
        }
        if (sort.equals("count") || sort.equals("true")) {
            for (SimpleFacets.CountPair p : queue) {
                if (--off >= 0) continue;
                if (--lim < 0) break;
                res.add(ft.indexedToReadable((String)((Object)p.key)), (Object)p.val);
            }
        }
        if (missing) {
            res.add(null, (Object)this.getFieldMissingCount(searcher, docs, fieldName, locale));
        }
        te.close();
        td.close();
        return res;
    }

    public String getFieldNameInIndex(String field, String propertyFieldName, ExtendedPropertyDefinition epd, String langCode) {
        String fieldName = propertyFieldName;
        try {
            fieldName = this.resolver.getJCRName(NameFactoryImpl.getInstance().create(this.session.getNamespaceURI(epd.getPrefix()), epd.getLocalName()));
            int idx = fieldName.indexOf(58);
            if (epd != null && epd.isFacetable()) {
                fieldName = fieldName.substring(0, idx + 1) + "FACET:" + fieldName.substring(idx + 1);
            } else if (epd == null || !epd.isFacetable()) {
                String prefix = this.params.getFieldParam(field, "facet.prefix");
                if (this.params instanceof MapSolrParams) {
                    ((MapSolrParams)this.params).getMap().put("f." + field + '.' + "facet.prefix", fieldName + "[" + (prefix != null ? prefix : ""));
                } else if (this.params instanceof MultiMapSolrParams) {
                    ((MultiMapSolrParams)this.params).getMap().put("f." + field + '.' + "facet.prefix", new String[]{fieldName + "[" + (prefix != null ? prefix : "")});
                }
                fieldName = FieldNames.PROPERTIES;
            } else {
                fieldName = fieldName.substring(0, idx + 1) + "FULL:" + fieldName.substring(idx + 1);
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return fieldName;
    }

    @Deprecated
    public NamedList<Object> getFacetDateCounts() throws JahiaException, IOException, RepositoryException {
        SimpleOrderedMap resOuter = new SimpleOrderedMap();
        String[] fields = this.params.getParams("facet.date");
        if (null == fields || 0 == fields.length) {
            return resOuter;
        }
        for (String f : fields) {
            try {
                this.getFacetDateCounts(f, (NamedList<Object>)resOuter);
            }
            catch (Exception e) {
                String msg = "Exception during facet.date of " + f;
                logger.warn(msg, (Throwable)e);
                this.addException(msg, e);
            }
        }
        return resOuter;
    }

    @Deprecated
    public void getFacetDateCounts(String dateFacet, NamedList<Object> resOuter) throws IOException, ParseException, RepositoryException, JahiaException {
        Date end;
        String[] start;
        this.parseParams("facet.date", dateFacet);
        String f = this.facetValue;
        SimpleOrderedMap resInner = new SimpleOrderedMap();
        String fieldName = StringUtils.substringBeforeLast((String)f, (String)PROPNAME_INDEX_SEPARATOR);
        ExtendedPropertyDefinition epd = NodeTypeRegistry.getInstance().getNodeType(this.params.get("f." + f + ".facet.nodetype")).getPropertyDefinition(fieldName);
        String fieldNameInIndex = this.getFieldNameInIndex(f, fieldName, epd, this.params.getFieldParam(f, "facet.locale"));
        String prefix = this.params.getFieldParam(f, "facet.prefix");
        DateField ft = StringUtils.isEmpty((String)prefix) ? JahiaQueryParser.DATE_TYPE : JahiaQueryParser.JR_DATE_TYPE;
        SchemaField sf = new SchemaField(fieldNameInIndex, (FieldType)ft);
        resOuter.add(fieldName + PROPNAME_INDEX_SEPARATOR + fieldNameInIndex, (Object)resInner);
        if (epd.getRequiredType() != 5) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not date facet on a field which is not a DateField: " + f);
        }
        Integer minCount = this.params.getFieldInt(f, "facet.mincount");
        if (minCount == null) {
            Boolean zeros = this.params.getFieldBool(f, "facet.zeros");
            minCount = zeros != null && zeros == false ? 1 : 0;
        }
        String startS = this.required.getFieldParam(f, "facet.date.start");
        try {
            start = JahiaQueryParser.DATE_TYPE.parseMath(this.NOW, startS);
        }
        catch (SolrException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'start' is not a valid Date string: " + startS, (Throwable)e);
        }
        String endS = this.required.getFieldParam(f, "facet.date.end");
        try {
            end = JahiaQueryParser.DATE_TYPE.parseMath(this.NOW, endS);
        }
        catch (SolrException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'end' is not a valid Date string: " + endS, (Throwable)e);
        }
        if (end.before((Date)start)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'end' comes before 'start': " + endS + " < " + startS);
        }
        String gap = this.required.getFieldParam(f, "facet.date.gap");
        DateMathParser dmp = new DateMathParser(DateField.UTC, Locale.US);
        dmp.setNow(this.NOW);
        String[] iStrs = this.params.getFieldParams(f, "facet.date.include");
        EnumSet include = null == iStrs || 0 == iStrs.length ? EnumSet.of(FacetParams.FacetRangeInclude.LOWER, FacetParams.FacetRangeInclude.UPPER, FacetParams.FacetRangeInclude.EDGE) : FacetParams.FacetRangeInclude.parseParam((String[])iStrs);
        try {
            String[] low = start;
            while (low.before(end)) {
                int includeUpper;
                dmp.setNow((Date)low);
                String label = JahiaQueryParser.DATE_TYPE.toExternal((Date)low);
                String[] high = dmp.parseMath(gap);
                if (end.before((Date)high)) {
                    if (this.params.getFieldBool(f, "facet.date.hardend", false)) {
                        high = end;
                    } else {
                        end = high;
                    }
                }
                if (high.before((Date)low)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet infinite loop (is gap negative?)");
                }
                int includeLower = include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && low.equals(start) ? 1 : 0;
                Query rangeQuery = this.getRangeQuery(ft, null, sf, prefix, (Date)low, (Date)high, includeLower != 0, (includeUpper = include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && high.equals(end) ? 1 : 0) != 0);
                int count = this.rangeCount(rangeQuery);
                if (count >= minCount) {
                    resInner.add(label + PROPNAME_INDEX_SEPARATOR + rangeQuery.toString(), (Object)count);
                }
                low = high;
            }
        }
        catch (java.text.ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'gap' is not a valid Date Math string: " + gap, (Throwable)e);
        }
        resInner.add("gap", (Object)gap);
        resInner.add("start", (Object)start);
        resInner.add("end", (Object)end);
        String[] othersP = this.params.getFieldParams(f, "facet.date.other");
        if (null != othersP && 0 < othersP.length) {
            EnumSet<FacetParams.FacetDateOther> others = EnumSet.noneOf(FacetParams.FacetDateOther.class);
            for (String o : othersP) {
                others.add(FacetParams.FacetDateOther.get((String)o));
            }
            if (!others.contains(FacetParams.FacetDateOther.NONE)) {
                Query rangeQuery;
                int count;
                boolean all = others.contains(FacetParams.FacetDateOther.ALL);
                if ((all || others.contains(FacetParams.FacetDateOther.BEFORE)) && (count = this.rangeCount(rangeQuery = this.getRangeQuery(ft, null, sf, prefix, null, (Date)start, false, include.contains(FacetParams.FacetRangeInclude.OUTER) || !include.contains(FacetParams.FacetRangeInclude.LOWER) && !include.contains(FacetParams.FacetRangeInclude.EDGE)))) >= minCount) {
                    resInner.add(FacetParams.FacetDateOther.BEFORE.toString() + PROPNAME_INDEX_SEPARATOR + rangeQuery.toString(), (Object)count);
                }
                if ((all || others.contains(FacetParams.FacetDateOther.AFTER)) && (count = this.rangeCount(rangeQuery = this.getRangeQuery(ft, null, sf, prefix, end, null, include.contains(FacetParams.FacetRangeInclude.OUTER) || !include.contains(FacetParams.FacetRangeInclude.UPPER) && !include.contains(FacetParams.FacetRangeInclude.EDGE), false))) >= minCount) {
                    resInner.add(FacetParams.FacetDateOther.AFTER.toString() + PROPNAME_INDEX_SEPARATOR + rangeQuery.toString(), (Object)count);
                }
                if ((all || others.contains(FacetParams.FacetDateOther.BETWEEN)) && (count = this.rangeCount(rangeQuery = this.getRangeQuery(ft, null, sf, prefix, (Date)start, end, include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE), include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE)))) >= minCount) {
                    resInner.add(FacetParams.FacetDateOther.BETWEEN.toString() + PROPNAME_INDEX_SEPARATOR + rangeQuery.toString(), (Object)count);
                }
            }
        }
    }

    private Query getRangeQuery(DateField fieldType, QParser parser, SchemaField schemaField, String prefix, Date low, Date high, boolean minInclusive, boolean maxInclusive) {
        return this.prefixRangeQuery(fieldType.getRangeQuery(parser, schemaField, low, high, minInclusive, maxInclusive), prefix);
    }

    private Query getRangeQuery(FieldType fieldType, QParser parser, SchemaField schemaField, String prefix, String low, String high, boolean minInclusive, boolean maxInclusive) {
        return this.prefixRangeQuery(fieldType.getRangeQuery(parser, schemaField, low, high, minInclusive, maxInclusive), prefix);
    }

    private Query prefixRangeQuery(Query noPrefixQuery, String prefix) {
        TermRangeQuery rangeQuery = (TermRangeQuery)noPrefixQuery;
        if (StringUtils.isNotEmpty((String)prefix)) {
            rangeQuery = new TermRangeQuery(rangeQuery.getField(), rangeQuery.getLowerTerm() == null ? prefix : prefix + rangeQuery.getLowerTerm(), rangeQuery.getUpperTerm() == null ? prefix + "zzzzzzzzzzzz" : prefix + rangeQuery.getUpperTerm(), rangeQuery.includesLower(), rangeQuery.includesUpper());
        }
        return rangeQuery;
    }

    public NamedList<Object> getFacetRangeCounts() {
        SimpleOrderedMap resOuter = new SimpleOrderedMap();
        String[] fields = this.params.getParams("facet.range");
        if (null == fields || 0 == fields.length) {
            return resOuter;
        }
        for (String f : fields) {
            try {
                this.getFacetRangeCounts(f, (NamedList<Object>)resOuter);
            }
            catch (Exception e) {
                String msg = "Exception during facet.range of " + f;
                SolrException.logOnce((Logger)SolrCore.log, (String)msg, (Throwable)e);
                this.addException(msg, e);
            }
        }
        return resOuter;
    }

    void getFacetRangeCounts(String facetRange, NamedList<Object> resOuter) throws IOException, ParseException, RepositoryException {
        this.parseParams("facet.range", facetRange);
        String f = this.facetValue;
        String fieldName = StringUtils.substringBeforeLast((String)f, (String)PROPNAME_INDEX_SEPARATOR);
        ExtendedPropertyDefinition epd = NodeTypeRegistry.getInstance().getNodeType(this.params.get("f." + f + ".facet.nodetype")).getPropertyDefinition(fieldName);
        String fieldNameInIndex = this.getFieldNameInIndex(f, fieldName, epd, this.params.getFieldParam(f, "facet.locale"));
        SchemaField sf = new SchemaField(fieldNameInIndex, this.getType(epd));
        FieldType ft = sf.getType();
        RangeEndpointCalculator calc = null;
        if (ft instanceof TrieField) {
            TrieField trie = (TrieField)ft;
            switch (trie.getType()) {
                case FLOAT: {
                    calc = new FloatRangeEndpointCalculator(sf);
                    break;
                }
                case DOUBLE: {
                    calc = new DoubleRangeEndpointCalculator(sf);
                    break;
                }
                case INTEGER: {
                    calc = new IntegerRangeEndpointCalculator(sf);
                    break;
                }
                case LONG: {
                    calc = new LongRangeEndpointCalculator(sf);
                    break;
                }
                default: {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to range facet on tried field of unexpected type:" + f);
                }
            }
        } else if (ft instanceof DateField) {
            calc = new DateRangeEndpointCalculator(sf, this.NOW);
        } else if (ft instanceof SortableIntField) {
            calc = new IntegerRangeEndpointCalculator(sf);
        } else if (ft instanceof SortableLongField) {
            calc = new LongRangeEndpointCalculator(sf);
        } else if (ft instanceof SortableFloatField) {
            calc = new FloatRangeEndpointCalculator(sf);
        } else if (ft instanceof SortableDoubleField) {
            calc = new DoubleRangeEndpointCalculator(sf);
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to range facet on field:" + sf);
        }
        resOuter.add(this.key, this.getFacetRangeCounts(sf, f, calc));
    }

    private <T extends Comparable<T>> NamedList<Object> getFacetRangeCounts(SchemaField sf, String f, RangeEndpointCalculator<T> calc) throws IOException {
        int count;
        Query rangeQ;
        String prefix = this.params.getFieldParam(f, "facet.prefix");
        SimpleOrderedMap res = new SimpleOrderedMap();
        NamedList counts = new NamedList();
        res.add("counts", (Object)counts);
        T start = calc.getValue(this.required.getFieldParam(f, "facet.range.start"));
        T end = calc.getValue(this.required.getFieldParam(f, "facet.range.end"));
        if (end.compareTo(start) < 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet 'end' comes before 'start': " + end + " < " + start);
        }
        String gap = this.required.getFieldParam(f, "facet.range.gap");
        res.add("gap", calc.getGap(gap));
        int minCount = this.params.getFieldInt(f, "facet.mincount", 0);
        EnumSet include = FacetParams.FacetRangeInclude.parseParam((String[])this.params.getFieldParams(f, "facet.range.include"));
        T low = start;
        while (low.compareTo(end) < 0) {
            T high = calc.addGap(low, gap);
            if (end.compareTo(high) < 0) {
                if (this.params.getFieldBool(f, "facet.range.hardend", false)) {
                    high = end;
                } else {
                    end = high;
                }
            }
            if (high.compareTo(low) < 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet infinite loop (is gap negative? did the math overflow?)");
            }
            boolean includeLower = include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && 0 == low.compareTo(start);
            boolean includeUpper = include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && 0 == high.compareTo(end);
            String lowS = calc.formatValue(low);
            String highS = calc.formatValue(high);
            rangeQ = this.getRangeQuery(sf.getType(), null, sf, prefix, lowS, highS, includeLower, includeUpper);
            count = this.rangeCount(rangeQ);
            if (count >= minCount) {
                counts.add(lowS + PROPNAME_INDEX_SEPARATOR + rangeQ.toString(), (Object)count);
            }
            low = high;
        }
        res.add("start", start);
        res.add("end", end);
        String[] othersP = this.params.getFieldParams(f, "facet.range.other");
        if (null != othersP && 0 < othersP.length) {
            EnumSet<FacetParams.FacetRangeOther> others = EnumSet.noneOf(FacetParams.FacetRangeOther.class);
            for (String o : othersP) {
                others.add(FacetParams.FacetRangeOther.get((String)o));
            }
            if (!others.contains(FacetParams.FacetRangeOther.NONE)) {
                boolean all = others.contains(FacetParams.FacetRangeOther.ALL);
                String startS = calc.formatValue(start);
                String endS = calc.formatValue(end);
                if ((all || others.contains(FacetParams.FacetRangeOther.BEFORE)) && (count = this.rangeCount(rangeQ = this.getRangeQuery(sf.getType(), null, sf, prefix, null, startS, false, include.contains(FacetParams.FacetRangeInclude.OUTER) || !include.contains(FacetParams.FacetRangeInclude.LOWER) && !include.contains(FacetParams.FacetRangeInclude.EDGE)))) >= minCount) {
                    res.add(FacetParams.FacetRangeOther.BEFORE.toString(), (Object)count);
                    counts.add(FacetParams.FacetRangeOther.BEFORE.toString() + PROPNAME_INDEX_SEPARATOR + rangeQ.toString(), (Object)count);
                }
                if ((all || others.contains(FacetParams.FacetRangeOther.AFTER)) && (count = this.rangeCount(rangeQ = this.getRangeQuery(sf.getType(), null, sf, prefix, endS, null, include.contains(FacetParams.FacetRangeInclude.OUTER) || !include.contains(FacetParams.FacetRangeInclude.UPPER) && !include.contains(FacetParams.FacetRangeInclude.EDGE), false))) >= minCount) {
                    res.add(FacetParams.FacetRangeOther.AFTER.toString(), (Object)count);
                    counts.add(FacetParams.FacetRangeOther.AFTER.toString() + PROPNAME_INDEX_SEPARATOR + rangeQ.toString(), (Object)count);
                }
                if ((all || others.contains(FacetParams.FacetRangeOther.BETWEEN)) && (count = this.rangeCount(rangeQ = this.getRangeQuery(sf.getType(), null, sf, prefix, startS, endS, include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE), include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE)))) >= minCount) {
                    res.add(FacetParams.FacetRangeOther.BETWEEN.toString(), (Object)count);
                    counts.add(FacetParams.FacetRangeOther.BETWEEN.toString() + PROPNAME_INDEX_SEPARATOR + rangeQ.toString(), (Object)count);
                }
            }
        }
        return res;
    }

    protected int rangeCount(SchemaField sf, String low, String high, boolean iLow, boolean iHigh) throws IOException {
        Query rangeQ = sf.getType().getRangeQuery(null, sf, low, high, iLow, iHigh);
        return (int)OpenBitSet.intersectionCount((OpenBitSet)this.getDocIdSet(rangeQ, ""), (OpenBitSet)this.base);
    }

    @Deprecated
    protected int rangeCount(SchemaField sf, Date low, Date high, boolean iLow, boolean iHigh) throws IOException {
        Query rangeQ = ((DateField)sf.getType()).getRangeQuery(null, sf, low, high, iLow, iHigh);
        return (int)OpenBitSet.intersectionCount((OpenBitSet)this.getDocIdSet(rangeQ, ""), (OpenBitSet)this.base);
    }

    protected int rangeCount(Query rangeQuery) throws IOException {
        return (int)OpenBitSet.intersectionCount((OpenBitSet)this.getDocIdSet(rangeQuery, null), (OpenBitSet)this.docs);
    }

    private OpenBitSet getDocIdSet(Query query, final String locale) {
        OpenBitSetDISI docIds = null;
        try {
            final BitSet bitset = new BitSet();
            this.searcher.search(query, (Collector)new AbstractHitCollector(){

                public void collect(int docId, float scorer) {
                    if (locale != null) {
                        try {
                            int docMainDocId = SimpleJahiaJcrFacets.this.getMainDocIdForTranslations(SimpleJahiaJcrFacets.this.searcher.getIndexReader().document(docId, TRANSLATION_FIELDS), locale);
                            if (docMainDocId != -1) {
                                bitset.set(docMainDocId);
                            }
                        }
                        catch (Exception e) {
                            logger.warn("Error getting index document while faceting", (Throwable)e);
                        }
                    }
                    bitset.set(docId);
                }

                public boolean acceptsDocsOutOfOrder() {
                    return true;
                }
            });
            docIds = new OpenBitSetDISI(new DocIdBitSet(bitset).iterator(), bitset.size());
        }
        catch (IOException e) {
            logger.debug("Can't retrive bitset from hits", (Throwable)e);
        }
        return docIds;
    }

    public OpenBitSet getDocIdSet(List<Query> queries, String locale) throws IOException {
        int i;
        if (queries == null) {
            return null;
        }
        if (queries.size() == 1) {
            return this.getDocIdSet(queries.get(0), locale);
        }
        OpenBitSet answer = null;
        boolean[] neg = new boolean[queries.size()];
        OpenBitSet[] sets = new OpenBitSet[queries.size()];
        int smallestIndex = -1;
        int smallestCount = Integer.MAX_VALUE;
        for (i = 0; i < sets.length; ++i) {
            Query q = queries.get(i);
            Query posQuery = SimpleJahiaJcrFacets.getAbs(q);
            sets[i] = this.getPositiveDocSet(posQuery, locale);
            if (q == posQuery) {
                neg[i] = false;
                int sz = (int)sets[i].size();
                if (sz >= smallestCount) continue;
                smallestCount = sz;
                smallestIndex = i;
                answer = sets[i];
                continue;
            }
            neg[i] = true;
        }
        if (answer == null) {
            answer = this.getPositiveDocSet(matchAllDocsQuery, locale);
        }
        for (i = 0; i < sets.length; ++i) {
            if (!neg[i]) continue;
            answer.andNot(sets[i]);
        }
        for (i = 0; i < sets.length; ++i) {
            if (neg[i] || i == smallestIndex) continue;
            answer.intersect(sets[i]);
        }
        return answer;
    }

    static Query getAbs(Query q) {
        if (!(q instanceof BooleanQuery)) {
            return q;
        }
        BooleanQuery bq = (BooleanQuery)q;
        List clauses = bq.clauses();
        if (clauses.size() == 0) {
            return q;
        }
        for (BooleanClause clause : clauses) {
            if (clause.isProhibited()) continue;
            return q;
        }
        if (clauses.size() == 1) {
            Query negClause = ((BooleanClause)clauses.get(0)).getQuery();
            return negClause;
        }
        BooleanQuery newBq = new BooleanQuery(bq.isCoordDisabled());
        newBq.setBoost(bq.getBoost());
        for (BooleanClause clause : clauses) {
            newBq.add(clause.getQuery(), BooleanClause.Occur.SHOULD);
        }
        return newBq;
    }

    OpenBitSet getPositiveDocSet(Query q, final String locale) throws IOException {
        final BitSet bitset = new BitSet();
        this.searcher.search(q, (Collector)new AbstractHitCollector(){

            public void collect(int docId, float scorer) {
                if (locale != null) {
                    try {
                        int docMainDocId = SimpleJahiaJcrFacets.this.getMainDocIdForTranslations(SimpleJahiaJcrFacets.this.searcher.getIndexReader().document(docId, TRANSLATION_FIELDS), locale);
                        if (docMainDocId != -1) {
                            bitset.set(docMainDocId);
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Error getting index document while faceting", (Throwable)e);
                    }
                }
                bitset.set(docId);
            }

            public boolean acceptsDocsOutOfOrder() {
                return true;
            }
        });
        OpenBitSetDISI answer = new OpenBitSetDISI(new DocIdBitSet(bitset).iterator(), bitset.size());
        return answer;
    }

    public int maxDoc() throws IOException {
        return this.searcher.getIndexReader().maxDoc();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getMainDocIdForTranslations(Document doc, String locale) {
        int docId = -1;
        Field parentNode = doc.getField(JahiaNodeIndexer.TRANSLATED_NODE_PARENT);
        if (parentNode == null) return docId;
        if (!StringUtils.isEmpty((String)locale)) {
            if (!locale.equals(doc.getField(JahiaNodeIndexer.TRANSLATION_LANGUAGE).stringValue())) return docId;
        }
        try {
            String id = doc.getField(FieldNames.PARENT).stringValue();
            try (TermDocs docs = this.searcher.getIndexReader().termDocs(new Term(FieldNames.UUID, id));){
                if (!docs.next()) throw new IOException("Node with id " + id + " not found in index");
                int n = docs.doc();
                return n;
            }
        }
        catch (IOException e) {
            logger.debug("Can't retrive parent node of translation node", (Throwable)e);
        }
        return docId;
    }

    private FieldType getType(ExtendedPropertyDefinition epd) {
        BinaryField type = null;
        switch (epd.getRequiredType()) {
            case 2: {
                type = JahiaQueryParser.BINARY_TYPE;
                break;
            }
            case 6: {
                type = JahiaQueryParser.BOOLEAN_TYPE;
                break;
            }
            case 5: {
                type = epd.isFacetable() ? JahiaQueryParser.DATE_TYPE : JahiaQueryParser.JR_DATE_TYPE;
                break;
            }
            case 4: {
                type = epd.isFacetable() ? JahiaQueryParser.SORTABLE_DOUBLE_TYPE : JahiaQueryParser.JR_DOUBLE_TYPE;
                break;
            }
            case 3: {
                type = epd.isFacetable() ? JahiaQueryParser.SORTABLE_LONG_TYPE : JahiaQueryParser.JR_LONG_TYPE;
                break;
            }
            case 7: {
                type = JahiaQueryParser.STRING_TYPE;
                break;
            }
            case 8: {
                type = JahiaQueryParser.STRING_TYPE;
                break;
            }
            case 9: {
                type = JahiaQueryParser.STRING_TYPE;
                break;
            }
            case 1: {
                type = JahiaQueryParser.STRING_TYPE;
                break;
            }
            case 11: {
                type = JahiaQueryParser.STRING_TYPE;
                break;
            }
            case 10: {
                type = JahiaQueryParser.STRING_TYPE;
                break;
            }
            case 12: {
                throw new UnsupportedOperationException();
            }
        }
        return type;
    }

    private static class DateRangeEndpointCalculator
    extends RangeEndpointCalculator<Date> {
        private final Date now;

        public DateRangeEndpointCalculator(SchemaField f, Date now) {
            super(f);
            this.now = now;
            if (!(this.field.getType() instanceof DateField)) {
                throw new IllegalArgumentException("SchemaField must use filed type extending DateField");
            }
        }

        @Override
        public String formatValue(Date val) {
            return ((DateField)this.field.getType()).toExternal(val);
        }

        @Override
        protected Date parseVal(String rawval) {
            return ((DateField)this.field.getType()).parseMath(this.now, rawval);
        }

        @Override
        protected Object parseGap(String rawval) {
            return rawval;
        }

        @Override
        public Date parseAndAddGap(Date value, String gap) throws java.text.ParseException {
            DateMathParser dmp = new DateMathParser(DateField.UTC, Locale.US);
            dmp.setNow(value);
            return dmp.parseMath(gap);
        }
    }

    private static class LongRangeEndpointCalculator
    extends RangeEndpointCalculator<Long> {
        public LongRangeEndpointCalculator(SchemaField f) {
            super(f);
        }

        @Override
        protected Long parseVal(String rawval) {
            return Long.valueOf(rawval);
        }

        @Override
        public Long parseAndAddGap(Long value, String gap) {
            return value + Long.valueOf(gap);
        }
    }

    private static class IntegerRangeEndpointCalculator
    extends RangeEndpointCalculator<Integer> {
        public IntegerRangeEndpointCalculator(SchemaField f) {
            super(f);
        }

        @Override
        protected Integer parseVal(String rawval) {
            return Integer.valueOf(rawval);
        }

        @Override
        public Integer parseAndAddGap(Integer value, String gap) {
            return value + Integer.valueOf(gap);
        }
    }

    private static class DoubleRangeEndpointCalculator
    extends RangeEndpointCalculator<Double> {
        public DoubleRangeEndpointCalculator(SchemaField f) {
            super(f);
        }

        @Override
        protected Double parseVal(String rawval) {
            return Double.valueOf(rawval);
        }

        @Override
        public Double parseAndAddGap(Double value, String gap) {
            return value + Double.valueOf(gap);
        }
    }

    private static class FloatRangeEndpointCalculator
    extends RangeEndpointCalculator<Float> {
        public FloatRangeEndpointCalculator(SchemaField f) {
            super(f);
        }

        @Override
        protected Float parseVal(String rawval) {
            return Float.valueOf(rawval);
        }

        @Override
        public Float parseAndAddGap(Float value, String gap) {
            return Float.valueOf(value.floatValue() + Float.valueOf(gap).floatValue());
        }
    }

    private static abstract class RangeEndpointCalculator<T extends Comparable<T>> {
        protected final SchemaField field;

        public RangeEndpointCalculator(SchemaField field) {
            this.field = field;
        }

        public String formatValue(T val) {
            return val.toString();
        }

        public final T getValue(String rawval) {
            try {
                return this.parseVal(rawval);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't parse value " + rawval + " for field: " + this.field.getName(), (Throwable)e);
            }
        }

        protected abstract T parseVal(String var1) throws java.text.ParseException;

        public final Object getGap(String gap) {
            try {
                return this.parseGap(gap);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't parse gap " + gap + " for field: " + this.field.getName(), (Throwable)e);
            }
        }

        protected Object parseGap(String rawval) throws java.text.ParseException {
            return this.parseVal(rawval);
        }

        public final T addGap(T value, String gap) {
            try {
                return this.parseAndAddGap(value, gap);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't add gap " + gap + " to value " + value + " for field: " + this.field.getName(), (Throwable)e);
            }
        }

        protected abstract T parseAndAddGap(T var1, String var2) throws java.text.ParseException;
    }
}

