/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.seo.urlrewrite;

import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.jahia.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceChecksumCalculator {
    private static Map<String, String> checksums = new ConcurrentHashMap<String, String>();
    private static final Logger logger = LoggerFactory.getLogger(ResourceChecksumCalculator.class);

    public static void flushChecksumCache() {
        checksums.clear();
    }

    public void calculateChecksum(HttpServletRequest request, String ctx, String resourcePath) {
        request.setAttribute("ResourceChecksumCalculator.checksum", (Object)this.getChecksum(request, resourcePath));
    }

    private String getChecksum(HttpServletRequest request, String resourcePath) {
        String checksum = checksums.get(resourcePath);
        if (checksum == null) {
            long startTime = System.currentTimeMillis();
            InputStream resourceAsStream = request.getServletContext().getResourceAsStream(resourcePath);
            checksum = resourceAsStream != null ? FileUtils.calculateDigest(resourceAsStream) : "0";
            checksums.put(resourcePath, checksum);
            if (logger.isDebugEnabled()) {
                logger.debug("Checksum for resource {} calculated in {} ms: {}", new Object[]{resourcePath, System.currentTimeMillis() - startTime, checksum});
            }
        }
        return checksum;
    }
}

