/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.seo.urlrewrite;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jahia.exceptions.JahiaException;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.seo.urlrewrite.UrlRewriteService;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Url;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerNameToSiteMapper {
    public static final String ATTR_NAME_CMS_TOKEN = "jahiaSeoCmsToken";
    public static final String ATTR_NAME_DEFAULT_LANG = "siteDefaultLanguage";
    public static final String ATTR_NAME_DEFAULT_LANG_MATCHES = "jahiaSiteKeyMatchesDefaultLanguage";
    public static final String ATTR_NAME_LANG_TOKEN = "jahiaSeoLanguageToken";
    public static final String ATTR_NAME_ADD_CMS_PREFIX = "jahiaSeoAddCmsPrefix";
    public static final String ATTR_NAME_SITE_KEY = "jahiaSiteKeyForCurrentServerName";
    @Deprecated
    public static final String ATTR_NAME_SITE_KEY_FOR_LINK = "jahiaSiteKeyForLink";
    public static final String ATTR_NAME_SERVERNAME_FOR_LINK = "jahiaSeoServernameForLink";
    public static final String ATTR_NAME_SITE_KEY_MATCHES = "jahiaSiteKeyMatchesCurrentServerName";
    public static final String ATTR_NAME_SKIP_INBOUND_SEO_RULES = "jahiaSkipInboundSeoRules";
    public static final String ATTR_NAME_VANITY_LANG = "vanityUrlTargetLang";
    public static final String ATTR_NAME_VANITY_PATH = "vanityUrlTargetPath";
    public static final String ATTR_NAME_CONTEXT_PATH = "contextPath";
    private static final Logger logger = LoggerFactory.getLogger(ServerNameToSiteMapper.class);
    private UrlRewriteService urlRewriteService;

    public static String getSiteKeyByServerName(HttpServletRequest request) {
        String targetSiteKey = (String)request.getAttribute(ATTR_NAME_SITE_KEY);
        if (targetSiteKey != null) {
            return targetSiteKey;
        }
        String host = request.getServerName();
        if (StringUtils.isEmpty((String)host) || Url.isLocalhost(host)) {
            targetSiteKey = "";
        } else {
            targetSiteKey = StringUtils.defaultString((String)ServerNameToSiteMapper.lookupSiteKeyByServerName(host));
            if (logger.isDebugEnabled()) {
                if (targetSiteKey.length() > 0) {
                    logger.debug("Mapping server name {} to site key {}", (Object)host, (Object)targetSiteKey);
                } else {
                    logger.debug("No site mapping found for server name {}", (Object)host);
                }
            }
        }
        request.setAttribute(ATTR_NAME_SITE_KEY, (Object)targetSiteKey);
        return targetSiteKey;
    }

    private static String lookupSiteKeyByServerName(String host) {
        String site = null;
        if (SpringContextSingleton.getInstance().isInitialized()) {
            try {
                site = JahiaSitesService.getInstance().getSitenameByServerName(host);
            }
            catch (JahiaException e) {
                logger.error("Error resolving site by server name '" + host + "'", (Throwable)e);
            }
        }
        return site != null ? site : "";
    }

    private UrlRewriteService getUrlRewriteService() {
        if (this.urlRewriteService == null) {
            this.urlRewriteService = (UrlRewriteService)SpringContextSingleton.getBean("UrlRewriteService");
        }
        return this.urlRewriteService;
    }

    public void canResolveSiteByServerName(HttpServletRequest request, String ctx, String language, String siteKey) {
        this.analyzeLink(request, ctx, language, siteKey, null);
    }

    public void analyzeLink(HttpServletRequest request, String ctx, String language, String siteKey, String path) {
        String currentSiteKey = ServerNameToSiteMapper.getSiteKeyByServerName(request);
        boolean matches = currentSiteKey.equals(siteKey);
        request.setAttribute(ATTR_NAME_SITE_KEY_MATCHES, (Object)matches);
        try {
            boolean languageMatches = JahiaSitesService.getInstance().getSiteDefaultLanguage(siteKey).equals(language);
            request.setAttribute(ATTR_NAME_DEFAULT_LANG_MATCHES, (Object)languageMatches);
            request.setAttribute(ATTR_NAME_LANG_TOKEN, (Object)(languageMatches ? "" : "/" + language));
        }
        catch (JahiaException e) {
            logger.error("Error resolving language " + language + " for siteKey '" + siteKey + "'", (Throwable)e);
        }
        if (!matches && currentSiteKey.length() > 0 && SettingsBean.getInstance().isUrlRewriteUseAbsoluteUrls()) {
            String serverName;
            JahiaSite siteByKey = null;
            try {
                siteByKey = JahiaSitesService.getInstance().getSiteByKey(siteKey);
            }
            catch (JahiaException e) {
                logger.error("Error resolving site for site key " + siteKey, (Throwable)e);
            }
            String string = serverName = siteByKey != null && !Url.isLocalhost(siteByKey.getServerName()) ? siteByKey.getServerName() : null;
            if (StringUtils.isNotEmpty(serverName)) {
                int port = SettingsBean.getInstance().getSiteURLPortOverride();
                if (port == 0) {
                    port = request.getServerPort();
                }
                if (!(port == 80 && "http".equals(request.getScheme()) || port == 443 && "https".equals(request.getScheme()))) {
                    serverName = serverName + ":" + port;
                }
            }
            request.setAttribute(ATTR_NAME_SITE_KEY_FOR_LINK, (Object)serverName);
            request.setAttribute(ATTR_NAME_SERVERNAME_FOR_LINK, serverName != null ? request.getScheme() + "://" + serverName : null);
        }
        this.checkCmsPrefix(request, ctx, path);
        if (logger.isDebugEnabled()) {
            logger.debug("analyzeLink({}, {}, {}, {}) | currentSiteKey={} targetSiteKey={} matches={}", new Object[]{ctx, language, siteKey, path, currentSiteKey, siteKey, matches});
        }
    }

    public void getLinkLocale(HttpServletRequest request, String ctx, String path) {
        String linkLocale = request.getAttribute("currentLocale").toString();
        if (path.startsWith("/sites/")) {
            String siteKey = StringUtils.substringBetween((String)path, (String)"/sites/", (String)"/");
            try {
                JahiaSite site = JahiaSitesService.getInstance().getSiteByKey(siteKey);
                if (site != null && !site.getLanguages().contains(linkLocale)) {
                    linkLocale = site.getDefaultLanguage();
                }
            }
            catch (JahiaException jahiaException) {
                // empty catch block
            }
        }
        request.setAttribute("currentLinkLocale", (Object)linkLocale);
    }

    public void analyzeLink(HttpServletRequest request, String ctx, String siteKey, String path) {
        this.analyzeLink(request, ctx, null, siteKey, path);
    }

    public void checkCmsPrefix(HttpServletRequest request, String ctx, String input) {
        boolean doRemove = this.getUrlRewriteService().isSeoRemoveCmsPrefix();
        if (doRemove && input.length() > 0) {
            int end = input.indexOf(47);
            end = end == -1 ? input.indexOf(63) : end;
            boolean bl = doRemove = !this.getUrlRewriteService().isResrvedPrefix(end != -1 ? input.substring(0, end) : input);
            if (logger.isDebugEnabled()) {
                logger.info("checkCmsPrefix({}): {}", (Object)input, (Object)doRemove);
            }
        }
        request.setAttribute(ATTR_NAME_CMS_TOKEN, (Object)(doRemove ? "" : "/cms"));
    }

    public void resetStateForOutboundUrl(HttpServletRequest request) {
        request.removeAttribute(ATTR_NAME_CMS_TOKEN);
        request.removeAttribute(ATTR_NAME_DEFAULT_LANG);
        request.removeAttribute(ATTR_NAME_DEFAULT_LANG_MATCHES);
        request.removeAttribute(ATTR_NAME_LANG_TOKEN);
        request.removeAttribute(ATTR_NAME_SITE_KEY_FOR_LINK);
        request.removeAttribute(ATTR_NAME_SERVERNAME_FOR_LINK);
        request.removeAttribute(ATTR_NAME_SITE_KEY_MATCHES);
        request.removeAttribute("org.jahia.services.seo.jcr.VanityUrl");
    }
}

