/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.uicomponents.bean.editmode;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.widget.contentengine.ButtonItem;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.uicomponents.bean.contentmanager.ManagerConfiguration;
import org.jahia.services.uicomponents.bean.editmode.EditConfiguration;
import org.jahia.services.uicomponents.bean.editmode.EngineTab;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class EngineConfiguration
implements Serializable,
InitializingBean,
DisposableBean,
ApplicationContextAware {
    private static final long serialVersionUID = -5991528610464460659L;
    private String key;
    private List<EngineTab> engineTabs;
    private List<ButtonItem> creationButtons = new ArrayList<ButtonItem>();
    private List<ButtonItem> editionButtons = new ArrayList<ButtonItem>();
    private List<ButtonItem> commonButtons = new ArrayList<ButtonItem>();
    private Object parent;
    private ApplicationContext applicationContext;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List<EngineTab> getEngineTabs() {
        return this.engineTabs;
    }

    public void setEngineTabs(List<EngineTab> engineTabs) {
        this.engineTabs = engineTabs;
    }

    public List<ButtonItem> getCreationButtons() {
        return this.creationButtons;
    }

    public void setCreationButtons(List<ButtonItem> creationButtons) {
        this.creationButtons = creationButtons;
    }

    public List<ButtonItem> getEditionButtons() {
        return this.editionButtons;
    }

    public void setEditionButtons(List<ButtonItem> editionButtons) {
        this.editionButtons = editionButtons;
    }

    public List<ButtonItem> getCommonButtons() {
        return this.commonButtons;
    }

    public void setCommonButtons(List<ButtonItem> commonButtons) {
        this.commonButtons = commonButtons;
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.parent instanceof List) {
            for (Object o : (List)this.parent) {
                this.addToParent(o);
            }
        } else {
            this.addToParent(this.parent);
        }
    }

    public void destroy() throws Exception {
        if (!JahiaContextLoaderListener.isRunning()) {
            return;
        }
        if (this.parent instanceof List) {
            for (Object o : (List)this.parent) {
                this.removeFromParent(o);
            }
        } else {
            this.removeFromParent(this.parent);
        }
    }

    private void removeFromParent(Object o) {
        List<Map<String, EngineConfiguration>> configs = this.getParentConfigurationMap(o);
        for (Map<String, EngineConfiguration> config : configs) {
            config.remove(this.getKey());
        }
    }

    private void addToParent(Object o) {
        List<Map<String, EngineConfiguration>> configs = this.getParentConfigurationMap(o);
        if (!configs.isEmpty()) {
            for (Map<String, EngineConfiguration> config : configs) {
                config.put(this.getKey(), this);
            }
        } else if (o != null) {
            throw new IllegalArgumentException("Unknown parent type '" + o.getClass().getName() + "'. Can accept EditConfiguration, ManagerConfiguration, Engine or a String value with a beanId of the those beans");
        }
    }

    private List<Map<String, EngineConfiguration>> getParentConfigurationMap(Object parent) {
        ArrayList<Map<String, EngineConfiguration>> results;
        block3: {
            block2: {
                results = new ArrayList<Map<String, EngineConfiguration>>();
                if (!(parent instanceof EditConfiguration)) break block2;
                results.add(((EditConfiguration)parent).getEngineConfigurations());
                for (Map.Entry<String, EditConfiguration> entry : SpringContextSingleton.getBeansOfType(this.applicationContext, EditConfiguration.class).entrySet()) {
                    if (!entry.getKey().startsWith(((EditConfiguration)parent).getName() + "-")) continue;
                    results.addAll(this.getParentConfigurationMap(entry.getValue()));
                }
                break block3;
            }
            if (!(parent instanceof ManagerConfiguration)) break block3;
            results.add(((ManagerConfiguration)parent).getEngineConfigurations());
            for (Map.Entry<String, ManagerConfiguration> entry : SpringContextSingleton.getBeansOfType(this.applicationContext, ManagerConfiguration.class).entrySet()) {
                if (!entry.getKey().startsWith(((ManagerConfiguration)parent).getName() + "-")) continue;
                results.addAll(this.getParentConfigurationMap(entry.getValue()));
            }
        }
        return results;
    }
}

