/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.uicomponents.bean.editmode;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.SidePanelTabItem;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.uicomponents.bean.Visibility;
import org.jahia.services.uicomponents.bean.contentmanager.Column;
import org.jahia.services.uicomponents.bean.editmode.EditConfiguration;
import org.jahia.services.uicomponents.bean.toolbar.Toolbar;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SidePanelTab
implements Serializable,
BeanNameAware,
InitializingBean,
DisposableBean,
ApplicationContextAware {
    private static final long serialVersionUID = -4170052202882342097L;
    private String name;
    private String key;
    private Toolbar treeContextMenu;
    private Toolbar tableContextMenu;
    private Map<String, String> params;
    private Visibility visibility;
    private List<Column> treeColumns;
    private List<Column> tableColumns = new ArrayList<Column>();
    private String icon;
    private SidePanelTabItem tabItem;
    private String requiredPermission;
    private Object parent;
    private int position = -1;
    private String positionAfter;
    private String positionBefore;
    private ApplicationContext applicationContext;

    public SidePanelTab() {
        this.treeColumns = new ArrayList<Column>();
    }

    public SidePanelTab(String key) {
        this();
        this.setKey(key);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Toolbar getTreeContextMenu() {
        return this.treeContextMenu;
    }

    public void setTreeContextMenu(Toolbar treeContextMenu) {
        this.treeContextMenu = treeContextMenu;
    }

    public Toolbar getTableContextMenu() {
        return this.tableContextMenu;
    }

    public void setTableContextMenu(Toolbar tableContextMenu) {
        this.tableContextMenu = tableContextMenu;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public String getRequiredPermission() {
        return this.requiredPermission;
    }

    public void setRequiredPermission(String requiredPermission) {
        this.requiredPermission = requiredPermission;
    }

    public List<Column> getTableColumns() {
        return this.tableColumns;
    }

    public void setTableColumns(List<Column> tableColumns) {
        this.tableColumns = tableColumns;
    }

    public List<Column> getTreeColumns() {
        return this.treeColumns;
    }

    public void setTreeColumns(List<Column> treeColumns) {
        this.treeColumns = treeColumns;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public SidePanelTabItem getTabItem() {
        return this.tabItem;
    }

    public void setTabItem(SidePanelTabItem tabItem) {
        this.tabItem = tabItem;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setPositionAfter(String positionAfter) {
        this.positionAfter = positionAfter;
    }

    public void setPositionBefore(String positionBefore) {
        this.positionBefore = positionBefore;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            SidePanelTab other = (SidePanelTab)obj;
            return this.getKey() != null ? other.getKey() != null && this.getKey().equals(other.getKey()) : other.getKey() == null;
        }
        return false;
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.parent != null) {
            if (this.parent instanceof List) {
                for (Object o : (List)this.parent) {
                    this.addTab(this.getSidePanelTabs(o));
                }
            } else {
                this.addTab(this.getSidePanelTabs(this.parent));
            }
        }
    }

    private void addTab(List<List<SidePanelTab>> tabs) {
        if (!tabs.isEmpty()) {
            this.removeTab(tabs, this.getKey());
            for (List<SidePanelTab> t : tabs) {
                int index = -1;
                if (this.position >= 0) {
                    index = this.position;
                } else if (this.positionBefore != null) {
                    index = t.indexOf(new SidePanelTab(this.positionBefore));
                } else if (this.positionAfter != null) {
                    index = t.indexOf(new SidePanelTab(this.positionAfter));
                    if (index != -1) {
                        ++index;
                    }
                    if (index >= t.size()) {
                        index = -1;
                    }
                }
                if (index != -1) {
                    t.add(index, this);
                    continue;
                }
                t.add(this);
            }
        } else if (this.parent != null) {
            throw new IllegalArgumentException("Unknown parent type '" + this.parent.getClass().getName() + "'. Can accept EditConfiguration or a String value with a beanId of the EditConfiguration bean");
        }
    }

    public void destroy() throws Exception {
        if (!JahiaContextLoaderListener.isRunning()) {
            return;
        }
        if (this.parent instanceof List) {
            for (Object o : (List)this.parent) {
                this.removeTab(this.getSidePanelTabs(o), this.getKey());
            }
        } else {
            this.removeTab(this.getSidePanelTabs(this.parent), this.getKey());
        }
    }

    private void removeTab(List<List<SidePanelTab>> tabs, String tabKey) {
        if (!tabs.isEmpty() && tabKey != null && !tabKey.isEmpty()) {
            for (List<SidePanelTab> t : tabs) {
                Iterator<SidePanelTab> iterator = t.iterator();
                while (iterator.hasNext()) {
                    SidePanelTab tab = iterator.next();
                    if (!tabKey.equals(tab.getKey())) continue;
                    iterator.remove();
                }
            }
        }
    }

    private List<List<SidePanelTab>> getSidePanelTabs(Object parent) {
        ArrayList<List<SidePanelTab>> results = new ArrayList<List<SidePanelTab>>();
        if (parent == null) {
            return results;
        }
        if (parent instanceof String) {
            parent = SpringContextSingleton.getBean((String)parent);
        }
        List<SidePanelTab> tabs = null;
        if (parent instanceof EditConfiguration) {
            tabs = ((EditConfiguration)parent).getTabs();
            if (tabs == null) {
                tabs = new LinkedList<SidePanelTab>();
                ((EditConfiguration)parent).setTabs(tabs);
            }
            for (Map.Entry<String, EditConfiguration> entry : SpringContextSingleton.getBeansOfType(this.applicationContext, EditConfiguration.class).entrySet()) {
                if (!entry.getKey().startsWith(((EditConfiguration)parent).getName() + "-")) continue;
                results.addAll(this.getSidePanelTabs(entry.getValue()));
            }
        }
        results.add(tabs);
        return results;
    }
}

