/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.usermanager;

import java.io.Serializable;
import java.util.Properties;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.UserProperties;
import org.jahia.services.usermanager.UserProperty;

public class JahiaUserImpl
implements JahiaUser,
Serializable {
    private static final long serialVersionUID = -133494787519812151L;
    private final String name;
    private final String path;
    private final String realm;
    private final Properties properties;
    private final boolean isRoot;
    private final String providerName;

    public JahiaUserImpl(String name, String path, Properties properties, String providerName) {
        this(name, path, properties, false, providerName, null);
    }

    public JahiaUserImpl(String name, String path, Properties properties, boolean isRoot, String providerName) {
        this(name, path, properties, isRoot, providerName, null);
    }

    public JahiaUserImpl(String name, String path, Properties properties, String providerName, String realm) {
        this(name, path, properties, false, providerName, realm);
    }

    public JahiaUserImpl(String name, String path, Properties properties, boolean isRoot, String providerName, String realm) {
        this.name = name;
        this.path = path;
        this.properties = properties;
        this.isRoot = isRoot;
        this.providerName = providerName;
        this.realm = realm;
    }

    @Override
    public String getUsername() {
        return this.name;
    }

    @Override
    public String getUserKey() {
        return this.path;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public UserProperties getUserProperties() {
        return new UserProperties(this.properties, true);
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public UserProperty getUserProperty(String key) {
        return this.getUserProperties().getUserProperty(key);
    }

    @Override
    public boolean removeProperty(String key) {
        throw new UnsupportedOperationException("Setter not supported here, use JCRUserNode instead");
    }

    @Override
    public boolean setProperty(String key, String value) {
        throw new UnsupportedOperationException("Setter not supported here, use JCRUserNode instead");
    }

    @Override
    public boolean setPassword(String password) {
        throw new UnsupportedOperationException("Setter not supported here, use JCRUserNode instead");
    }

    @Override
    public boolean isMemberOfGroup(int siteID, String name) {
        throw new UnsupportedOperationException("Site id not supported, use sitekey");
    }

    @Override
    public boolean isAdminMember(int siteID) {
        throw new UnsupportedOperationException("Site id not supported, use sitekey");
    }

    @Override
    public boolean isRoot() {
        return this.isRoot;
    }

    @Override
    public boolean verifyPassword(String password) {
        throw new UnsupportedOperationException("Method not supported here, use JCRUserNode instead");
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLocalPath() {
        return this.path;
    }

    @Override
    public boolean isAccountLocked() {
        return !this.isRoot() && Boolean.valueOf(this.getProperty("j:accountLocked")) != false;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JahiaUserImpl jahiaUser = (JahiaUserImpl)o;
        return this.path.equals(jahiaUser.path);
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }
}

