/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.webdav;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.j2ee.JahiaResourceFactoryImpl;
import org.apache.jackrabbit.webdav.simple.DefaultItemFilter;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaItemFilter
extends DefaultItemFilter {
    private static final Logger logger = LoggerFactory.getLogger(JahiaItemFilter.class);
    private Boolean directoryListingDisabled;

    public JahiaItemFilter() {
        this.init();
    }

    private void init() {
        try {
            this.directoryListingDisabled = Boolean.valueOf(SettingsBean.getInstance().getPropertiesFile().getProperty("repositoryDirectoryListingDisabled", "false"));
        }
        catch (Exception e) {
            logger.error("Error initializing Jahia WebDAV item filter", (Throwable)e);
        }
    }

    public boolean isFilteredItem(Item item) {
        if (this.directoryListingDisabled.booleanValue()) {
            return true;
        }
        NodeType nt = null;
        try {
            nt = item.isNode() ? ((Node)item).getPrimaryNodeType() : ((Property)item).getDefinition().getDeclaringNodeType();
        }
        catch (RepositoryException re) {
            logger.warn("Error filtering item " + item.toString(), (Throwable)re);
        }
        if (nt == null) {
            return super.isFilteredItem(item);
        }
        if (JahiaResourceFactoryImpl.isAllowed(nt)) {
            return super.isFilteredItem(item);
        }
        return true;
    }

    public boolean isFilteredItem(String name, Session session) {
        if (this.directoryListingDisabled.booleanValue()) {
            return true;
        }
        return super.isFilteredItem(name, session);
    }
}

