/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.jackrabbit.util.ISO9075;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.persistence.PersistenceContextManager;
import org.drools.persistence.TransactionManager;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.pipelines.Pipeline;
import org.jahia.services.JahiaAfterInitializationService;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.workflow.HistoryWorkflow;
import org.jahia.services.workflow.HistoryWorkflowTask;
import org.jahia.services.workflow.Workflow;
import org.jahia.services.workflow.WorkflowAction;
import org.jahia.services.workflow.WorkflowDefinition;
import org.jahia.services.workflow.WorkflowObservationManager;
import org.jahia.services.workflow.WorkflowObservationManagerAware;
import org.jahia.services.workflow.WorkflowProvider;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.services.workflow.WorkflowTask;
import org.jahia.services.workflow.jbpm.BaseCommand;
import org.jahia.services.workflow.jbpm.JBPMListener;
import org.jahia.services.workflow.jbpm.JahiaKModuleRegisterableItemsFactory;
import org.jahia.services.workflow.jbpm.JahiaRuntimeManagerFactoryImpl;
import org.jahia.services.workflow.jbpm.JahiaUserGroupCallback;
import org.jahia.services.workflow.jbpm.command.AbortProcessCommand;
import org.jahia.services.workflow.jbpm.command.AddCommentCommand;
import org.jahia.services.workflow.jbpm.command.AssignTaskCommand;
import org.jahia.services.workflow.jbpm.command.CompleteTaskCommand;
import org.jahia.services.workflow.jbpm.command.GetActiveWorkflowsInformationsCommand;
import org.jahia.services.workflow.jbpm.command.GetAvailableActionsCommand;
import org.jahia.services.workflow.jbpm.command.GetAvailableWorkflowsCommand;
import org.jahia.services.workflow.jbpm.command.GetHistoryWorkflowCommand;
import org.jahia.services.workflow.jbpm.command.GetHistoryWorkflowTasksCommand;
import org.jahia.services.workflow.jbpm.command.GetHistoryWorkflowsForNodeCommand;
import org.jahia.services.workflow.jbpm.command.GetHistoryWorkflowsForPathCommand;
import org.jahia.services.workflow.jbpm.command.GetTasksForUserCommand;
import org.jahia.services.workflow.jbpm.command.GetWorkflowCommand;
import org.jahia.services.workflow.jbpm.command.GetWorkflowDefinitionCommand;
import org.jahia.services.workflow.jbpm.command.GetWorkflowTaskCommand;
import org.jahia.services.workflow.jbpm.command.GetWorkflowsForDefinitionCommand;
import org.jahia.services.workflow.jbpm.command.GetWorkflowsForUserCommand;
import org.jahia.services.workflow.jbpm.command.StartProcessCommand;
import org.jahia.services.workflow.jbpm.custom.AbstractTaskLifeCycleEventListener;
import org.jbpm.runtime.manager.impl.RuntimeEnvironmentBuilder;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.jbpm.shared.services.impl.JbpmServicesPersistenceManagerImpl;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieRepository;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.Status;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.task.api.EventService;
import org.kie.spring.persistence.KieSpringJpaManager;
import org.kie.spring.persistence.KieSpringTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;

public class JBPM6WorkflowProvider
implements WorkflowProvider,
WorkflowObservationManagerAware,
JahiaAfterInitializationService {
    public static final List<Status> OPEN_STATUS_LIST = Arrays.asList(Status.Created, Status.InProgress, Status.Ready, Status.Reserved);
    public static final List<Status> OPEN_STATUS_LIST_NON_RESERVED = Arrays.asList(Status.Created, Status.InProgress, Status.Ready);
    public static final List<Status> RESERVED_STATUS_LIST = Arrays.asList(Status.Reserved);
    private static final Logger logger = LoggerFactory.getLogger(JBPM6WorkflowProvider.class);
    private static final JBPM6WorkflowProvider instance = new JBPM6WorkflowProvider();
    private String key;
    private WorkflowService workflowService;
    private WorkflowObservationManager observationManager;
    private JahiaUserManagerService userManager;
    private JahiaGroupManagerService groupManager;
    private KieRepository kieRepository;
    private KieServices kieServices;
    private KieFileSystem kieFileSystem;
    private JBPMListener listener = new JBPMListener(this);
    private RuntimeManager runtimeManager;
    private RuntimeEngine runtimeEngine;
    private AbstractPlatformTransactionManager platformTransactionManager;
    private EntityManagerFactory emf;
    private EntityManager sharedEm;
    private JbpmServicesPersistenceManagerImpl jbpmServicesPersistenceManager;
    private Map<String, WorkItemHandler> workItemHandlers = new TreeMap<String, WorkItemHandler>();
    private Map<String, AbstractTaskLifeCycleEventListener> taskLifeCycleEventListeners = new TreeMap<String, AbstractTaskLifeCycleEventListener>();
    private Pipeline peopleAssignmentPipeline;
    private JahiaUserGroupCallback jahiaUserGroupCallback;
    private KieContainer kieContainer;
    private TransactionManager transactionManager;
    private ThreadLocal<Boolean> loop = new ThreadLocal();
    private volatile boolean isInitialized = false;
    private Map<String, Map<Locale, WorkflowDefinition>> definitionMap = new HashMap<String, Map<Locale, WorkflowDefinition>>();

    public static JBPM6WorkflowProvider getInstance() {
        return instance;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @Override
    public void setWorkflowObservationManager(WorkflowObservationManager observationManager) {
        this.observationManager = observationManager;
        this.listener.setObservationManager(observationManager);
    }

    public void setGroupManager(JahiaGroupManagerService groupManager) {
        this.groupManager = groupManager;
    }

    public void setUserManager(JahiaUserManagerService userManager) {
        this.userManager = userManager;
    }

    public void setPeopleAssignmentPipeline(Pipeline peopleAssignmentPipeline) {
        this.peopleAssignmentPipeline = peopleAssignmentPipeline;
    }

    public void setJahiaUserGroupCallback(JahiaUserGroupCallback jahiaUserGroupCallback) {
        this.jahiaUserGroupCallback = jahiaUserGroupCallback;
    }

    public KieRepository getKieRepository() {
        return this.kieRepository;
    }

    public void setPlatformTransactionManager(AbstractPlatformTransactionManager platformTransactionManager) {
        this.platformTransactionManager = platformTransactionManager;
    }

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public void setSharedEntityManager(EntityManager em) {
        this.sharedEm = em;
    }

    public void setJbpmServicesPersistenceManager(JbpmServicesPersistenceManagerImpl jbpmServicesPersistenceManager) {
        this.jbpmServicesPersistenceManager = jbpmServicesPersistenceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerWorkItemHandler(String name, WorkItemHandler workItemHandler) {
        WorkflowService workflowService = this.workflowService;
        synchronized (workflowService) {
            this.workItemHandlers.put(name, workItemHandler);
            if (this.runtimeEngine != null) {
                this.runtimeEngine.getKieSession().getWorkItemManager().registerWorkItemHandler(name, workItemHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkItemHandler unregisterWorkItemHandler(String name) {
        WorkflowService workflowService = this.workflowService;
        synchronized (workflowService) {
            if (this.runtimeEngine != null) {
                this.runtimeEngine.getKieSession().getWorkItemManager().registerWorkItemHandler(name, null);
            }
            return this.workItemHandlers.remove(name);
        }
    }

    public void registerTaskLifeCycleEventListener(String name, AbstractTaskLifeCycleEventListener taskAssignmentListener) {
        this.taskLifeCycleEventListeners.put(name, taskAssignmentListener);
    }

    public AbstractTaskLifeCycleEventListener unregisterTaskLifeCycleEventListener(String name) {
        return this.taskLifeCycleEventListeners.remove(name);
    }

    public void start() {
        this.kieServices = KieServices.Factory.get();
        this.kieRepository = this.kieServices.getRepository();
        this.kieFileSystem = this.kieServices.newKieFileSystem();
        this.workflowService.addProvider(this);
    }

    public void stop() {
        this.workflowService.removeProvider(this);
        this.runtimeManager.close();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public List<WorkflowDefinition> getAvailableWorkflows(Locale uiLocale) {
        return this.executeCommand(new GetAvailableWorkflowsCommand(uiLocale));
    }

    @Override
    public WorkflowDefinition getWorkflowDefinitionByKey(String key, Locale uiLocale) {
        WorkflowDefinition definition;
        Map<Locale, WorkflowDefinition> defsByKey = this.definitionMap.get(key);
        if (defsByKey == null) {
            defsByKey = new HashMap<Locale, WorkflowDefinition>();
            this.definitionMap.put(key, defsByKey);
        }
        if ((definition = defsByKey.get(uiLocale)) == null) {
            definition = this.executeCommand(new GetWorkflowDefinitionCommand(key, uiLocale));
            defsByKey.put(uiLocale, definition);
        }
        return definition;
    }

    @Override
    public List<Workflow> getActiveWorkflowsInformations(List<String> processIds, Locale uiLocale) {
        return this.executeCommand(new GetActiveWorkflowsInformationsCommand(processIds, uiLocale));
    }

    @Override
    public String startProcess(String processKey, Map<String, Object> args) {
        return this.executeCommand(new StartProcessCommand(processKey, args));
    }

    @Override
    public void abortProcess(String processId) {
        List taskIds = this.runtimeEngine.getTaskService().getTasksByProcessInstanceId(Long.parseLong(processId));
        for (Long taskId : taskIds) {
            Status status = this.runtimeEngine.getTaskService().getTaskById(taskId.longValue()).getTaskData().getStatus();
            if (status != Status.Ready && status != Status.InProgress && status != Status.Reserved) continue;
            this.observationManager.notifyTaskEnded(this.key, Long.toString(taskId));
        }
        this.executeCommand(new AbortProcessCommand(processId));
    }

    @Override
    public Workflow getWorkflow(String processId, Locale uiLocale) {
        return this.executeCommand(new GetWorkflowCommand(processId, uiLocale));
    }

    @Override
    public Set<WorkflowAction> getAvailableActions(String processId, Locale uiLocale) {
        return this.executeCommand(new GetAvailableActionsCommand(processId, uiLocale));
    }

    @Override
    public List<WorkflowTask> getTasksForUser(JahiaUser user, Locale uiLocale) {
        return this.executeCommand(new GetTasksForUserCommand(user, uiLocale));
    }

    @Override
    public List<Workflow> getWorkflowsForDefinition(String definition, Locale uiLocale) {
        return this.executeCommand(new GetWorkflowsForDefinitionCommand(definition, uiLocale));
    }

    @Override
    public List<Workflow> getWorkflowsForUser(JahiaUser user, Locale uiLocale) {
        return this.executeCommand(new GetWorkflowsForUserCommand(user, uiLocale));
    }

    @Override
    public void assignTask(String taskId, JahiaUser user) {
        if (this.loop.get() != null) {
            return;
        }
        try {
            this.loop.set(Boolean.TRUE);
            this.executeCommand(new AssignTaskCommand(taskId, user));
        }
        finally {
            this.loop.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completeTask(String taskId, JahiaUser jahiaUser, String outcome, Map<String, Object> args) {
        if (this.loop.get() != null) {
            return;
        }
        try {
            this.loop.set(Boolean.TRUE);
            this.executeCommand(new CompleteTaskCommand(taskId, outcome, args, jahiaUser, this.observationManager));
        }
        finally {
            this.loop.set(null);
        }
    }

    @Override
    public void addComment(String processId, String comment, String user) {
        this.executeCommand(new AddCommentCommand(processId, comment, user));
    }

    @Override
    public WorkflowTask getWorkflowTask(String taskId, Locale uiLocale) {
        return this.executeCommand(new GetWorkflowTaskCommand(taskId, uiLocale));
    }

    @Override
    public List<HistoryWorkflow> getHistoryWorkflowsForNode(String nodeId, Locale uiLocale) {
        return this.executeCommand(new GetHistoryWorkflowsForNodeCommand(nodeId, uiLocale));
    }

    @Override
    public List<HistoryWorkflow> getHistoryWorkflowsForPath(String path, Locale uiLocale) {
        return this.executeCommand(new GetHistoryWorkflowsForPathCommand(path, uiLocale));
    }

    @Override
    public List<HistoryWorkflow> getHistoryWorkflows(List<String> processIds, Locale uiLocale) {
        return this.executeCommand(new GetHistoryWorkflowCommand(processIds, uiLocale));
    }

    @Override
    public List<HistoryWorkflowTask> getHistoryWorkflowTasks(String processId, Locale uiLocale) {
        return this.executeCommand(new GetHistoryWorkflowTasksCommand(processId, uiLocale));
    }

    @Override
    public void deleteProcess(String processId) {
    }

    public static String getEncodedProcessKey(String processKey) {
        if (Character.isDigit(processKey.charAt(0))) {
            processKey = ISO9075.encode((String)processKey);
        }
        return processKey;
    }

    public static String getDecodedProcessKey(String processKey) {
        return ISO9075.decode((String)processKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(Resource kieResource) throws IOException {
        WorkflowService workflowService = this.workflowService;
        synchronized (workflowService) {
            this.kieFileSystem.write(this.kieServices.getResources().newUrlResource(kieResource.getURL()));
            this.definitionMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(Resource kieResource) throws IOException {
        WorkflowService workflowService = this.workflowService;
        synchronized (workflowService) {
            this.kieFileSystem.delete(new String[]{kieResource.getURL().getPath()});
            this.definitionMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recompilePackages() {
        WorkflowService workflowService = this.workflowService;
        synchronized (workflowService) {
            long timer = System.currentTimeMillis();
            KieBuilder kieBuilder = this.kieServices.newKieBuilder(this.kieFileSystem);
            kieBuilder.buildAll();
            this.kieContainer = this.kieServices.newKieContainer(this.kieRepository.getDefaultReleaseId());
            this.transactionManager = new KieSpringTransactionManager(this.platformTransactionManager);
            PersistenceContextManager persistenceContextManager = this.createKieSpringContextManager(this.transactionManager);
            RuntimeEnvironment runtimeEnvironment = RuntimeEnvironmentBuilder.getDefault().entityManagerFactory((Object)this.emf).addEnvironmentEntry("org.kie.transaction.TransactionManager", (Object)this.transactionManager).addEnvironmentEntry("org.kie.api.persistence.PersistenceContextManager", (Object)persistenceContextManager).knowledgeBase(this.kieContainer.getKieBase()).classLoader(this.kieContainer.getClassLoader()).registerableItemsFactory((RegisterableItemsFactory)new JahiaKModuleRegisterableItemsFactory(this.kieContainer, null, this.peopleAssignmentPipeline)).userGroupCallback((UserGroupCallback)this.jahiaUserGroupCallback).get();
            if (this.runtimeManager != null) {
                this.runtimeManager.close();
            }
            JahiaRuntimeManagerFactoryImpl runtimeFactory = JahiaRuntimeManagerFactoryImpl.getInstance();
            runtimeFactory.setJbpmServicesPersistenceManager(this.jbpmServicesPersistenceManager);
            this.runtimeManager = runtimeFactory.newSingletonRuntimeManager((org.kie.api.runtime.manager.RuntimeEnvironment)runtimeEnvironment);
            this.runtimeEngine = this.runtimeManager.getRuntimeEngine(EmptyContext.get());
            KieSession kieSession = this.runtimeEngine.getKieSession();
            for (Map.Entry<String, WorkItemHandler> entry : this.workItemHandlers.entrySet()) {
                kieSession.getWorkItemManager().registerWorkItemHandler(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.taskLifeCycleEventListeners.entrySet()) {
                AbstractTaskLifeCycleEventListener taskLifeCycleEventListener = (AbstractTaskLifeCycleEventListener)((Object)entry.getValue());
                taskLifeCycleEventListener.setEnvironment(kieSession.getEnvironment());
                taskLifeCycleEventListener.setObservationManager(this.observationManager);
                taskLifeCycleEventListener.setTaskService(this.runtimeEngine.getTaskService());
                if (!(this.runtimeEngine.getTaskService() instanceof EventService)) continue;
                ((EventService)this.runtimeEngine.getTaskService()).registerTaskLifecycleEventListener((Object)taskLifeCycleEventListener);
            }
            HashMap<String, Object> pipelineEnvironment = new HashMap<String, Object>();
            pipelineEnvironment.put("jBPMWorkflowProvider", this);
            this.peopleAssignmentPipeline.setEnvironment(pipelineEnvironment);
            kieSession.addEventListener((ProcessEventListener)this.listener);
            this.isInitialized = true;
            logger.info("Rebuilding KIE base took {} ms", (Object)(System.currentTimeMillis() - timer));
        }
    }

    private PersistenceContextManager createKieSpringContextManager(TransactionManager transactionManager) {
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", (Object)this.emf);
        env.set("org.kie.api.persistence.jpa.AppScopedEntityManager", (Object)this.sharedEm);
        env.set("org.kie.api.persistence.jpa.CmdScopedEntityManager", (Object)this.sharedEm);
        env.set("IS_SHARED_ENTITY_MANAGER", (Object)true);
        env.set("IS_JTA_TRANSACTION", (Object)false);
        env.set("org.kie.transaction.TransactionManager", (Object)transactionManager);
        KieSpringJpaManager persistenceContextManager = new KieSpringJpaManager(env);
        env.set("org.kie.api.persistence.PersistenceContextManager", (Object)persistenceContextManager);
        return persistenceContextManager;
    }

    private <T> T executeCommand(BaseCommand<T> t) {
        t.setRuntimeEngine(this.runtimeEngine);
        t.setEm(this.sharedEm);
        t.setPersistenceManager((JbpmServicesPersistenceManager)this.jbpmServicesPersistenceManager);
        t.setGroupManager(this.groupManager);
        t.setUserManager(this.userManager);
        t.setWorkflowService(this.workflowService);
        t.setKey(this.key);
        CommandBasedStatefulKnowledgeSession s = (CommandBasedStatefulKnowledgeSession)this.runtimeEngine.getKieSession();
        return (T)s.execute(t);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void initAfterAllServicesAreStarted() throws JahiaInitializationException {
        this.recompilePackages();
        this.workflowService.initAfterAllServicesAreStarted();
    }
}

