/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.settings.readonlymode;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.jahia.services.SpringContextSingleton;
import org.jahia.settings.readonlymode.ReadOnlyModeCapable;
import org.jahia.settings.readonlymode.ReadOnlyModeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyModeController {
    private static final Logger logger = LoggerFactory.getLogger(ReadOnlyModeController.class);
    private static final Comparator<ReadOnlyModeCapable> SERVICES_COMPARATOR_BY_PRIORITY = new Comparator<ReadOnlyModeCapable>(){

        @Override
        public int compare(ReadOnlyModeCapable readonlyModeCapable1, ReadOnlyModeCapable readonlyModeCapable2) {
            return Integer.compare(readonlyModeCapable1.getReadOnlyModePriority(), readonlyModeCapable2.getReadOnlyModePriority());
        }
    };
    private volatile ReadOnlyModeStatus readOnlyStatus = ReadOnlyModeStatus.OFF;

    public static void readOnlyModeViolated(String message) throws ReadOnlyModeException {
        throw new ReadOnlyModeException(message);
    }

    public synchronized void switchReadOnlyMode(boolean enable) {
        ReadOnlyModeStatus targetStatus = enable ? ReadOnlyModeStatus.ON : ReadOnlyModeStatus.OFF;
        logger.info("Received request to switch read only mode to {}", (Object)targetStatus);
        if (!this.isStatusUpdateAllowed(enable)) {
            throw new IllegalStateException("The read-only mode state is " + (Object)((Object)this.readOnlyStatus) + ", unable to switch to " + (Object)((Object)targetStatus));
        }
        this.readOnlyStatus = enable ? ReadOnlyModeStatus.PENDING_ON : ReadOnlyModeStatus.PENDING_OFF;
        LinkedList<ReadOnlyModeCapable> services = new LinkedList<ReadOnlyModeCapable>(SpringContextSingleton.getBeansOfType(ReadOnlyModeCapable.class).values());
        Collections.sort(services, SERVICES_COMPARATOR_BY_PRIORITY);
        if (enable) {
            Collections.reverse(services);
        }
        logger.info("Switching read only status of {} services", (Object)services.size());
        for (ReadOnlyModeCapable service : services) {
            try {
                service.switchReadOnlyMode(enable);
            }
            catch (Exception e) {
                this.readOnlyStatus = enable ? ReadOnlyModeStatus.PARTIAL_ON : ReadOnlyModeStatus.PARTIAL_OFF;
                logger.error("Error switching read only status of the service " + service, (Throwable)e);
                throw e;
            }
        }
        this.readOnlyStatus = targetStatus;
        logger.info("Finished read-only mode switch. Now the read-only mode is {}", (Object)this.readOnlyStatus);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStatusUpdateAllowed(boolean switchModeTo) {
        if (switchModeTo) {
            if (this.readOnlyStatus == ReadOnlyModeStatus.OFF) {
                return true;
            }
        } else if (this.readOnlyStatus == ReadOnlyModeStatus.ON) return true;
        if (this.readOnlyStatus == ReadOnlyModeStatus.PARTIAL_ON) return true;
        if (this.readOnlyStatus != ReadOnlyModeStatus.PARTIAL_OFF) return false;
        return true;
    }

    public static ReadOnlyModeController getInstance() {
        return Holder.INSTANCE;
    }

    public ReadOnlyModeStatus getReadOnlyStatus() {
        return this.readOnlyStatus;
    }

    private static class Holder {
        static final ReadOnlyModeController INSTANCE = new ReadOnlyModeController();

        private Holder() {
        }
    }

    public static enum ReadOnlyModeStatus {
        OFF,
        ON,
        PENDING_ON,
        PENDING_OFF,
        PARTIAL_ON,
        PARTIAL_OFF;

    }
}

