/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

public abstract class LoadAverage
implements Runnable {
    protected double oneMinuteLoad = 0.0;
    protected double fiveMinuteLoad = 0.0;
    protected double fifteenMinuteLoad = 0.0;
    private long calcFreqMillis = 5000L;
    private double loggingTriggerValue;
    private Thread loadCalcThread;
    private final String threadName;
    private boolean running = false;

    public void setLoggingTriggerValue(double loggingTriggerValue) {
        this.loggingTriggerValue = loggingTriggerValue;
    }

    public double getLoggingTriggerValue() {
        return this.loggingTriggerValue;
    }

    public void setCalcFrequencyInMillisec(long millisec) {
        this.calcFreqMillis = millisec;
    }

    public abstract double getCount();

    public abstract void tickCallback();

    public LoadAverage(String threadName) {
        this.threadName = threadName;
    }

    public void start() {
        if (this.calcFreqMillis > 0L) {
            this.loadCalcThread = new Thread((Runnable)this, this.threadName);
            this.loadCalcThread.setDaemon(true);
            this.running = true;
            this.loadCalcThread.start();
        }
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            this.loadCalcThread.interrupt();
            try {
                this.loadCalcThread.join(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        double calcFreqDouble = (double)this.calcFreqMillis / 1000.0;
        while (this.running) {
            double timeInMinutes = 1.0;
            this.oneMinuteLoad = this.oneMinuteLoad * Math.exp(-calcFreqDouble / (60.0 * timeInMinutes)) + this.getCount() * (1.0 - Math.exp(-calcFreqDouble / (60.0 * timeInMinutes)));
            timeInMinutes = 5.0;
            this.fiveMinuteLoad = this.fiveMinuteLoad * Math.exp(-calcFreqDouble / (60.0 * timeInMinutes)) + this.getCount() * (1.0 - Math.exp(-calcFreqDouble / (60.0 * timeInMinutes)));
            timeInMinutes = 15.0;
            this.fifteenMinuteLoad = this.fifteenMinuteLoad * Math.exp(-calcFreqDouble / (60.0 * timeInMinutes)) + this.getCount() * (1.0 - Math.exp(-calcFreqDouble / (60.0 * timeInMinutes)));
            this.tickCallback();
            try {
                Thread.sleep(this.calcFreqMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public double getOneMinuteLoad() {
        return this.oneMinuteLoad;
    }

    public double getFiveMinuteLoad() {
        return this.fiveMinuteLoad;
    }

    public double getFifteenMinuteLoad() {
        return this.fifteenMinuteLoad;
    }
}

