/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class Log4jEventCollector
extends AppenderSkeleton {
    private int minLevel;
    private int maxLevel;
    private boolean closed;
    private List<LoggingEvent> events = new LinkedList<LoggingEvent>();

    public Log4jEventCollector(int minLevel, int maxLevel) {
        if (minLevel > maxLevel) {
            throw new IllegalArgumentException("Min level must be lower than or equal to max level");
        }
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    protected synchronized void append(LoggingEvent event) {
        if (this.closed) {
            throw new IllegalStateException("Event collector is closed");
        }
        int level = event.getLevel().toInt();
        if (level < this.minLevel || level > this.maxLevel) {
            return;
        }
        this.events.add(event);
    }

    public synchronized void close() {
        this.closed = true;
    }

    public boolean requiresLayout() {
        return false;
    }

    public synchronized List<LoggingEvent> getCollectedEvents() {
        return Collections.unmodifiableList(this.events);
    }
}

