/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class DirectoryZipOutputStream
extends ZipOutputStream {
    File destination;
    File currentEntry;
    FileOutputStream currentEntryOutputStream;
    ZipEntry currentZipEntry;

    public DirectoryZipOutputStream(File destination, OutputStream out) {
        super(out);
        this.destination = destination;
    }

    @Override
    public void putNextEntry(ZipEntry e) throws IOException {
        if (this.currentEntryOutputStream != null) {
            this.closeEntry();
        }
        this.currentEntry = new File(this.destination, e.getName());
        if (!this.currentEntry.getParentFile().exists()) {
            this.currentEntry.getParentFile().mkdirs();
        }
        this.currentZipEntry = e;
        if (e.getName().endsWith("/")) {
            this.currentEntry.mkdir();
        } else {
            this.currentEntryOutputStream = new FileOutputStream(this.currentEntry);
        }
    }

    @Override
    public void closeEntry() throws IOException {
        if (this.currentZipEntry.getTime() > 0L) {
            this.currentEntry.setLastModified(this.currentZipEntry.getTime());
        }
        this.currentEntryOutputStream.close();
        this.currentEntryOutputStream = null;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.currentEntryOutputStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.currentEntryOutputStream.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.currentEntryOutputStream.write(b);
    }

    @Override
    public void finish() throws IOException {
        if (this.currentEntryOutputStream != null) {
            this.currentEntryOutputStream.close();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.currentEntryOutputStream != null) {
            this.currentEntryOutputStream.close();
        }
    }

    @Override
    public void setComment(String comment) {
    }

    @Override
    protected void deflate() throws IOException {
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.currentEntryOutputStream.write(b);
    }

    @Override
    public void setMethod(int method) {
    }

    @Override
    public void setLevel(int level) {
    }
}

