/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.serializer;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.ConfigurableObjectInputStream;
import org.springframework.core.NestedIOException;
import org.springframework.core.serializer.Deserializer;

public class Spring4DefaultDeserializer
implements Deserializer<Object> {
    private final ClassLoader classLoader;

    public Spring4DefaultDeserializer() {
        this.classLoader = null;
    }

    public Spring4DefaultDeserializer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object deserialize(InputStream inputStream) throws IOException {
        ConfigurableObjectInputStream objectInputStream = new ConfigurableObjectInputStream(inputStream, this.classLoader);
        try {
            return objectInputStream.readObject();
        }
        catch (ClassNotFoundException ex) {
            throw new NestedIOException("Failed to deserialize object type", (Throwable)ex);
        }
    }
}

