/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.jahia.utils.maven.plugin.contentgenerator.CategoryService;
import org.jahia.utils.maven.plugin.contentgenerator.DatabaseService;
import org.jahia.utils.maven.plugin.contentgenerator.FileService;
import org.jahia.utils.maven.plugin.contentgenerator.MountPointService;
import org.jahia.utils.maven.plugin.contentgenerator.OutputService;
import org.jahia.utils.maven.plugin.contentgenerator.PageService;
import org.jahia.utils.maven.plugin.contentgenerator.SiteService;
import org.jahia.utils.maven.plugin.contentgenerator.TagService;
import org.jahia.utils.maven.plugin.contentgenerator.UserGroupService;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ArticleBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ExportBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.GroupBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.MountPointBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.SiteBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.UserBO;
import org.jdom.Document;
import org.jdom.Element;
import org.w3c.dom.DOMException;

public class ContentGeneratorService {
    public static int currentPageIndex = 0;
    public static int currentFileIndex = 0;
    private static ContentGeneratorService instance;
    private static final Log LOGGER;

    private ContentGeneratorService() {
    }

    public static ContentGeneratorService getInstance() {
        if (instance == null) {
            instance = new ContentGeneratorService();
        }
        return instance;
    }

    public void generatePages(ExportBO export, List<ArticleBO> articles) throws MojoExecutionException, IOException {
        if (!export.isDisableInternalFileReference() && export.getFileNames().isEmpty()) {
            throw new MojoExecutionException("Directory containing files to include is empty, use jahia:generate-files first");
        }
        currentPageIndex = 0;
        PageService pageService = new PageService();
        pageService.createTopPages(export, articles);
    }

    public void generateFiles(ExportBO export) throws MojoExecutionException {
        LOGGER.info((CharSequence)"Jahia files generator starts");
        Integer numberOfFilesToGenerate = export.getNumberOfFilesToGenerate();
        if (numberOfFilesToGenerate == null) {
            throw new MojoExecutionException("numberOfFilesToGenerate parameter is required");
        }
        List<ArticleBO> articles = DatabaseService.getInstance().selectArticles(export, export.getNumberOfFilesToGenerate());
        int indexArticle = 0;
        for (int i = 0; i < numberOfFilesToGenerate; ++i) {
            if (indexArticle == articles.size()) {
                indexArticle = 0;
            }
            File outputFile = new File(export.getFilesDirectory(), "file." + i + ".txt");
            try {
                FileUtils.writeStringToFile((File)outputFile, (String)articles.get(indexArticle).getContent());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error generating article file", (Exception)e);
            }
            ++indexArticle;
        }
        FileService fileService = new FileService();
        LOGGER.debug((CharSequence)export.getFilesDirectory().getAbsolutePath());
        List<String> filesNamesAvailable = fileService.getFileNamesAvailable(export.getFilesDirectory());
        export.setFileNames(filesNamesAvailable);
    }

    public String generateSites(ExportBO export) throws MojoExecutionException, DOMException, ParserConfigurationException {
        OutputService os = new OutputService();
        UserGroupService userGroupService = new UserGroupService();
        ArrayList<File> globalFilesToZip = new ArrayList<File>();
        try {
            List<UserBO> users = userGroupService.generateUsers(export.getNumberOfUsers(), 0, 0, null);
            File tmpUsers = new File(export.getOutputDir(), "users");
            tmpUsers.mkdir();
            File repositoryUsers = new File(tmpUsers, "repository.xml");
            Document usersRepositoryDocument = userGroupService.createUsersRepository(users);
            os.writeJdomDocumentToFile(usersRepositoryDocument, repositoryUsers);
            ArrayList<File> filesToZip = new ArrayList<File>();
            File contentUsers = userGroupService.createFileTreeForUsers(users, tmpUsers);
            filesToZip.add(repositoryUsers);
            filesToZip.add(contentUsers);
            File usersArchive = os.createSiteArchive("users.zip", export.getOutputDir(), filesToZip);
            globalFilesToZip.add(usersArchive);
            ArrayList<String> userNames = new ArrayList<String>();
            for (UserBO user : users) {
                userNames.add(user.getName());
            }
            File usersFile = new File(export.getOutputDir(), "users.txt");
            usersFile.delete();
            os.appendPathToFile(usersFile, userNames);
            String baseSiteKey = export.getSiteKey();
            export.getMapFile().delete();
            SiteService siteService = new SiteService();
            TagService tagService = new TagService();
            CategoryService categoryService = new CategoryService();
            List<ArticleBO> articles = DatabaseService.getInstance().selectArticles(export, export.getTotalPages());
            for (int i = 0; i < export.getNumberOfSites(); ++i) {
                LOGGER.debug((CharSequence)("Generating site #" + (i + 1)));
                export.setRootPageName("home");
                SiteBO site = new SiteBO();
                String siteKey = baseSiteKey + (i > 0 ? Integer.valueOf(i + 1) : "");
                export.setSiteKey(siteKey);
                site.setSiteKey(siteKey);
                this.generatePages(export, articles);
                LOGGER.debug((CharSequence)"Pages generated, now site");
                filesToZip = new ArrayList();
                File tempOutputDir = siteService.createSiteDirectory(siteKey, new File(export.getOutputDir()));
                File propertiesFile = siteService.createPropertiesFile(siteKey, export.getSiteLanguages(), "templates-web-blue-qa", tempOutputDir);
                filesToZip.add(propertiesFile);
                File filesFile = null;
                if (!export.isDisableInternalFileReference()) {
                    FileService fileService = new FileService();
                    File filesDirectory = siteService.createFilesDirectoryTree(siteKey, tempOutputDir);
                    filesToZip.add(new File(tempOutputDir + "/content"));
                    List<File> filesToCopy = fileService.getFilesAvailable(export.getFilesDirectory());
                    fileService.copyFilesForAttachment(filesToCopy, filesDirectory);
                    filesFile = new File(export.getOutputDir(), "jcrFiles.xml");
                    fileService.createAndPopulateFilesXmlFile(filesFile, filesToCopy);
                }
                File groupsFile = null;
                if (export.getNumberOfUsers() > 0) {
                    List<GroupBO> groups = userGroupService.generateGroups(export.getNumberOfGroups(), export.getNumberOfUsersPerGroup(), users);
                    Element groupsNode = userGroupService.generateJcrGroups(siteKey, groups);
                    Document groupsDoc = new Document(groupsNode);
                    groupsFile = new File(export.getOutputDir(), "groups.xml");
                    os.writeJdomDocumentToFile(groupsDoc, groupsFile);
                }
                Element tagList = tagService.createTagListElement();
                List<Element> tags = tagService.createTags(export.getNumberOfTags());
                tagList.addContent(tags);
                Document tagsDoc = new Document(tagList);
                File tagsFile = new File(export.getOutputDir(), "tags.xml");
                os.writeJdomDocumentToFile(tagsDoc, tagsFile);
                File repositoryFile = siteService.createAndPopulateRepositoryFile(tempOutputDir, site, export.getOutputFile(), filesFile, groupsFile, tagsFile);
                filesToZip.add(repositoryFile);
                String zipFileName = siteKey + ".zip";
                File siteArchive = os.createSiteArchive(zipFileName, export.getOutputDir(), filesToZip);
                filesToZip.clear();
                globalFilesToZip.add(siteArchive);
            }
            Document systemSiteRepository = siteService.createSystemSiteRepository();
            Element categories = categoryService.createCategories(export.getNumberOfCategories(), export.getNumberOfCategoryLevels(), export);
            categoryService.insertCategoriesIntoSiteRepository(systemSiteRepository, categories);
            String systemSiteRepositoryFileName = "repository.xml";
            File systemSiteRepositoryFile = new File(export.getOutputDir(), systemSiteRepositoryFileName);
            os.writeJdomDocumentToFile(systemSiteRepository, systemSiteRepositoryFile);
            filesToZip.add(systemSiteRepositoryFile);
            File systemSiteArchive = os.createSiteArchive("systemsite.zip", export.getOutputDir(), filesToZip);
            globalFilesToZip.add(systemSiteArchive);
            LOGGER.info((CharSequence)"System site archive created");
            if (!export.isDisableExternalFileReference()) {
                LOGGER.info((CharSequence)"Generating mount points");
                filesToZip.clear();
                MountPointBO mountPointCmis = new MountPointBO("cmisMountPoint", "cmis", export.getCmisRepositoryId(), export.getCmisUrl(), export.getCmisUser(), export.getCmisPassword(), export.getCmisServerType());
                Document cmisMountDoc = new Document(mountPointCmis.getElement());
                File mountsFile = new File(export.getOutputDir(), "mounts.xml");
                os.writeJdomDocumentToFile(cmisMountDoc, mountsFile);
                File tempOutputDir = new File(export.getOutputDir(), "mounts");
                tempOutputDir.mkdir();
                MountPointService mountPointService = new MountPointService();
                File mountPointsRepository = mountPointService.createAndPopulateRepositoryFile(tempOutputDir, mountsFile);
                filesToZip.add(mountPointsRepository);
                File mountPointsArchive = os.createSiteArchive("mounts.zip", export.getOutputDir(), filesToZip);
                globalFilesToZip.add(mountPointsArchive);
                LOGGER.info((CharSequence)"Mount point archive created");
            }
            Properties exportProperties = new Properties();
            exportProperties.put("JahiaRelease", export.getJahiaRelease());
            exportProperties.put("BuildNumber", export.getBuildNumber());
            File exportPropertiesFile = new File(export.getOutputDir(), "export.properties");
            os.writePropertiesToFile(exportProperties, exportPropertiesFile);
            globalFilesToZip.add(exportPropertiesFile);
            File globalArchive = os.createSiteArchive("import.zip", export.getOutputDir(), globalFilesToZip);
            return globalArchive.getAbsolutePath();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error generating website", (Exception)e);
        }
    }

    public Integer getTotalNumberOfPagesNeeded(Integer nbPagesTopLevel, Integer nbLevels, Integer nbPagesPerLevel) {
        Double nbPages = new Double(0.0);
        for (double d = (double)nbLevels.intValue(); d > 0.0; d -= 1.0) {
            nbPages = nbPages + Math.pow(nbPagesPerLevel.doubleValue(), d);
        }
        nbPages = nbPages * (double)nbPagesTopLevel.intValue() + (double)nbPagesTopLevel.intValue();
        return new Integer(nbPages.intValue());
    }

    public String getDateForJcrImport(Date date) {
        GregorianCalendar gc = (GregorianCalendar)GregorianCalendar.getInstance();
        if (date != null) {
            gc.setTime(date);
        }
        StringBuffer sbNewDate = new StringBuffer();
        sbNewDate.append(gc.get(1));
        sbNewDate.append("-");
        sbNewDate.append(gc.get(2));
        sbNewDate.append("-");
        sbNewDate.append(gc.get(5));
        sbNewDate.append("T");
        sbNewDate.append(gc.get(11));
        sbNewDate.append(":");
        sbNewDate.append(gc.get(12));
        sbNewDate.append(":");
        sbNewDate.append(gc.get(13));
        sbNewDate.append(".");
        sbNewDate.append(gc.get(14));
        sbNewDate.append(gc.get(15));
        return sbNewDate.toString();
    }

    static {
        LOGGER = new SystemStreamLog();
    }
}

