/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.bo;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ArticleBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.NewsBO;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class PageBO {
    private Element pageElement;
    private String namePrefix;
    private Map<String, ArticleBO> articles;
    private List<PageBO> subPages;
    private Boolean hasVanity;
    private String siteKey;
    private String fileName;
    private Integer numberBigText;
    private Map<String, List<String>> acls;
    private Integer idCategory;
    private Integer idTag;
    private Boolean visibilityEnabled;
    private String visibilityStartDate;
    private String visibilityEndDate;
    private String description;
    private String pageTemplate;
    private String cmisSite;
    private List<String> externalFilePaths;
    private boolean personalized;
    private int minPersonalizationVariants;
    private int maxPersonalizationVariants;

    public PageBO(String namePrefix, Map<String, ArticleBO> articles, List<PageBO> subPages, Boolean hasVanity, String siteKey, String fileName, Integer numberBigText, Map<String, List<String>> acls, Integer idCategory, Integer idTag, Boolean visibilityEnabled, String visibilityStartDate, String visibilityEndDate, String description, String pageTemplate, String cmisSite, List<String> externalFilePaths, boolean personalized, int minPersonalizationVariants, int maxPersonalizationVariants) {
        this.articles = articles;
        this.subPages = subPages;
        this.namePrefix = namePrefix;
        this.hasVanity = hasVanity;
        this.siteKey = siteKey;
        this.fileName = fileName;
        this.numberBigText = numberBigText;
        this.acls = acls;
        this.idCategory = idCategory;
        this.idTag = idTag;
        this.visibilityEnabled = visibilityEnabled;
        this.visibilityStartDate = visibilityStartDate;
        this.visibilityEndDate = visibilityEndDate;
        this.description = description;
        this.pageTemplate = pageTemplate;
        this.cmisSite = cmisSite;
        this.externalFilePaths = externalFilePaths;
        this.personalized = personalized;
        this.minPersonalizationVariants = minPersonalizationVariants;
        this.maxPersonalizationVariants = maxPersonalizationVariants;
        this.buildPageElement();
    }

    public String getName() {
        if (this.personalized) {
            return this.namePrefix + "-personalized";
        }
        return this.namePrefix;
    }

    public List<PageBO> getSubPages() {
        return this.subPages;
    }

    public Element getElement() {
        return this.pageElement;
    }

    /*
     * WARNING - void declaration
     */
    private void buildPageElement() {
        this.pageElement = new Element(this.getName());
        this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_JCR);
        this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_NT);
        this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_JNT);
        this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_TEST);
        this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_SV);
        this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_JMIX);
        this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_J);
        this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_SV);
        this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_REP);
        this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_WEM);
        this.pageElement.setAttribute("changefreq", "monthly");
        this.pageElement.setAttribute("templateName", this.pageTemplate, ContentGeneratorCst.NS_J);
        this.pageElement.setAttribute("primaryType", "jnt:page", ContentGeneratorCst.NS_JCR);
        this.pageElement.setAttribute("priority", "0.5");
        String mixinTypes = "jmix:sitemap";
        if (this.hasVanity.booleanValue()) {
            mixinTypes = mixinTypes + " jmix:vanityUrlMapped";
        }
        this.pageElement.setAttribute("mixinTypes", mixinTypes, ContentGeneratorCst.NS_JCR);
        if (this.idCategory != null) {
            this.pageElement.setAttribute("jcategorized", "", ContentGeneratorCst.NS_JMIX);
            this.pageElement.setAttribute("defaultCategory", "/sites/systemsite/categories/category" + this.idCategory, ContentGeneratorCst.NS_J);
        }
        if (this.idTag != null) {
            this.pageElement.setAttribute("tags", "/sites/" + this.siteKey + "/tags/tag" + this.idTag, ContentGeneratorCst.NS_J);
        }
        for (Map.Entry<String, ArticleBO> entry : this.articles.entrySet()) {
            Element element = new Element("translation_" + entry.getKey(), ContentGeneratorCst.NS_J);
            element.setAttribute("language", entry.getKey(), ContentGeneratorCst.NS_JCR);
            element.setAttribute("mixinTypes", "mix:title", ContentGeneratorCst.NS_JCR);
            element.setAttribute("primaryType", "jnt:translation", ContentGeneratorCst.NS_JCR);
            element.setAttribute("title", entry.getValue().getTitle(), ContentGeneratorCst.NS_JCR);
            if (StringUtils.isNotEmpty((String)this.description)) {
                element.setAttribute("description", this.description, ContentGeneratorCst.NS_JCR);
            }
            this.pageElement.addContent((Content)element);
        }
        if (!this.acls.isEmpty()) {
            Element aclNode = new Element("acl", ContentGeneratorCst.NS_J);
            aclNode.setAttribute("inherit", "true", ContentGeneratorCst.NS_J);
            aclNode.setAttribute("primaryType", "jnt:acl", ContentGeneratorCst.NS_JCR);
            for (Map.Entry<String, List<String>> entry : this.acls.entrySet()) {
                Object roles = "";
                for (String string : entry.getValue()) {
                    roles = (String)roles + string + " ";
                }
                Element element = new Element("GRANT_" + entry.getKey().replace(":", "_"));
                element.setAttribute("aceType", "GRANT", ContentGeneratorCst.NS_J);
                element.setAttribute("principal", entry.getKey(), ContentGeneratorCst.NS_J);
                element.setAttribute("protected", "false", ContentGeneratorCst.NS_J);
                element.setAttribute("roles", ((String)roles).trim(), ContentGeneratorCst.NS_J);
                element.setAttribute("primaryType", "jnt:ace", ContentGeneratorCst.NS_JCR);
                aclNode.addContent((Content)element);
            }
            this.pageElement.addContent((Content)aclNode);
        }
        Element listNode = new Element("listA");
        listNode.setAttribute("primaryType", "jnt:contentList", ContentGeneratorCst.NS_JCR);
        LinkedList<Element> linkedList = new LinkedList<Element>();
        if (this.pageTemplate.equals("qa-list")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry entry : this.articles.entrySet()) {
                arrayList.add((String)entry.getKey());
            }
            for (int i = 1; i <= ContentGeneratorCst.NB_NEWS_IN_QALIST; ++i) {
                Element element = new NewsBO(this.namePrefix + "-news" + i, arrayList).getElement();
                listNode.addContent((Content)element);
                if (i > ContentGeneratorCst.NB_NEWS_PER_PAGE_IN_QALIST) continue;
                linkedList.add(element);
            }
        } else if (this.pageTemplate.equals("events")) {
            void var4_12;
            boolean bl = true;
            while (var4_12 <= this.numberBigText) {
                Element bigTextNode = new Element("bigText_" + (int)var4_12);
                bigTextNode.setAttribute("primaryType", "jnt:bigText", ContentGeneratorCst.NS_JCR);
                bigTextNode.setAttribute("mixinTypes", "jmix:renderable", ContentGeneratorCst.NS_JCR);
                for (Map.Entry<String, ArticleBO> entry : this.articles.entrySet()) {
                    Element translationNode = new Element("translation_" + entry.getKey(), ContentGeneratorCst.NS_J);
                    translationNode.setAttribute("language", entry.getKey(), ContentGeneratorCst.NS_JCR);
                    translationNode.setAttribute("primaryType", "jnt:translation", ContentGeneratorCst.NS_JCR);
                    translationNode.setAttribute("text", entry.getValue().getContent());
                    bigTextNode.addContent((Content)translationNode);
                }
                listNode.addContent((Content)bigTextNode);
                linkedList.add(bigTextNode);
                ++var4_12;
            }
        }
        if (StringUtils.startsWith((String)this.namePrefix, (String)"qa-external")) {
            void var4_14;
            boolean bl = false;
            while (var4_14 < this.externalFilePaths.size()) {
                String externalFilePath = this.externalFilePaths.get((int)var4_14);
                Element element = new Element("external-file-reference-" + (int)var4_14);
                element.setAttribute("node", "/mounts/cmisMountPoint/Sites/" + this.cmisSite + externalFilePath, ContentGeneratorCst.NS_J);
                element.setAttribute("primaryType", "jnt:fileReference", ContentGeneratorCst.NS_JCR);
                listNode.addContent((Content)element);
                linkedList.add(element);
                ++var4_14;
            }
        }
        if (StringUtils.startsWith((String)this.namePrefix, (String)"qa-internal") && this.fileName != null) {
            Element element = new Element("rand-file");
            element.setAttribute("primaryType", "jnt:fileReference", ContentGeneratorCst.NS_JCR);
            Element fileTranslationNode = new Element("translation_en", ContentGeneratorCst.NS_J);
            fileTranslationNode.setAttribute("language", "en", ContentGeneratorCst.NS_JCR);
            fileTranslationNode.setAttribute("primaryType", "jnt:translation", ContentGeneratorCst.NS_JCR);
            fileTranslationNode.setAttribute("title", "My file", ContentGeneratorCst.NS_JCR);
            element.addContent((Content)fileTranslationNode);
            Element element2 = new Element("publication");
            element2.setAttribute("primaryType", "jnt:publication", ContentGeneratorCst.NS_JCR);
            Element element3 = new Element("translation_en", ContentGeneratorCst.NS_J);
            element3.setAttribute("author", "Jahia Content Generator");
            element3.setAttribute("body", "&lt;p&gt;  Random publication&lt;/p&gt;");
            element3.setAttribute("title", "Random publication", ContentGeneratorCst.NS_JCR);
            element3.setAttribute("file", "/sites/" + this.siteKey + "/files/contributed/" + ISO9075.encode((String)this.fileName));
            element3.setAttribute("language", "en", ContentGeneratorCst.NS_JCR);
            element3.setAttribute("primaryType", "jnt:translation", ContentGeneratorCst.NS_JCR);
            element3.setAttribute("source", "Jahia");
            element2.addContent((Content)element3);
            listNode.addContent((Content)element2);
        }
        if (this.personalized) {
            if (linkedList.isEmpty()) {
                this.personalized = false;
                this.pageElement.setName(this.getName());
            } else {
                Element element = (Element)linkedList.get(ThreadLocalRandom.current().nextInt(linkedList.size()));
                int elementIndex = listNode.indexOf((Content)element);
                listNode.removeContent((Content)element);
                Element element4 = this.getPersonalizedElement(element);
                listNode.addContent(elementIndex, (Content)element4);
            }
        }
        this.pageElement.addContent((Content)listNode);
        if (this.hasVanity.booleanValue()) {
            Element element = new Element("vanityUrlMapping");
            element.setAttribute("primaryType", "jnt:vanityUrls", ContentGeneratorCst.NS_JCR);
            Element vanitySubNode = new Element(this.namePrefix);
            vanitySubNode.setAttribute("active", "true", ContentGeneratorCst.NS_J);
            vanitySubNode.setAttribute("default", "true", ContentGeneratorCst.NS_J);
            vanitySubNode.setAttribute("url", "/" + this.namePrefix, ContentGeneratorCst.NS_J);
            vanitySubNode.setAttribute("language", "en", ContentGeneratorCst.NS_JCR);
            vanitySubNode.setAttribute("primaryType", "jnt:vanityUrl", ContentGeneratorCst.NS_JCR);
            element.addContent((Content)vanitySubNode);
            this.pageElement.addContent((Content)element);
        }
        if (this.visibilityEnabled.booleanValue()) {
            Element element = new Element("conditionalVisibility", ContentGeneratorCst.NS_J);
            element.setAttribute("conditionalVisibility", null, ContentGeneratorCst.NS_J);
            element.setAttribute("forceMatchAllConditions", "true", ContentGeneratorCst.NS_J);
            element.setAttribute("primaryType", "jnt:conditionalVisibility", ContentGeneratorCst.NS_JCR);
            Element visibilityConditionNode = new Element("startEndDateCondition0", ContentGeneratorCst.NS_JNT);
            visibilityConditionNode.setAttribute("primaryType", "jnt:startEndDateCondition", ContentGeneratorCst.NS_JCR);
            visibilityConditionNode.setAttribute("start", this.visibilityStartDate);
            visibilityConditionNode.setAttribute("end", this.visibilityEndDate);
            element.addContent((Content)visibilityConditionNode);
            this.pageElement.addContent((Content)element);
        }
        if (null != this.subPages) {
            for (PageBO subPage : this.subPages) {
                this.pageElement.addContent((Content)subPage.getElement());
            }
        }
    }

    public String getJcrXml() {
        return this.getElement().getText();
    }

    private Element getPersonalizedElement(Element element) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        Element personalizationElement = new Element("experience-" + element.getName());
        personalizationElement.setAttribute("primaryType", "wemnt:personalizedContent", ContentGeneratorCst.NS_JCR);
        personalizationElement.setAttribute("active", "true", ContentGeneratorCst.NS_WEM);
        personalizationElement.setAttribute("personalizationStrategy", "priority", ContentGeneratorCst.NS_WEM);
        String[] segments = ContentGeneratorCst.SEGMENTS[((Random)random).nextInt(ContentGeneratorCst.SEGMENTS.length)];
        int nbPersonalizationVariants = this.minPersonalizationVariants + ((Random)random).nextInt(this.maxPersonalizationVariants - this.minPersonalizationVariants + 1);
        if (nbPersonalizationVariants > segments.length) {
            nbPersonalizationVariants = segments.length;
        }
        for (int i = 0; i < nbPersonalizationVariants; ++i) {
            Element variantElement = (Element)element.clone();
            variantElement.setName(variantElement.getName() + "-" + (i + 1));
            Attribute mixinTypesAttribute = variantElement.getAttribute("mixinTypes", ContentGeneratorCst.NS_JCR);
            String mixinTypes = mixinTypesAttribute == null ? "" : mixinTypesAttribute.getValue() + " ";
            variantElement.setAttribute("mixinTypes", mixinTypes + "wemmix:editItem", ContentGeneratorCst.NS_JCR);
            String jsonFilter = "{\"parameterValues\":{\"subConditions\":[{\"type\":\"profileSegmentCondition\",\"parameterValues\":{\"segments\":[\"" + segments[i] + "\"]}}],\"operator\":\"and\"},\"type\":\"booleanCondition\"}";
            variantElement.setAttribute("jsonFilter", jsonFilter, ContentGeneratorCst.NS_WEM);
            personalizationElement.addContent((Content)variantElement);
        }
        return personalizationElement;
    }
}

