/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.properties;

import java.io.InputStream;
import java.util.Properties;

public abstract class PropertyLoader {
    private static final boolean THROW_ON_LOAD_FAILURE = true;
    private static final boolean LOAD_AS_RESOURCE_BUNDLE = false;
    private static final String SUFFIX = ".properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String pName, ClassLoader pLoader) {
        String name = pName;
        ClassLoader loader = pLoader;
        if (name == null) {
            throw new IllegalArgumentException("null input: name");
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith(SUFFIX)) {
            name = name.substring(0, name.length() - SUFFIX.length());
        }
        Properties result = null;
        InputStream in = null;
        try {
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            if (!(name = name.replace('.', '/')).endsWith(SUFFIX)) {
                name = name.concat(SUFFIX);
            }
            if ((in = loader.getResourceAsStream(name)) != null) {
                result = new Properties();
                result.load(in);
            }
        }
        catch (Exception e) {
            result = null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("could not load [" + name + "] as " + "a classloader resource");
        }
        return result;
    }

    public static Properties loadProperties(String name) {
        return PropertyLoader.loadProperties(name, Thread.currentThread().getContextClassLoader());
    }
}

