/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.osgi;

import aQute.bnd.osgi.Builder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tika.io.IOUtils;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jahia.utils.maven.plugin.osgi.DependenciesMojo;
import org.jahia.utils.maven.plugin.osgi.FindPackageUsesMojo;
import org.jahia.utils.maven.plugin.osgi.ParsingContextCache;
import org.jahia.utils.maven.plugin.support.MavenAetherHelperUtils;
import org.jahia.utils.osgi.BundleUtils;
import org.jahia.utils.osgi.ManifestValueClause;
import org.jahia.utils.osgi.PackageUtils;
import org.jahia.utils.osgi.parsers.FullyEqualPackageInfo;
import org.jahia.utils.osgi.parsers.PackageInfo;
import org.jahia.utils.osgi.parsers.ParsingContext;

public class CheckDependenciesMojo
extends DependenciesMojo {
    Set<PackageInfo> systemPackages = new TreeSet<PackageInfo>();
    private MavenProjectHelper mavenProjectHelper;
    private ArtifactHandlerManager artifactHandlerManager;
    protected String classifier;
    private ArchiverManager archiverManager;
    private File outputDirectory;
    private String buildDirectory;
    protected boolean failBuildOnSplitPackages = true;
    protected boolean failBuildOnMissingPackageExports = false;
    private boolean searchInDependencies = false;
    private static Map<String, Client> clients = new TreeMap<String, Client>();
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";

    public static List<String> findPackageInMavenCentral(String packageName) {
        ArrayList<String> artifactResults = new ArrayList<String>();
        Client client = CheckDependenciesMojo.getRestClient("http://search.maven.org");
        WebTarget target = client.target("http://search.maven.org").path("solrsearch/select").queryParam("q", new Object[]{"fc:\"" + packageName + "\""}).queryParam("rows", new Object[]{"5"}).queryParam("wt", new Object[]{"json"});
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        Map searchResults = null;
        try {
            Response response = invocationBuilder.get();
            searchResults = (Map)response.readEntity(Map.class);
        }
        catch (ProcessingException pe) {
            artifactResults.add("NETWORK ERROR: " + pe.getMessage());
        }
        if (searchResults != null) {
            Map searchResponse = (Map)searchResults.get("response");
            Integer searchResultCount = (Integer)searchResponse.get("numFound");
            List docs = (List)searchResponse.get("docs");
            for (Map doc : docs) {
                String artifactId = (String)doc.get("id");
                artifactResults.add(artifactId);
            }
        }
        return artifactResults;
    }

    private static Client getRestClient(String targetUrl) {
        if (clients.containsKey(targetUrl)) {
            return clients.get(targetUrl);
        }
        Client client = null;
        if (targetUrl != null) {
            if (targetUrl.startsWith("https://")) {
                try {
                    TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }

                        @Override
                        public void checkClientTrusted(X509Certificate[] certs, String authType) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] certs, String authType) {
                        }
                    }};
                    HostnameVerifier allHostsValid = new HostnameVerifier(){

                        @Override
                        public boolean verify(String hostname, SSLSession session) {
                            return true;
                        }
                    };
                    SSLContext sslContext = SSLContext.getInstance("SSL");
                    sslContext.init(null, trustAllCerts, new SecureRandom());
                    client = ClientBuilder.newBuilder().sslContext(sslContext).hostnameVerifier(allHostsValid).build();
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                catch (KeyManagementException e) {
                    e.printStackTrace();
                }
            } else {
                client = ClientBuilder.newClient();
            }
        }
        if (client == null) {
            return null;
        }
        client.property("jersey.config.client.connectTimeout", (Object)1000);
        client.property("jersey.config.client.readTimeout", (Object)3000);
        clients.put(targetUrl, client);
        return client;
    }

    @Override
    public void execute() throws MojoExecutionException {
        String artifactFilePath;
        File artifactFile;
        this.setBuildDirectory(this.projectBuildDirectory);
        this.setOutputDirectory(new File(this.projectOutputDirectory));
        if (!("jar".equals(this.project.getPackaging()) || "bundle".equals(this.project.getPackaging()) || "war".equals(this.project.getPackaging()))) {
            this.getLog().info((CharSequence)"Not a JAR/WAR/Bundle project, will do nothing.");
            return;
        }
        this.loadSystemPackages();
        this.buildExclusionPatterns();
        TreeSet<PackageInfo> explicitPackageImports = new TreeSet<PackageInfo>();
        ParsingContext projectParsingContext = new ParsingContext(MavenAetherHelperUtils.getCoords(this.project.getArtifact()), 0L, 0L, this.project.getArtifactId(), this.project.getBasedir().getPath(), this.project.getVersion(), null);
        ArrayList<PackageInfo> bundlePluginExplicitPackages = new ArrayList<PackageInfo>();
        LinkedHashMap<String, String> originalInstructions = new LinkedHashMap<String, String>();
        try {
            Xpp3Dom felixBundlePluginConfiguration = (Xpp3Dom)this.project.getPlugin("org.apache.felix:maven-bundle-plugin").getConfiguration();
            if (felixBundlePluginConfiguration != null) {
                Xpp3Dom instructionsDom = felixBundlePluginConfiguration.getChild("instructions");
                for (Xpp3Dom instructionChild : instructionsDom.getChildren()) {
                    originalInstructions.put(instructionChild.getName(), instructionChild.getValue());
                }
                if (felixBundlePluginConfiguration.getChild("excludeDependencies") != null) {
                    this.excludeDependencies = felixBundlePluginConfiguration.getChild("excludeDependencies").getValue();
                }
                this.getBundlePluginExplicitPackageImports(projectParsingContext, bundlePluginExplicitPackages, originalInstructions);
            }
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)("No maven-bundle-plugin found, will not use dependency exclude or deal with explicit Import-Package configurations. (" + e.getMessage() + ")"));
        }
        Properties properties = new Properties();
        try {
            Builder builder = this.getOSGiBuilder(this.project, originalInstructions, properties, this.getClasspath(this.project));
            this.resolveEmbeddedDependencies(this.project, builder);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error trying to process bundle plugin instructions", e);
        }
        List<PackageInfo> existingPackageImports = this.getExistingImportPackages(projectParsingContext);
        explicitPackageImports.addAll(existingPackageImports);
        this.parsingContextCache = new ParsingContextCache(new File(this.dependencyParsingCacheDirectory), null);
        long timer = System.currentTimeMillis();
        int scanned = 0;
        try {
            this.scanClassesBuildDirectory(projectParsingContext);
            this.getLog().info((CharSequence)("Scanned classes directory in " + (System.currentTimeMillis() - timer) + " ms. Found " + projectParsingContext.getLocalPackages().size() + " project packages."));
            scanned = this.scanDependencies(projectParsingContext);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while scanning dependencies", (Exception)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error while scanning project packages", (Exception)((Object)e));
        }
        this.getLog().info((CharSequence)("Scanned " + scanned + " project dependencies in " + (System.currentTimeMillis() - timer) + " ms. Currently we have " + projectParsingContext.getLocalPackages().size() + " project packages."));
        projectParsingContext.postProcess();
        if (projectParsingContext.getSplitPackages().size() > 0 && this.failBuildOnSplitPackages) {
            StringBuilder splitPackageList = new StringBuilder();
            for (PackageInfo packageInfo : projectParsingContext.getSplitPackages()) {
                splitPackageList.append("  ");
                splitPackageList.append(packageInfo.toString());
                splitPackageList.append(" from locations:\n    ");
                splitPackageList.append(StringUtils.join((Collection)packageInfo.getSourceLocations(), (String)"\n    "));
                splitPackageList.append("\n");
            }
            throw new MojoExecutionException("Detected split packages:\n" + splitPackageList.toString());
        }
        String extension = this.project.getPackaging();
        if ("bundle".equals(extension)) {
            extension = "jar";
        }
        if ((artifactFile = new File(artifactFilePath = this.project.getBuild().getDirectory() + "/" + this.project.getBuild().getFinalName() + "." + extension)) == null || !artifactFile.exists()) {
            throw new MojoExecutionException("No artifact generated for project, was the goal called in the proper phase (should be verify) ?");
        }
        Set<FullyEqualPackageInfo> allPackageExports = this.collectAllDependenciesExports(projectParsingContext, new HashSet<String>());
        TreeSet missingPackageExports = new TreeSet();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(artifactFile);
            Manifest manifest = jarFile.getManifest();
            if (manifest.getMainAttributes() == null) {
                throw new MojoExecutionException("Error reading OSGi bundle manifest data from artifact " + artifactFile);
            }
            String importPackageHeaderValue = manifest.getMainAttributes().getValue("Import-Package");
            TreeSet<String> visitedPackageImports = new TreeSet<String>();
            if (importPackageHeaderValue != null) {
                List importPackageClauses = BundleUtils.getHeaderClauses((String)"Import-Package", (String)importPackageHeaderValue);
                ArrayList<ManifestValueClause> clausesToRemove = new ArrayList<ManifestValueClause>();
                boolean modifiedImportPackageClauses = false;
                for (ManifestValueClause importPackageClause : importPackageClauses) {
                    for (String importPackagePath : importPackageClause.getPaths()) {
                        String clauseVersion = (String)importPackageClause.getAttributes().get("version");
                        String clauseResolution = (String)importPackageClause.getDirectives().get("resolution");
                        boolean optionalClause = false;
                        if ("optional".equals(clauseResolution)) {
                            optionalClause = true;
                        } else if ("mandatory".equals(clauseResolution)) {
                            optionalClause = false;
                        } else if (this.containsPackage(existingPackageImports, importPackagePath) || this.containsPackage(bundlePluginExplicitPackages, importPackagePath)) {
                            this.getLog().info((CharSequence)("Explicit package configuration found for " + importPackagePath + ", will not mark as optional."));
                        } else {
                            importPackageClause.getDirectives().put("resolution", "optional");
                            modifiedImportPackageClauses = true;
                        }
                        if (visitedPackageImports.contains(importPackagePath)) {
                            this.getLog().warn((CharSequence)("Duplicate import detected on package " + importPackagePath + ", will remove duplicate. To remove this warning remove the duplicate import (possibly coming from a explicit import in the maven-bundle-plugin instructions)"));
                            clausesToRemove.add(importPackageClause);
                            modifiedImportPackageClauses = true;
                        }
                        visitedPackageImports.add(importPackagePath);
                    }
                }
                if (modifiedImportPackageClauses) {
                    for (ManifestValueClause clauseToRemove : clausesToRemove) {
                        boolean removeSuccessful = importPackageClauses.remove(clauseToRemove);
                        if (removeSuccessful) continue;
                        this.getLog().warn((CharSequence)("Removal of clause " + clauseToRemove + " was not successful, duplicates may still remain in Manifest !"));
                    }
                    this.updateBundle(manifest, importPackageClauses, artifactFile, this.buildDirectory);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading OSGi bundle manifest data from artifact " + artifactFile, (Exception)e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        missingPackageExports.removeAll(explicitPackageImports);
        if (missingPackageExports.size() > 0) {
            ArrayList<String> missingPackageNames = new ArrayList<String>();
            for (PackageInfo missingPackageExport : missingPackageExports) {
                missingPackageNames.add(missingPackageExport.getName());
            }
            this.getLog().info((CharSequence)("Search for code origin of " + missingPackageExports.size() + " missing package imports, please wait..."));
            Map<String, Map<String, Artifact>> packageResults = FindPackageUsesMojo.findPackageUses(missingPackageNames, this.project.getArtifacts(), this.project, this.outputDirectory, this.searchInDependencies, this.getLog());
            if (packageResults.size() == 0) {
                this.getLog().warn((CharSequence)"No results found in project files, use the <searchInDependencies>true</searchInDependencies> parameter to make the plugin look in all the dependencies (which is MUCH slower !)");
            }
            StringBuilder optionaDirectivesBuilder = new StringBuilder();
            StringBuilder errorMessageBuilder = new StringBuilder();
            String separator = "";
            for (PackageInfo missingPackageExport : missingPackageExports) {
                optionaDirectivesBuilder.append(separator);
                errorMessageBuilder.append(missingPackageExport);
                List<String> artifactIDs = CheckDependenciesMojo.findPackageInMavenCentral(missingPackageExport.getName());
                if (artifactIDs.size() > 0) {
                    String artifactList = StringUtils.join(artifactIDs, (String)", ");
                    errorMessageBuilder.append(" (available from Maven Central artifacts ");
                    errorMessageBuilder.append(artifactList);
                    errorMessageBuilder.append(",... or more at ");
                    errorMessageBuilder.append(PackageUtils.getPackageSearchUrl((String)missingPackageExport.getName()));
                    errorMessageBuilder.append(" )");
                } else {
                    errorMessageBuilder.append(" (not found at Maven Central, is it part of JDK ?)");
                }
                missingPackageExport.setOptional(true);
                missingPackageExport.setVersion(null);
                optionaDirectivesBuilder.append(missingPackageExport);
                if (packageResults.containsKey(missingPackageExport.getName())) {
                    Map<String, Artifact> sourceLocations = packageResults.get(missingPackageExport.getName());
                    for (Map.Entry<String, Artifact> foundClass : sourceLocations.entrySet()) {
                        if (!foundClass.getValue().toString().equals(this.project.getArtifact().toString())) {
                            errorMessageBuilder.append("\n     used in class " + foundClass.getKey() + " (" + foundClass.getValue().getFile() + ")");
                            continue;
                        }
                        errorMessageBuilder.append("\n     used in class " + foundClass.getKey() + " (in project or embedded dependencies)");
                    }
                }
                errorMessageBuilder.append("\n\n");
                separator = ",\n";
            }
            this.getLog().warn((CharSequence)("Couldn't find any exported packages in Maven project dependencies for the following imported packages:\n" + errorMessageBuilder.toString()));
            this.getLog().warn((CharSequence)("Use the following lines in the <Import-Package> maven-bundle-plugin configuration to ignore these packages :\n" + optionaDirectivesBuilder.toString()));
            this.getLog().warn((CharSequence)" or add the missing dependencies to your Maven project by finding the related missing Maven dependency");
            this.getLog().warn((CharSequence)"");
            this.getLog().warn((CharSequence)"Bundle may not deploy successfully unless the above dependencies are either deployed, added to Maven project or marked explicitely as optional (as in the above list)");
            this.getLog().warn((CharSequence)"If you prefer to keep this warning activated but not fail the build, simply add <failBuildOnMissingPackageExports>false</failBuildOnMissingPackageExports> to the check-dependencies goal of the jahia-maven-plugin");
            this.getLog().warn((CharSequence)"");
            this.getLog().warn((CharSequence)"You could also use mvn jahia:find-package-uses -DpackageNames=COMMA_SEPARATED_PACKAGE_LIST to find where a specific package is used in the project");
            this.getLog().warn((CharSequence)"or mvn jahia:find-packages -DpackageNames=COMMA_SEPARATED_PACKAGE_LIST to find the packages inside the project");
            this.getLog().warn((CharSequence)"");
            if (this.failBuildOnMissingPackageExports) {
                throw new MojoExecutionException("Missing package exports for imported packages (see build log for details)");
            }
        }
    }

    public void getBundlePluginExplicitPackageImports(ParsingContext projectParsingContext, List<PackageInfo> bundlePluginExplicitPackages, Map<String, String> originalInstructions) throws IOException {
        String importPackageInstruction = originalInstructions.get("Import-Package");
        importPackageInstruction = importPackageInstruction.replaceAll(",(\\s)*\\$\\{.*\\}", "");
        List existingImportValueClauses = BundleUtils.getHeaderClauses((String)"Import-Package", (String)importPackageInstruction);
        for (ManifestValueClause existingImportValueClause : existingImportValueClauses) {
            String clauseVersion = (String)existingImportValueClause.getAttributes().get("version");
            String clauseResolution = (String)existingImportValueClause.getDirectives().get("resolution");
            boolean optionalClause = false;
            if ("optional".equals(clauseResolution)) {
                optionalClause = true;
            }
            for (String existingImportPath : existingImportValueClause.getPaths()) {
                bundlePluginExplicitPackages.add(new PackageInfo(existingImportPath, clauseVersion, optionalClause, "Maven plugin configuration", projectParsingContext));
            }
        }
    }

    private boolean containsPackage(List<PackageInfo> packages, String packageName) {
        for (PackageInfo packageInfo : packages) {
            if (!packageInfo.getName().equals(packageName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void updateBundle(Manifest manifest, List<ManifestValueClause> importPackageClauses, File artifactFile, String buildDirectory) {
        StringBuilder sb = new StringBuilder();
        String separator = "";
        for (ManifestValueClause importPackageClause : importPackageClauses) {
            sb.append(separator);
            sb.append(importPackageClause.toString());
            separator = ",";
        }
        manifest.getMainAttributes().putValue("Import-Package", sb.toString());
        File expandedJarDirectory = this.unpackBundle(artifactFile);
        this.getLog().info((CharSequence)("Extract JAR " + artifactFile + " contents to directory " + expandedJarDirectory));
        if (expandedJarDirectory == null) {
            this.getLog().error((CharSequence)("Error unpacking artifact " + artifactFile + " aborting bundle update"));
            return;
        }
        File manifestFile = new File(expandedJarDirectory, "META-INF/MANIFEST.MF");
        if (manifestFile.exists()) {
            this.getLog().info((CharSequence)"Overwriting existing META-INF/MANIFEST file");
        } else {
            this.getLog().warn((CharSequence)"Missing META-INF/MANIFEST.MF file in bundle, how did that happen ?");
        }
        FileOutputStream manifestFileOutputStream = null;
        try {
            manifestFileOutputStream = new FileOutputStream(manifestFile);
            manifest.write(manifestFileOutputStream);
        }
        catch (FileNotFoundException e) {
            this.getLog().error((CharSequence)"Error writing new META-INF/MANIFEST.MF file", (Throwable)e);
            IOUtils.closeQuietly((OutputStream)manifestFileOutputStream);
            return;
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error writing new META-INF/MANIFEST.MF file", (Throwable)e);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(manifestFileOutputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)manifestFileOutputStream);
            return;
        }
        IOUtils.closeQuietly((OutputStream)manifestFileOutputStream);
        this.packBundle(artifactFile, manifestFile, expandedJarDirectory);
        try {
            FileUtils.deleteDirectory((File)expandedJarDirectory);
            this.getLog().info((CharSequence)("Deleted temporary JAR extraction directory " + expandedJarDirectory));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Error purging temporary extracted JAR directory " + expandedJarDirectory), (Throwable)e);
        }
        Artifact mainArtifact = this.project.getArtifact();
        if ("bundle".equals(mainArtifact.getType())) {
            mainArtifact.setArtifactHandler(this.artifactHandlerManager.getArtifactHandler("jar"));
        }
        if (null == this.classifier || this.classifier.trim().length() == 0) {
            mainArtifact.setFile(artifactFile);
        } else {
            this.mavenProjectHelper.attachArtifact(this.project, artifactFile, this.classifier);
        }
    }

    public static String substVars(String val, String currentKey, Map cycleMap, Properties configProps) throws IllegalArgumentException {
        String substValue;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = -1;
        int startDelim = -1;
        do {
            int idx;
            if ((stopDelim = val.indexOf(DELIM_STOP, stopDelim + 1)) < 0) {
                return val;
            }
            startDelim = val.indexOf(DELIM_START);
            if (startDelim < 0) {
                return val;
            }
            while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
                if (idx >= stopDelim) continue;
                startDelim = idx;
            }
        } while (startDelim > stopDelim && stopDelim >= 0);
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String string = substValue = configProps != null ? configProps.getProperty(variable, null) : null;
        if (substValue == null) {
            substValue = System.getProperty(variable, "");
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = CheckDependenciesMojo.substVars(val, currentKey, cycleMap, configProps);
        return val;
    }

    private void loadSystemPackages() throws MojoExecutionException {
        Properties dependenciesProperties = new Properties();
        InputStream dependenciesPropertiesStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/jahia/utils/maven/plugin/osgi/dependencies.properties");
        try {
            dependenciesProperties.load(dependenciesPropertiesStream);
            dependenciesProperties.setProperty("dollar", "$");
            String propertyName = "org.osgi.framework.system.packages";
            String systemPackagesValue = dependenciesProperties.getProperty(propertyName);
            systemPackagesValue = systemPackagesValue != null ? CheckDependenciesMojo.substVars(systemPackagesValue, propertyName, null, dependenciesProperties) : null;
            List systemPackageClauses = BundleUtils.getHeaderClauses((String)"Export-Package", (String)systemPackagesValue);
            for (ManifestValueClause systemPackageClause : systemPackageClauses) {
                for (String systemPackagePath : systemPackageClause.getPaths()) {
                    String clauseVersion = (String)systemPackageClause.getAttributes().get("version");
                    PackageInfo systemPackageInfo = new PackageInfo(systemPackagePath, clauseVersion, false, "System packages", null);
                    this.systemPackages.add(systemPackageInfo);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error loading system exports", (Exception)e);
        }
    }

    private Set<FullyEqualPackageInfo> collectAllDependenciesExports(ParsingContext parsingContext, Set<String> alreadyVisitedContexts) {
        HashSet<FullyEqualPackageInfo> allExports = new HashSet<FullyEqualPackageInfo>();
        if (alreadyVisitedContexts.contains(parsingContext.getMavenCoords())) {
            return allExports;
        }
        alreadyVisitedContexts.add(parsingContext.getMavenCoords());
        if (parsingContext.getChildren() != null) {
            for (ParsingContext childParsingContext : parsingContext.getChildren()) {
                if (childParsingContext.isExternal()) {
                    allExports.addAll(FullyEqualPackageInfo.toFullyEqualPackageInfoSet((Set)childParsingContext.getPackageExports(), null));
                } else {
                    allExports.addAll(FullyEqualPackageInfo.toFullyEqualPackageInfoSet((Set)childParsingContext.getLocalPackages(), null));
                }
                allExports.addAll(this.collectAllDependenciesExports(childParsingContext, alreadyVisitedContexts));
            }
        }
        return allExports;
    }

    private File unpackBundle(File jarFile) {
        File outputDir = new File(this.buildDirectory, jarFile.getName() + "-" + System.currentTimeMillis());
        if (outputDir.exists()) {
            this.getLog().error((CharSequence)("Problem unpacking " + jarFile + " to " + outputDir + " : directory already exists !"));
            return null;
        }
        try {
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            UnArchiver unArchiver = this.archiverManager.getUnArchiver("jar");
            unArchiver.setDestDirectory(outputDir);
            unArchiver.setSourceFile(jarFile);
            unArchiver.extract();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Problem unpacking " + jarFile + " to " + outputDir), (Throwable)e);
            return null;
        }
        return outputDir;
    }

    private void packBundle(File jarFile, File manifestFile, File contentDirectory) {
        try {
            JarArchiver archiver = (JarArchiver)this.archiverManager.getArchiver("jar");
            archiver.setManifest(manifestFile);
            archiver.setDestFile(jarFile);
            archiver.addDirectory(contentDirectory, null, null);
            archiver.createArchive();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Problem packing " + jarFile + " with contents from  " + contentDirectory), (Throwable)e);
        }
    }

    private String getTrail(PackageInfo packageInfo) {
        ArrayList<ParsingContext> ancestors = new ArrayList<ParsingContext>();
        ParsingContext currentParsingContext = packageInfo.getOrigin();
        ancestors.add(currentParsingContext);
        while (currentParsingContext.getParentParsingContext() != null) {
            if ((currentParsingContext = currentParsingContext.getParentParsingContext()) == null) continue;
            ancestors.add(currentParsingContext);
        }
        Collections.reverse(ancestors);
        StringBuilder sb = new StringBuilder();
        String separator = "";
        for (ParsingContext parsingContext : ancestors) {
            sb.append(separator);
            sb.append(parsingContext.getMavenCoords());
            separator = " -> ";
        }
        sb.append(" : ");
        sb.append(packageInfo.toString());
        return sb.toString();
    }
}

