/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jahia.utils.maven.plugin.deployers.ServerDeploymentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractManagementMojo
extends AbstractMojo {
    protected String targetServerType;
    protected String targetServerVersion;
    protected String targetServerDirectory;
    public String webAppDirName;
    protected File baseDir;
    protected File output;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    protected MavenProject project;
    protected ArtifactRepository localRepository;
    private Integer projectStructureVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        org.jahia.configuration.deployers.ServerDeploymentFactory.setTargetServerDirectory((String)this.targetServerDirectory);
        ServerDeploymentFactory.setTargetServerDirectory((String)this.targetServerDirectory);
        this.doValidate();
        this.doExecute();
    }

    public void doValidate() throws MojoExecutionException, MojoFailureException {
    }

    public abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected List<File> getDependencies(String[] artifacts) throws ArtifactNotFoundException, ArtifactResolutionException {
        ArrayList<File> list = new ArrayList<File>();
        for (int i = 0; i < artifacts.length; ++i) {
            String curFQN = artifacts[i];
            StringTokenizer tokens = new StringTokenizer(curFQN, ":");
            String groupId = tokens.nextToken();
            String artifactId = tokens.nextToken();
            String versionId = tokens.nextToken();
            String typeId = "jar";
            if (tokens.hasMoreTokens()) {
                typeId = tokens.nextToken();
            }
            Artifact artifact = this.artifactFactory.createArtifactWithClassifier(groupId, artifactId, versionId, typeId, null);
            this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
            if (artifact.getFile() == null) {
                this.getLog().warn((CharSequence)("Unable to find file for artifact: " + artifact.getArtifactId()));
            }
            list.add(artifact.getFile());
        }
        return list;
    }

    protected int updateFiles(File sourceFolder, File destFolder) throws IOException {
        return this.updateFiles(sourceFolder, destFolder, null);
    }

    protected int updateFiles(File sourceFolder, File destFolder, String excluded) throws IOException {
        return this.updateFiles(sourceFolder, sourceFolder, destFolder, excluded);
    }

    protected int updateFiles(File sourceFolder, File originalSourceFolder, File destFolder, String excluded) throws IOException {
        long timer = System.currentTimeMillis();
        List filesToUpdate = org.codehaus.plexus.util.FileUtils.getFileNames((File)sourceFolder, (String)"**", (String)excluded, (boolean)false);
        int cnt = 0;
        for (String sourceFile : filesToUpdate) {
            File destFile = new File(destFolder, sourceFile);
            File origFile = new File(sourceFolder, sourceFile);
            File origSourceFile = new File(originalSourceFolder, sourceFile);
            long date = origFile.lastModified();
            if (origSourceFile.exists()) {
                date = origSourceFile.lastModified();
            }
            if (destFile.exists() && destFile.lastModified() >= date) continue;
            this.getLog().debug((CharSequence)("Copy " + origFile + " to " + destFile));
            FileUtils.copyFile((File)origFile, (File)destFile);
            ++cnt;
        }
        this.getLog().debug((CharSequence)("Copy took " + (System.currentTimeMillis() - timer)));
        timer = System.currentTimeMillis();
        org.codehaus.plexus.util.FileUtils.copyDirectoryLayout((File)sourceFolder, (File)destFolder, null, null);
        this.getLog().debug((CharSequence)("Dir layout took " + (System.currentTimeMillis() - timer)));
        return cnt;
    }

    protected String getWebappDeploymentDirName() {
        return this.webAppDirName != null ? this.webAppDirName : "jahia";
    }

    protected File getWebappDeploymentDir() throws Exception {
        return new File(this.targetServerDirectory, org.jahia.configuration.deployers.ServerDeploymentFactory.getInstance().getImplementation(this.targetServerType + this.targetServerVersion).getDeploymentDirPath(this.getWebappDeploymentDirName(), "war"));
    }

    protected File getWarSarRarDeploymentDir(Artifact artifact) throws Exception {
        File dir = artifact.getType().equals("rar") || artifact.getType().equals("sar") || artifact.getType().equals("jboss-sar") || artifact.getArtifactId().equals("config") ? new File(this.targetServerDirectory, org.jahia.configuration.deployers.ServerDeploymentFactory.getInstance().getImplementation(this.targetServerType + this.targetServerVersion).getDeploymentDirPath(artifact.getArtifactId(), artifact.getType())) : this.getWebappDeploymentDir();
        return dir;
    }

    public int getProjectStructureVersion() {
        if (this.projectStructureVersion != null) {
            return this.projectStructureVersion;
        }
        int version = 0;
        if (this.project.getProperties().containsKey("jahia.project.structure.version")) {
            version = Integer.parseInt((String)this.project.getProperties().get("jahia.project.structure.version"));
        }
        this.getLog().info((CharSequence)("Jahia project structure version is " + version));
        this.projectStructureVersion = version;
        return this.projectStructureVersion;
    }
}

