/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTree;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.codehaus.plexus.util.SelectorUtils;
import org.jahia.utils.maven.plugin.AbstractManagementMojo;
import org.jahia.utils.maven.plugin.ServerDeployer;
import org.jahia.utils.maven.plugin.deployers.ServerDeploymentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployMojo
extends AbstractManagementMojo {
    private DependencyTreeBuilder dependencyTreeBuilder;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private String address;
    protected ServerDeployer serverDeployer;
    private boolean deployTests;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.targetServerDirectory != null) {
                this.deployProject();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error when deploying", e);
        }
    }

    @Override
    public void doValidate() throws MojoExecutionException, MojoFailureException {
        try {
            this.serverDeployer = this.getProjectStructureVersion() == 2 ? new ServerDeployer(org.jahia.configuration.deployers.ServerDeploymentFactory.getInstance().getImplementation(this.targetServerType + this.targetServerVersion)) : new ServerDeployer(ServerDeploymentFactory.getInstance().getImplementation(this.targetServerType + this.targetServerVersion));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while validating deployers", e);
        }
        if (this.serverDeployer == null) {
            throw new MojoFailureException("Server " + this.targetServerType + " v" + this.targetServerVersion + " not (yet) supported by this plugin.");
        }
        if (!this.serverDeployer.validateInstallationDirectory(this.targetServerDirectory)) {
            throw new MojoFailureException("Directory " + this.targetServerDirectory + " is not a valid installation directory for server " + this.targetServerType + " v" + this.targetServerVersion);
        }
    }

    private void deployProject() throws Exception {
        if (this.skipDeploy()) {
            this.getLog().info((CharSequence)"jahia.deploy.skip is set to 'true' for the current project. Skip deploying it.");
            return;
        }
        if (this.project.getPackaging().equals("ear")) {
            this.deployEarProject();
        } else if (this.project.getPackaging().equals("war")) {
            if (this.project.getGroupId().equals("org.jahia.server") || this.project.getGroupId().equals("org.jahia.extensions")) {
                this.deployWarProject();
            } else if (this.project.getGroupId().equals("org.jahia.modules") || this.project.getGroupId().equals("org.jahia.templates") || this.deployTests && this.project.getGroupId().equals("org.jahia.test") || this.project.getGroupId().endsWith(".jahia.modules")) {
                if (this.getProjectStructureVersion() == 2) {
                    this.deployModuleProject();
                } else {
                    this.deployTemplateProject();
                }
            } else if (this.project.getGroupId().equals("org.jahia.test") && !this.deployTests) {
                this.getLog().info((CharSequence)"Deployment of test projects (with groupId 'org.jahia.test') is disabled by default. You can enable it by specifying -Djahia.deploy.deployTests option for the 'mvn jahia:deploy' command");
            }
        } else if (this.project.getPackaging().equals("sar") || this.project.getPackaging().equals("jboss-sar") || this.project.getPackaging().equals("rar")) {
            this.deploySarRarProject();
        } else if (this.project.getPackaging().equals("jar")) {
            if (this.project.getGroupId().equals("org.jahia.test") && !this.deployTests) {
                this.getLog().info((CharSequence)"Deployment of test projects (with groupId 'org.jahia.test') is disabled by default. You can enable it by specifying -Djahia.deploy.deployTests option for the 'mvn jahia:deploy' command");
            } else {
                this.deployJarProject();
            }
        } else if (this.project.getPackaging().equals("pom")) {
            this.deployPomProject();
        }
    }

    private boolean skipDeploy() {
        return Boolean.valueOf(this.project.getProperties().getProperty("jahia.deploy.skip", "false"));
    }

    private void deployEarProject() throws Exception {
        this.getLog().info((CharSequence)("Deploying application server specific files for " + this.targetServerType + " v" + this.targetServerVersion + " in directory " + this.targetServerDirectory));
        DependencyNode node = this.getRootDependencyNode();
        this.deployEarDependency(node);
    }

    private void deployWarProject() throws Exception {
        File webappDir = this.getWarSarRarDeploymentDir(this.project.getArtifact());
        this.getLog().info((CharSequence)("Update " + this.project.getPackaging() + " resources for " + this.targetServerType + " v" + this.targetServerVersion + " in directory " + webappDir));
        if ("was".equals(this.targetServerType)) {
            File source = new File(this.output, this.project.getBuild().getFinalName() + ".war");
            File target = new File(webappDir + "/" + this.project.getBuild().getFinalName() + ".war");
            try {
                FileUtils.copyFile((File)source, (File)target);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Error while deploying WAR project", (Throwable)e);
            }
        } else {
            File origSource = new File(this.baseDir, "src/main/webapp");
            File source = new File(this.output, this.project.getBuild().getFinalName());
            try {
                int cnt = this.updateFiles(source, origSource, webappDir, this.serverDeployer.getWarExcludes());
                this.getLog().info((CharSequence)("Copied " + cnt + " files."));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Error while deploying WAR project", (Throwable)e);
            }
        }
    }

    private void deploySarRarProject() throws Exception {
        File webappDir = this.getWarSarRarDeploymentDir(this.project.getArtifact());
        this.getLog().info((CharSequence)("Update " + this.project.getPackaging() + " resources for " + this.targetServerType + " v" + this.targetServerVersion + " in directory " + webappDir));
        File source = new File(this.output, this.project.getBuild().getFinalName());
        try {
            int cnt = this.updateFiles(source, webappDir);
            this.getLog().info((CharSequence)("Copied " + cnt + " files."));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error while deploying SAR or RAR project", (Throwable)e);
        }
    }

    private void deployModuleProject() throws Exception {
        File dbScripts;
        File webappDir = this.getWebappDeploymentDir();
        File source = new File(this.output, this.project.getArtifactId() + "-" + this.project.getVersion() + "." + this.project.getPackaging());
        File target = new File(webappDir, "WEB-INF/var/shared_modules");
        FileUtils.copyFileToDirectory((File)source, (File)target);
        this.getLog().info((CharSequence)("Copied " + source + " into " + target));
        File libs = new File(new File(this.output, this.project.getBuild().getFinalName()), "WEB-INF/lib");
        if (libs.isDirectory()) {
            File targetLibs = new File(webappDir, "WEB-INF");
            if (!targetLibs.isDirectory()) {
                targetLibs.mkdirs();
            }
            this.getLog().info((CharSequence)("Copying module libraries from " + libs + " into " + targetLibs));
            FileUtils.copyDirectoryToDirectory((File)libs, (File)targetLibs);
        }
        if ((dbScripts = new File(new File(this.output, this.project.getBuild().getFinalName()), "META-INF/db")).isDirectory()) {
            File targetScripts = new File(webappDir, "WEB-INF/var/db/sql/schema");
            if (!targetScripts.isDirectory()) {
                targetScripts.mkdirs();
            }
            this.getLog().info((CharSequence)("Copying database scripts from " + dbScripts + " into " + targetScripts));
            FileUtils.copyDirectory((File)dbScripts, (File)targetScripts);
        }
    }

    private void deployTemplateProject() throws Exception {
        File templateXml;
        File webappDir = this.getWebappDeploymentDir();
        File source = new File(this.output, this.project.getArtifactId() + "-" + this.project.getVersion());
        String prefix = "templates/";
        File target = new File(this.getWebappDeploymentDir(), prefix);
        if (!target.exists()) {
            prefix = "jsp/jahia/templates/";
        }
        if (!(templateXml = new File(source, "WEB-INF/templates.xml")).exists()) {
            this.getLog().info((CharSequence)"No template.xml file, bypassing template deployment");
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(templateXml)));
            String outputDir = null;
            while (outputDir == null) {
                String line = reader.readLine();
                if (!line.trim().startsWith("<root-folder>")) continue;
                outputDir = line.substring(line.indexOf(62) + 1, line.lastIndexOf(60));
            }
            target = new File(this.getWebappDeploymentDir(), prefix + outputDir);
            this.getLog().info((CharSequence)("Updated template war resources for " + this.targetServerType + " v" + this.targetServerVersion + " in directory " + target));
            int cnt = this.updateFiles(source, target, "**/WEB-INF,**/WEB-INF/**");
            this.getLog().info((CharSequence)("Copied " + (cnt += this.updateFiles(new File(source, "WEB-INF/classes"), new File(webappDir, "WEB-INF/classes"))) + " files."));
            FileUtils.copyFileToDirectory((File)templateXml, (File)target);
            this.getLog().info((CharSequence)"Updated template descriptor.");
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error while deploying template project", (Throwable)e);
        }
    }

    private void deployPrepackagedSiteProject() throws Exception {
        if (this.project.getAttachedArtifacts().size() > 0) {
            Artifact artifact = (Artifact)this.project.getAttachedArtifacts().get(this.project.getAttachedArtifacts().size() - 1);
            try {
                this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
                File libDir = new File(this.getWebappDeploymentDir(), "WEB-INF/var/prepackagedSites");
                libDir.mkdirs();
                File file = new File(libDir, artifact.getArtifactId() + ".zip");
                this.getLog().info((CharSequence)("Deploying prepackaged site " + artifact.getFile().getName() + " to " + file));
                FileUtils.copyFile((File)artifact.getFile(), (File)file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void deployJarProject() {
        Artifact artifact = this.project.getArtifact();
        try {
            this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
            File libDir = new File(new File(this.getWebappDeploymentDir(), "WEB-INF"), "lib");
            this.getLog().info((CharSequence)("Deploying jar file " + artifact.getFile().getName() + " to " + libDir));
            File deployedJar = new File(libDir, artifact.getFile().getName());
            if (deployedJar.exists()) {
                this.hotSwap(deployedJar);
            }
            FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)libDir);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while deploying JAR project", (Throwable)e);
        }
    }

    private void deployPomProject() {
        try {
            boolean sharedLibraries = this.project.getGroupId().equals("org.jahia.server") && this.project.getArtifactId().equals("shared-libraries");
            DependencyNode rootNode = this.getRootDependencyNode();
            List l = rootNode.getChildren();
            for (DependencyNode dependencyNode : l) {
                Artifact artifact = dependencyNode.getArtifact();
                if (artifact.getGroupId().equals("org.jahia.server")) {
                    if (artifact.getArtifactId().equals("jahia-ear") || artifact.getArtifactId().equals("jahia-ee-ear")) {
                        this.deployEarDependency(dependencyNode);
                    } else if (artifact.getArtifactId().equals("configwizard-ear")) {
                        this.deployEarDependency(dependencyNode);
                    } else if (artifact.getArtifactId().equals("configwizard-webapp") || artifact.getArtifactId().equals("jahia-war") || artifact.getArtifactId().equals("jahia-ee-war") || artifact.getArtifactId().equals("jahia-pack-war") || artifact.getArtifactId().equals("jahia-dm-package") || artifact.getArtifactId().equals("jahia-ee-dm-package") || artifact.getArtifactId().equals("jahia-jboss-config")) {
                        this.deployWarRarSarDependency(dependencyNode);
                    } else if (artifact.getArtifactId().equals("shared-libraries")) {
                        this.deploySharedLibraries(dependencyNode);
                    }
                }
                if (!sharedLibraries) continue;
                this.deploySharedLibrary(artifact);
            }
            if (this.project.getParent() != null && "prepackagedSites".equals(this.project.getParent().getArtifactId())) {
                this.deployPrepackagedSiteProject();
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while deploying POM project", (Throwable)e);
        }
    }

    protected DependencyNode getRootDependencyNode() throws DependencyTreeBuilderException {
        DependencyTree dependencyTree = this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepository, this.artifactFactory, this.artifactMetadataSource, this.artifactCollector);
        DependencyNode rootNode = dependencyTree.getRootNode();
        return rootNode;
    }

    protected void deployEarDependency(DependencyNode dependencyNode) throws ArtifactResolutionException, ArtifactNotFoundException {
        List child = dependencyNode.getChildren();
        for (DependencyNode node : child) {
            Artifact artifact = node.getArtifact();
            this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
            try {
                if (artifact.getGroupId().equals("org.jahia.server") && (artifact.getArtifactId().equals("jahia-war") || artifact.getArtifactId().equals("jahia-ee-war") || artifact.getArtifactId().equals("config")) || artifact.getType().equals("rar") || artifact.getType().equals("sar") || artifact.getType().equals("jboss-sar")) {
                    this.deployWarRarSarDependency(node);
                    continue;
                }
                if (!"compile".equals(artifact.getScope())) continue;
                this.deploySharedLibrary(artifact);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Error while deploying EAR dependency", (Throwable)e);
            }
        }
    }

    private void deploySharedLibraries(DependencyNode dependencyNode) throws IOException, ArtifactResolutionException, ArtifactNotFoundException {
        for (DependencyNode node : dependencyNode.getChildren()) {
            Artifact artifact = node.getArtifact();
            this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
            try {
                this.deploySharedLibrary(artifact);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Error while deploying EAR dependency", (Throwable)e);
            }
        }
    }

    private void deploySharedLibrary(Artifact artifact) throws IOException {
        this.getLog().info((CharSequence)("Copy shared resource " + artifact.getFile().getName()));
        LinkedList<File> sharedLibs = new LinkedList<File>();
        sharedLibs.add(artifact.getFile());
        this.serverDeployer.deploySharedLibraries(this.targetServerDirectory, sharedLibs);
    }

    protected void deployWarRarSarDependency(DependencyNode dependencyNode) throws Exception {
        Artifact artifact = dependencyNode.getArtifact();
        File webappDir = this.getWarSarRarDeploymentDir(artifact);
        this.getLog().info((CharSequence)("Update " + artifact.getType() + " resources for " + this.targetServerType + " v" + this.targetServerVersion + " in directory " + webappDir));
        String[] excludes = this.serverDeployer.getWarExcludes() != null ? StringUtils.split((String)this.serverDeployer.getWarExcludes(), (String)",") : null;
        try {
            ZipEntry entry;
            ZipInputStream z = new ZipInputStream(new FileInputStream(artifact.getFile()));
            int cnt = 0;
            while ((entry = z.getNextEntry()) != null) {
                if (!entry.isDirectory()) {
                    if (excludes != null) {
                        boolean doExclude = false;
                        for (String excludePattern : excludes) {
                            if (!SelectorUtils.matchPath((String)excludePattern, (String)entry.getName())) continue;
                            doExclude = true;
                            break;
                        }
                        if (doExclude) continue;
                    }
                    File target = new File(webappDir, entry.getName());
                    if (entry.getTime() <= target.lastModified()) continue;
                    target.getParentFile().mkdirs();
                    FileOutputStream fileOutputStream = new FileOutputStream(target);
                    IOUtils.copy((InputStream)z, (OutputStream)fileOutputStream);
                    fileOutputStream.close();
                    ++cnt;
                    continue;
                }
                new File(webappDir, entry.getName()).mkdir();
            }
            z.close();
            this.getLog().info((CharSequence)("Copied " + cnt + " files."));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error while deploying dependency", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hotSwap(File deployedJar) {
        int colonIndex = this.address.indexOf(58);
        String connectorName = this.address.substring(0, colonIndex);
        if (connectorName.equals("socket")) {
            connectorName = "com.sun.jdi.SocketAttach";
        } else if (connectorName.equals("shmem")) {
            connectorName = "com.sun.jdi.SharedMemoryAttach";
        }
        String argumentsString = this.address.substring(colonIndex + 1);
        AttachingConnector connector = (AttachingConnector)this.findConnector(connectorName);
        Map<String, Connector.Argument> arguments = connector.defaultArguments();
        StringTokenizer st = new StringTokenizer(argumentsString, ",");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            int index = pair.indexOf(61);
            String name = pair.substring(0, index);
            String value = pair.substring(index + 1);
            Connector.Argument argument = arguments.get(name);
            if (argument == null) continue;
            argument.setValue(value);
        }
        HashMap<String, Long> dates = new HashMap<String, Long>();
        try {
            ZipEntry entry;
            ZipInputStream z = new ZipInputStream(new FileInputStream(deployedJar));
            while ((entry = z.getNextEntry()) != null) {
                dates.put(entry.getName(), entry.getTime());
            }
            z.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        VirtualMachine vm = null;
        try {
            vm = connector.attach(arguments);
            this.getLog().info((CharSequence)("Connected to " + vm.name() + " " + vm.version()));
            HashMap<String, File> files = new HashMap<String, File>();
            this.parse(new File(this.output, "classes"), dates, "", files);
            this.getLog().debug((CharSequence)("Classes : " + files.keySet()));
            if (!files.isEmpty()) {
                this.reload(vm, files);
            }
        }
        catch (ConnectException e) {
            this.getLog().warn((CharSequence)("Cannot hotswap classes : " + e.getMessage()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalConnectorArgumentsException e) {
            e.printStackTrace();
        }
        finally {
            if (vm != null) {
                vm.dispose();
            }
        }
    }

    private Connector findConnector(String name) {
        List<Connector> connectors = Bootstrap.virtualMachineManager().allConnectors();
        for (Connector connector : connectors) {
            if (!connector.name().equals(name)) continue;
            return connector;
        }
        return null;
    }

    private void parse(File folder, Map<String, Long> dates, String base, Map<String, File> result) {
        File[] files;
        for (File file : files = folder.listFiles()) {
            String name;
            String classFileName;
            String filename = file.getName();
            if (file.isDirectory()) {
                this.parse(file, dates, base + filename + ".", result);
                continue;
            }
            if (!filename.endsWith(".class") || !dates.containsKey(classFileName = (name = base + filename.substring(0, filename.lastIndexOf("."))).replace(".", "/") + ".class")) continue;
            long l = dates.get(classFileName);
            if (file.lastModified() <= l) continue;
            result.put(name, file);
            this.getLog().debug((CharSequence)("Updated class : " + file));
        }
    }

    public void reload(VirtualMachine vm, Map<String, File> classFiles) {
        HashMap<ReferenceType, byte[]> map = new HashMap<ReferenceType, byte[]>();
        for (String className : classFiles.keySet()) {
            List<ReferenceType> classes = vm.classesByName(className);
            if (classes.size() != 1) continue;
            ReferenceType refType = classes.get(0);
            File f = classFiles.get(className);
            byte[] bytes = new byte[(int)f.length()];
            try {
                FileInputStream in = new FileInputStream(f);
                ((InputStream)in).read(bytes);
                ((InputStream)in).close();
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Error reading file " + f), (Throwable)e);
                continue;
            }
            map.put(refType, bytes);
        }
        try {
            vm.redefineClasses(map);
            this.getLog().info((CharSequence)("Reloaded " + map.size() + " classes."));
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Cannot reload classes : " + e.getMessage()));
        }
    }
}

