/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class TestMojo
extends AbstractMojo {
    protected String testURL;
    protected String test;
    protected boolean startupWait;
    protected int startupTimeout;
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (StringUtils.isEmpty((String)this.test) || this.test.contains("*")) {
            this.executeAllTests();
        } else {
            this.executeTest(this.test);
        }
    }

    private void executeAllTests() {
        try {
            String line;
            ArrayList<String> targets = new ArrayList<String>();
            String url1 = this.testURL + "/test" + (StringUtils.isNotEmpty((String)this.test) ? "/" + this.test : "");
            this.getLog().info((CharSequence)("Get tests from : " + url1));
            URLConnection conn = null;
            if (this.startupWait) {
                this.getLog().info((CharSequence)"Waiting for jahia startup");
                for (int i = this.startupTimeout; i > 0; --i) {
                    try {
                        conn = new URL(url1).openConnection();
                        conn.connect();
                        break;
                    }
                    catch (IOException e) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                        System.out.print(".");
                        continue;
                    }
                }
            } else {
                conn = new URL(url1).openConnection();
            }
            InputStream is = null;
            if (conn != null) {
                is = conn.getInputStream();
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(is));
            while ((line = r.readLine()) != null) {
                this.getLog().info((CharSequence)("Adding test " + line));
                targets.add(line);
            }
            if (is != null) {
                is.close();
            }
            long timer = System.currentTimeMillis();
            this.getLog().info((CharSequence)("Start executing all tests (" + targets.size() + ")..."));
            for (String s : targets) {
                this.executeTest(s);
            }
            this.getLog().info((CharSequence)("...done in " + (System.currentTimeMillis() - timer) / 1000L + " s"));
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTest(String test) {
        long timer = System.currentTimeMillis();
        try {
            boolean b;
            String testUrl = this.testURL + "/test/" + test;
            this.getLog().info((CharSequence)("Execute: " + testUrl));
            URLConnection conn = new URL(testUrl).openConnection();
            InputStream is = conn.getInputStream();
            File out = this.project.getBasedir();
            out = new File(out, "target/surefire-reports");
            if (!out.exists() && !(b = out.mkdirs())) {
                this.getLog().error((CharSequence)("could not create directory " + out.getAbsolutePath()));
            }
            FileOutputStream os = new FileOutputStream(new File(out, "TEST-" + test + ".xml"));
            IOUtils.copy((InputStream)is, (OutputStream)os);
            is.close();
            os.close();
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
        finally {
            this.getLog().info((CharSequence)("...done " + test + " in " + (System.currentTimeMillis() - timer) + " ms"));
        }
    }
}

