/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.bo;

import org.apache.commons.lang.StringUtils;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jdom.Content;
import org.jdom.Element;

public class UserBO {
    private String name;
    private String password;
    private String jcrPath;
    private String email;

    public UserBO(String name, String password, String pathJcr) {
        this.name = name;
        this.password = password;
        this.email = this.name + "@example.com";
        this.jcrPath = pathJcr;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPathJcr() {
        return this.jcrPath;
    }

    public void setPathJcr(String pathJcr) {
        this.jcrPath = pathJcr;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getDirectoryName(int indexDir) {
        String dirname = null;
        if (this.jcrPath != null) {
            String[] directories = StringUtils.split((String)this.jcrPath, (String)"/");
            dirname = directories[indexDir];
        }
        return dirname;
    }

    public Element getJcrXml() {
        Element userElement = new Element(this.name);
        userElement.setAttribute("email", this.email);
        userElement.setAttribute("emailNotificationsDisabled", Boolean.FALSE.toString());
        userElement.setAttribute("accountLocked", Boolean.FALSE.toString(), ContentGeneratorCst.NS_J);
        userElement.setAttribute("email", this.email, ContentGeneratorCst.NS_J);
        userElement.setAttribute("external", Boolean.FALSE.toString(), ContentGeneratorCst.NS_J);
        userElement.setAttribute("firstName", this.name + " firstname", ContentGeneratorCst.NS_J);
        userElement.setAttribute("lastName", this.name + " lastname", ContentGeneratorCst.NS_J);
        userElement.setAttribute("organization", "Organization", ContentGeneratorCst.NS_J);
        userElement.setAttribute("password", this.password, ContentGeneratorCst.NS_J);
        userElement.setAttribute("picture", this.jcrPath + "/files/profile/publisher.png", ContentGeneratorCst.NS_J);
        userElement.setAttribute("published", Boolean.TRUE.toString(), ContentGeneratorCst.NS_J);
        userElement.setAttribute("firstName", this.name + " firstname", ContentGeneratorCst.NS_J);
        userElement.setAttribute("mixinTypes", "jmix:accessControlled", ContentGeneratorCst.NS_JCR);
        userElement.setAttribute("primaryType", "jnt:user", ContentGeneratorCst.NS_JCR);
        userElement.setAttribute("preferredLanguage", "en");
        if (this.jcrPath == null) {
            return userElement;
        }
        String dir1 = this.getDirectoryName(1);
        String dir2 = this.getDirectoryName(2);
        String dir3 = this.getDirectoryName(3);
        Element root = new Element(dir1);
        root.setAttribute("primaryType", "jnt:usersFolder", ContentGeneratorCst.NS_JCR);
        Element subElement1 = new Element(dir2);
        subElement1.setAttribute("primaryType", "jnt:usersFolder", ContentGeneratorCst.NS_JCR);
        root.addContent((Content)subElement1);
        Element subElement2 = new Element(dir3);
        subElement2.setAttribute("primaryType", "jnt:usersFolder", ContentGeneratorCst.NS_JCR);
        subElement1.addContent((Content)subElement2);
        subElement2.addContent((Content)userElement);
        return root;
    }
}

