/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.modules;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public class PackageModuleImportsMojo
extends AbstractMojo {
    protected String archiveName;
    protected File dest;
    protected String excludes;
    protected String includes;
    protected MavenProject project;
    protected boolean requiresModuleProject;
    protected File src;
    protected boolean verbose;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.requiresModuleProject && (!"war".equals(this.project.getPackaging()) || !this.project.getGroupId().equals("org.jahia.modules") && !this.project.getGroupId().endsWith(".jahia.modules"))) {
            this.getLog().info((CharSequence)"Current project should have 'war' packaging type and be a Jahia module project to be able to execute this goal. Skipping package-imports task.");
            return;
        }
        if (this.src == null || !this.src.exists() || !this.src.isDirectory()) {
            this.getLog().info((CharSequence)("Folder " + this.src + " does not exist." + " Skipping package-imports task."));
            return;
        }
        if (this.src.listFiles().length == 0) {
            this.getLog().info((CharSequence)("Folder " + this.src + " does not contain any files." + " Skipping package-imports task."));
            return;
        }
        ZipArchiver archiver = new ZipArchiver();
        if (this.verbose) {
            archiver.enableLogging((Logger)new ConsoleLogger(0, "console"));
        }
        if (!this.dest.exists()) {
            this.dest.mkdirs();
        }
        File absoluteDestFile = new File(this.dest, this.archiveName);
        archiver.setDestFile(absoluteDestFile);
        this.getLog().info((CharSequence)("Packaging imports from " + this.src + " into archive " + absoluteDestFile + " (excludes=" + this.excludes + ", inludes=" + this.includes + ")"));
        try {
            archiver.addDirectory(this.src, this.excludes != null ? this.excludes.split(",") : null, this.includes != null ? this.includes.split(",") : null);
            archiver.createArchive();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

