/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.jahia.utils.maven.plugin.contentgenerator.ArticleService;
import org.jahia.utils.maven.plugin.contentgenerator.ContentGeneratorService;
import org.jahia.utils.maven.plugin.contentgenerator.FileService;
import org.jahia.utils.maven.plugin.contentgenerator.OutputService;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ArticleBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ExportBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.PageBO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageService {
    private Log logger = new SystemStreamLog();
    String sep;
    private Random random = new Random();

    public PageService() {
        this.sep = System.getProperty("file.separator");
    }

    public void createTopPages(ExportBO export, List<ArticleBO> articles) throws IOException {
        ArticleService articleService = ArticleService.getInstance();
        this.logger.info((CharSequence)"Creating top pages");
        PageBO pageTopLevel = null;
        HashMap<String, ArticleBO> articlesMap = new HashMap<String, ArticleBO>();
        for (String language : export.getSiteLanguages()) {
            articlesMap.put(language, articleService.getArticle(articles));
        }
        String rootPageName = export.getRootPageName();
        PageBO rootPage = this.createNewPage(export, rootPageName, articlesMap, export.getNbSubLevels() + 1, null);
        OutputService outService = new OutputService();
        outService.initOutputFile(export.getOutputFile());
        outService.appendStringToFile(export.getOutputFile(), export.toString());
        outService.appendStringToFile(export.getOutputFile(), rootPage.getHeader());
        for (int i = 1; i <= export.getNbPagesTopLevel(); ++i) {
            for (String language : export.getSiteLanguages()) {
                articlesMap.put(language, articleService.getArticle(articles));
            }
            pageTopLevel = this.createNewPage(export, null, articlesMap, export.getNbSubLevels() + 1, this.createSubPages(export, articles, export.getNbSubLevels(), export.getMaxArticleIndex()));
            outService.appendPageToFile(export.getOutputFile(), pageTopLevel);
            this.logger.info((CharSequence)"Pages path are being written to the map file");
            ArrayList<PageBO> listeTopPage = new ArrayList<PageBO>();
            listeTopPage.add(pageTopLevel);
            List<String> pagesPath = this.getPagesPath(listeTopPage, "/sites/" + export.getSiteKey() + "/" + rootPage.getUniqueName());
            outService.appendPathToFile(export.getMapFile(), pagesPath);
            this.logger.debug((CharSequence)("XML code of top level page #" + i + " written in output file"));
            this.logger.info((CharSequence)("Top page #" + i + " with subpages created and written to file"));
        }
        outService.appendStringToFile(export.getOutputFile(), rootPage.getFooter());
    }

    public List<PageBO> createSubPages(ExportBO export, List<ArticleBO> articles, Integer level, Integer maxArticleIndex) {
        ArticleService articleService = ArticleService.getInstance();
        ArrayList<PageBO> listePages = new ArrayList<PageBO>();
        int nbPagesPerLevel = export.getNbSubPagesPerPage();
        listePages.clear();
        if (level > 0) {
            for (int i = 0; i < nbPagesPerLevel; ++i) {
                HashMap<String, ArticleBO> articlesMap = new HashMap<String, ArticleBO>();
                for (String language : export.getSiteLanguages()) {
                    articlesMap.put(language, articleService.getArticle(articles));
                }
                PageBO page = this.createNewPage(export, null, articlesMap, level, this.createSubPages(export, articles, level - 1, maxArticleIndex + 1));
                listePages.add(page);
            }
        }
        return listePages;
    }

    public PageBO createNewPage(ExportBO export, String pageName, Map<String, ArticleBO> articlesMap, int level, List<PageBO> subPages) {
        boolean addFile = false;
        if (export.getAddFilesToPage().equals("all")) {
            addFile = true;
        } else if (export.getAddFilesToPage().equals("random")) {
            Random random = new Random();
            addFile = random.nextBoolean();
        }
        String fileName = null;
        if (addFile) {
            FileService fileService = new FileService();
            fileName = fileService.getFileName(export.getFileNames());
        }
        this.logger.debug((CharSequence)("\t\tCreating new page level " + level + " - Page " + ContentGeneratorService.currentPageIndex + " - Articles " + articlesMap + " - file attached " + fileName));
        if (pageName == null) {
            pageName = "page" + ContentGeneratorService.currentPageIndex;
        }
        HashMap<String, List<String>> acls = new HashMap<String, List<String>>();
        if ((double)this.random.nextFloat() < export.getGroupAclRatio() && export.getNumberOfGroups() > 0) {
            acls.put("g:group" + this.random.nextInt(export.getNumberOfGroups()), Arrays.asList("editor"));
        }
        if ((double)this.random.nextFloat() < export.getUsersAclRatio() && export.getNumberOfUsers() > 0) {
            acls.put("u:user" + this.random.nextInt(export.getNumberOfUsers()), Arrays.asList("editor"));
        }
        Integer idCategory = null;
        float firstThird = export.getTotalPages() / 3;
        if ((float)ContentGeneratorService.currentPageIndex <= firstThird && export.getNumberOfCategories() > 0) {
            idCategory = this.random.nextInt(export.getNumberOfCategories());
            this.logger.debug((CharSequence)("Add " + pageName + " to category " + idCategory));
        }
        Integer idTag = null;
        if ((float)ContentGeneratorService.currentPageIndex <= firstThird && export.getNumberOfTags() > 0) {
            idTag = this.random.nextInt(export.getNumberOfTags());
            this.logger.debug((CharSequence)("Tag " + pageName + " with tag " + idTag));
        }
        Boolean visibilityOnPage = Boolean.FALSE;
        if ((float)ContentGeneratorService.currentPageIndex <= firstThird && export.getVisibilityEnabled().booleanValue()) {
            visibilityOnPage = Boolean.TRUE;
            this.logger.debug((CharSequence)"Visibility enabled");
        }
        PageBO page = new PageBO(pageName, articlesMap, level, subPages, export.getPagesHaveVanity(), export.getSiteKey(), fileName, export.getNumberOfBigTextPerPage(), acls, idCategory, idTag, visibilityOnPage, export.getVisibilityStartDate(), export.getVisibilityEndDate());
        ++ContentGeneratorService.currentPageIndex;
        return page;
    }

    public List<String> getPagesPath(List<PageBO> pages, String path) {
        ArrayList<String> siteMap = new ArrayList<String>();
        if (path == null) {
            path = "";
        }
        for (PageBO page : pages) {
            String newPath = path + "/" + page.getUniqueName();
            this.logger.debug((CharSequence)("new path: " + newPath));
            siteMap.add(newPath);
            if (page.getSubPages() == null) continue;
            siteMap.addAll(this.getPagesPath(page.getSubPages(), newPath));
        }
        return siteMap;
    }
}

