/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.wise;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.FileBO;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.FolderBO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAndFolderService {
    private static FileAndFolderService instance;
    String sep = System.getProperty("file.separator");

    private FileAndFolderService() {
    }

    public static FileAndFolderService getInstance() {
        if (instance == null) {
            instance = new FileAndFolderService();
        }
        return instance;
    }

    public List<FolderBO> generateFolders(Integer foldersDepth, Integer nbFoldersPerLevel, Integer filesPerFolder, List<String> fileNames, String outputDirPath, String wiseInstanceName, String docpaceKey, File filesDirectory) {
        return this.generateFolders(1, nbFoldersPerLevel, foldersDepth, filesPerFolder, fileNames, this.initializeContentFolder(outputDirPath, wiseInstanceName, docpaceKey), filesDirectory);
    }

    private List<FolderBO> generateFolders(Integer currentDepth, Integer nbFoldersPerLevel, Integer foldersDepth, Integer filesPerFolder, List<String> fileNames, String currentPath, File filesDirectory) {
        String depthName;
        switch (currentDepth) {
            case 1: {
                depthName = "aaa";
                break;
            }
            case 2: {
                depthName = "bbb";
                break;
            }
            case 3: {
                depthName = "ccc";
                break;
            }
            case 4: {
                depthName = "ddd";
                break;
            }
            case 5: {
                depthName = "eee";
                break;
            }
            case 6: {
                depthName = "fff";
                break;
            }
            case 7: {
                depthName = "ggg";
                break;
            }
            case 8: {
                depthName = "hhh";
                break;
            }
            case 9: {
                depthName = "iii";
                break;
            }
            default: {
                depthName = "aaa";
            }
        }
        ArrayList<FolderBO> folders = new ArrayList<FolderBO>();
        for (int i = 0; i < nbFoldersPerLevel; ++i) {
            List<FolderBO> subFolders = null;
            List<FileBO> files = this.generateFiles(filesPerFolder, fileNames);
            if (currentDepth < foldersDepth) {
                subFolders = this.generateFolders(currentDepth + 1, nbFoldersPerLevel, foldersDepth, filesPerFolder, fileNames, currentPath + this.sep + depthName + i, filesDirectory);
            }
            folders.add(new FolderBO(depthName + i, subFolders, files));
            File newFolder = new File(currentPath + this.sep + depthName + i);
            newFolder.mkdirs();
            for (FileBO fileBO : files) {
                File sourceFile = new File(filesDirectory + this.sep + fileBO.getFileName());
                File targetDirectory = new File(newFolder + this.sep + fileBO.getFileName());
                targetDirectory.mkdir();
                File targetFile = new File(targetDirectory + this.sep + fileBO.getFileName());
                try {
                    FileUtils.copyFile((File)sourceFile, (File)targetFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return folders;
    }

    public List<FileBO> generateFiles(Integer nbFiles, List<String> fileNames) {
        ArrayList<FileBO> files = new ArrayList<FileBO>();
        Random rand = new Random();
        for (int i = 0; i < nbFiles; ++i) {
            String fileName = fileNames.get(rand.nextInt(fileNames.size() - 1));
            files.add(new FileBO(fileName));
        }
        return files;
    }

    public String initializeContentFolder(String outputDirPath, String wiseInstanceName, String docpaceKey) {
        File contentdirectory = new File(outputDirPath + this.sep + "content" + this.sep + "sites" + this.sep + wiseInstanceName + this.sep + "files" + this.sep + "docspaces" + this.sep + docpaceKey);
        contentdirectory.mkdirs();
        return contentdirectory.getAbsolutePath();
    }
}

