/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.wise.bo;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.FolderBO;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.NoteBO;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.PollBO;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.TaskBO;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocspaceBO {
    private Element docspaceElement;
    private String docspaceName;
    private String fromEmail = "invitedto@vibes.jahia.com";
    private List<PollBO> polls;
    private List<NoteBO> notes;
    private List<TaskBO> tasks;
    private List<FolderBO> folders;

    public DocspaceBO(String docspaceName, List<PollBO> polls, List<NoteBO> notes, List<TaskBO> tasks, List<FolderBO> folders) {
        this.docspaceName = docspaceName;
        this.polls = polls;
        this.notes = notes;
        this.tasks = tasks;
        this.folders = folders;
    }

    public Element getElement() {
        if (this.docspaceElement == null) {
            this.docspaceElement = new Element(this.docspaceName);
            this.docspaceElement.setAttribute("fromEmail", this.fromEmail);
            this.docspaceElement.setAttribute("mixinTypes", "docmix:docspace jmix:accessControlled", ContentGeneratorCst.NS_JCR);
            this.docspaceElement.setAttribute("primaryType", "jnt:folder", ContentGeneratorCst.NS_JCR);
            Element translationEn = new Element("translation_en", ContentGeneratorCst.NS_J);
            translationEn.setAttribute("primaryType", "jnt:translation", ContentGeneratorCst.NS_JCR);
            translationEn.setAttribute("description", "Created by the Jahia Content Generator", ContentGeneratorCst.NS_JCR);
            translationEn.setAttribute("title", "Docspace: " + this.docspaceName, ContentGeneratorCst.NS_JCR);
            this.docspaceElement.addContent((Content)translationEn);
            if (CollectionUtils.isNotEmpty(this.polls)) {
                Element pollsElement = new Element("polls");
                pollsElement.setAttribute("primaryType", "docnt:pollsContainer", ContentGeneratorCst.NS_JCR);
                for (PollBO poll : this.polls) {
                    pollsElement.addContent((Content)poll.getElement());
                }
                this.docspaceElement.addContent((Content)pollsElement);
            }
            if (CollectionUtils.isNotEmpty(this.notes)) {
                Element notesElement = new Element("notes");
                notesElement.setAttribute("primaryType", "docnt:notesContainer", ContentGeneratorCst.NS_JCR);
                for (NoteBO note : this.notes) {
                    notesElement.addContent((Content)note.getElement());
                }
                this.docspaceElement.addContent((Content)notesElement);
            }
            if (CollectionUtils.isNotEmpty(this.tasks)) {
                Element tasksElement = new Element("tasks");
                tasksElement.setAttribute("primaryType", "jnt:tasks", ContentGeneratorCst.NS_JCR);
                for (TaskBO task : this.tasks) {
                    tasksElement.addContent((Content)task.getElement());
                }
                this.docspaceElement.addContent((Content)tasksElement);
            }
            if (CollectionUtils.isNotEmpty(this.folders)) {
                for (FolderBO folder : this.folders) {
                    this.docspaceElement.addContent((Content)folder.getElement());
                }
            }
        }
        return this.docspaceElement;
    }
}

