/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.wise.bo;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.jahia.utils.maven.plugin.contentgenerator.bo.SiteBO;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.DocspaceBO;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WiseBO
extends SiteBO {
    Element wiseElement;
    String wiseInstanceName;
    List<DocspaceBO> docspaces;

    public WiseBO(String wiseInstanceKey, List<DocspaceBO> docspaces) {
        this.setSiteKey(wiseInstanceKey);
        this.docspaces = docspaces;
    }

    public Element getElement() {
        if (this.wiseElement == null) {
            this.wiseElement = new Element(this.getSiteKey());
            this.wiseElement.setAttribute("mixinTypes", "jmix:accessControlled", ContentGeneratorCst.NS_JCR);
            this.wiseElement.setAttribute("primaryType", "jnt:virtualsite", ContentGeneratorCst.NS_JCR);
            if (CollectionUtils.isNotEmpty(this.docspaces)) {
                Element docspacesElement = new Element("docspaces");
                docspacesElement.setAttribute("mixinTypes", "jmix:workflowRulesable", ContentGeneratorCst.NS_JCR);
                docspacesElement.setAttribute("primaryType", "jnt:folder", ContentGeneratorCst.NS_JCR);
                for (DocspaceBO docspace : this.docspaces) {
                    docspacesElement.addContent((Content)docspace.getElement());
                }
                this.wiseElement.addContent((Content)docspacesElement);
            }
        }
        return this.wiseElement;
    }

    public Document getDocument() {
        Document doc = new Document();
        Element contentNode = new Element("content");
        contentNode.addNamespaceDeclaration(ContentGeneratorCst.NS_JCR);
        contentNode.addNamespaceDeclaration(ContentGeneratorCst.NS_JNT);
        contentNode.addNamespaceDeclaration(ContentGeneratorCst.NS_JMIX);
        contentNode.addNamespaceDeclaration(ContentGeneratorCst.NS_J);
        contentNode.addNamespaceDeclaration(ContentGeneratorCst.NS_NT);
        contentNode.addNamespaceDeclaration(ContentGeneratorCst.NS_SV);
        contentNode.addNamespaceDeclaration(ContentGeneratorCst.NS_MIX);
        contentNode.addNamespaceDeclaration(ContentGeneratorCst.NS_DOCNT);
        doc.setRootElement(contentNode);
        Element sitesNode = new Element("sites");
        sitesNode.setAttribute("primaryType", "jnt:virtualsitesFolder", ContentGeneratorCst.NS_JCR);
        sitesNode.addContent((Content)this.getElement());
        contentNode.addContent((Content)sitesNode);
        return doc;
    }
}

