/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.tomcat.remote;

import java.io.IOException;
import java.net.URL;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.tomcat.ProtocolMetadataParser;
import org.jboss.arquillian.container.tomcat.ShrinkWrapUtil;
import org.jboss.arquillian.container.tomcat.TomcatConfiguration;
import org.jboss.arquillian.container.tomcat.TomcatManager;
import org.jboss.arquillian.container.tomcat.TomcatManagerCommandSpec;
import org.jboss.arquillian.container.tomcat.remote.TomcatRemoteConfiguration;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

abstract class TomcatRemoteContainer
implements DeployableContainer<TomcatRemoteConfiguration> {
    private final ProtocolDescription protocolDescription;
    private final TomcatManagerCommandSpec tomcatManagerCommandSpec;
    private TomcatRemoteConfiguration configuration;
    private TomcatManager<TomcatRemoteConfiguration> manager;

    TomcatRemoteContainer(ProtocolDescription protocolDescription, TomcatManagerCommandSpec tomcatManagerCommandSpec) {
        this.protocolDescription = protocolDescription;
        this.tomcatManagerCommandSpec = tomcatManagerCommandSpec;
    }

    public Class<TomcatRemoteConfiguration> getConfigurationClass() {
        return TomcatRemoteConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return this.protocolDescription;
    }

    public void setup(TomcatRemoteConfiguration configuration) {
        this.configuration = configuration;
        this.manager = new TomcatManager((TomcatConfiguration)configuration, this.tomcatManagerCommandSpec);
    }

    public void start() throws LifecycleException {
    }

    public void stop() throws LifecycleException {
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        Validate.notNull(archive, (String)"Archive must not be null");
        String archiveName = this.manager.normalizeArchiveName(archive.getName());
        URL archiveURL = ShrinkWrapUtil.toURL(archive);
        try {
            this.manager.deploy("/" + archiveName, archiveURL);
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to deploy an archive " + archive.getName(), (Throwable)e);
        }
        ProtocolMetadataParser parser = new ProtocolMetadataParser((TomcatConfiguration)this.configuration);
        return parser.retrieveContextServletInfo(archiveName);
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        Validate.notNull(archive, (String)"Archive must not be null");
        String archiveName = this.manager.normalizeArchiveName(archive.getName());
        try {
            this.manager.undeploy("/" + archiveName);
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to undeploy an archive " + archive.getName(), (Throwable)e);
        }
    }
}

