/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.embedded;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.classloader.ShrinkWrapClassLoader;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class WebArchiveClassLoader
extends ShrinkWrapClassLoader {
    private static final URL CONTEXT;
    private static final String ARCHIVE = "archive";
    private static final String WAR_ROOT_LOCATION = "/WEB-INF/classes";
    private final Archive<?> archive;

    WebArchiveClassLoader(ClassLoader parent, Archive<?> archive) {
        super(parent, new Archive[]{archive});
        this.archive = archive;
    }

    public URL findResource(String name) {
        String adjustedName = this.adjust(name);
        return super.findResource(adjustedName);
    }

    public Enumeration<URL> findResources(String name) throws IOException {
        String adjustedName = this.adjust(name);
        Enumeration urls = super.findResources(adjustedName);
        ArrayList<URL> collectedUrls = new ArrayList<URL>();
        while (urls.hasMoreElements()) {
            collectedUrls.add((URL)urls.nextElement());
        }
        WebArchive war = (WebArchive)this.archive.as(WebArchive.class);
        Map libs = war.getContent(Filters.include((String)"/WEB-INF/lib/.*"));
        for (Map.Entry entry : libs.entrySet()) {
            JavaArchive jar;
            Asset asset = ((Node)entry.getValue()).getAsset();
            if (!(asset instanceof ArchiveAsset) || !(((ArchiveAsset)asset).getArchive() instanceof JavaArchive) || (jar = (JavaArchive)((ArchiveAsset)asset).getArchive()).get(name) == null) continue;
            collectedUrls.add(new URL(CONTEXT, "archive:" + name, new ArchiveURLStreamHandler((Archive)jar)));
        }
        return Collections.enumeration(collectedUrls);
    }

    public void close() throws IOException {
        super.close();
    }

    private String adjust(String name) {
        if (name.startsWith("/")) {
            return WAR_ROOT_LOCATION + name;
        }
        return "/WEB-INF/classes/" + name;
    }

    static {
        try {
            CONTEXT = new URL(ARCHIVE, "", 0, "", new ArchiveURLStreamHandler(null));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ArchiveURLStreamHandler
    extends URLStreamHandler {
        private final Archive<?> archive;

        private ArchiveURLStreamHandler(Archive<?> archive) {
            this.archive = archive;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new ArchiveURLConnection(u, this.archive);
        }
    }

    private static class ArchiveURLConnection
    extends URLConnection {
        private final Archive<?> archive;

        ArchiveURLConnection(URL url, Archive<?> archive) {
            super(url);
            this.archive = archive;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            String path = this.url.getPath();
            if (this.archive.get(path) == null || this.archive.get(path).getAsset() == null) {
                return null;
            }
            return this.archive.get(path).getAsset().openStream();
        }
    }
}

