/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.AnnotationLiteral;

public class MethodParameterInjectionPoint<T>
implements InjectionPoint {
    private Method method;
    private int position;
    private BeanManager beanManager;

    public MethodParameterInjectionPoint(Method method, int position, BeanManager beanManager) {
        this.method = method;
        this.position = position;
        this.beanManager = beanManager;
    }

    public Bean<?> getBean() {
        return null;
    }

    public Member getMember() {
        return this.method;
    }

    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        for (Annotation annotation : this.method.getParameterAnnotations()[this.position]) {
            if (!this.beanManager.isQualifier(annotation.annotationType())) continue;
            qualifiers.add(annotation);
        }
        if (qualifiers.size() == 0) {
            qualifiers.add((Annotation)((Object)new DefaultLiteral()));
        }
        return qualifiers;
    }

    public Type getType() {
        return this.findTypeOrGenericType();
    }

    public boolean isDelegate() {
        return false;
    }

    public boolean isTransient() {
        return false;
    }

    public Annotated getAnnotated() {
        return new ArgumentAnnotated();
    }

    private Type findTypeOrGenericType() {
        if (this.method.getGenericParameterTypes().length > 0) {
            return this.method.getGenericParameterTypes()[this.position];
        }
        return this.method.getParameterTypes()[this.position];
    }

    private class ArgumentAnnotated<X>
    implements AnnotatedParameter<X> {
        private ArgumentAnnotated() {
        }

        public AnnotatedCallable<X> getDeclaringCallable() {
            return null;
        }

        public int getPosition() {
            return MethodParameterInjectionPoint.this.position;
        }

        public <Y extends Annotation> Y getAnnotation(Class<Y> annotationType) {
            for (Annotation annotation : MethodParameterInjectionPoint.this.method.getParameterAnnotations()[MethodParameterInjectionPoint.this.position]) {
                if (annotation.annotationType() != annotationType) continue;
                return (Y)((Annotation)annotationType.cast(annotation));
            }
            return null;
        }

        public Set<Annotation> getAnnotations() {
            return new HashSet<Annotation>(Arrays.asList(MethodParameterInjectionPoint.this.method.getParameterAnnotations()[MethodParameterInjectionPoint.this.position]));
        }

        public Type getBaseType() {
            return MethodParameterInjectionPoint.this.getType();
        }

        public Set<Type> getTypeClosure() {
            HashSet<Type> types = new HashSet<Type>();
            types.add(MethodParameterInjectionPoint.this.findTypeOrGenericType());
            types.add((Type)((Object)Object.class));
            return types;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation(annotationType) != null;
        }
    }

    private static class DefaultLiteral
    extends AnnotationLiteral<Default>
    implements Default {
        private static final long serialVersionUID = 1L;

        private DefaultLiteral() {
        }
    }
}

