/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import org.jboss.as.arquillian.container.PollingFileInputStream;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class TunneledMBeanServerConnection
implements MBeanServerConnection {
    private static final String INVOKE_MBEAN_RAW = "invoke-mbean-raw";
    private static final String GET_MBEAN_INFO_RAW = "get-mbean-info-raw";
    private static final String JMX = "jmx";
    private static final String MBEAN_NAME = "mbean-name";
    private static final String MBEAN_OPERATION_NAME = "mbean-operation-name";
    private static final String NOTIFICATION_FILE = "notification-file";
    private static final String SIGNATURE = "signature";
    private static final String PARAMETERS = "parameters";
    private CopyOnWriteArrayList<NotificationListener> listeners = new CopyOnWriteArrayList();
    private ModelControllerClient client;

    public TunneledMBeanServerConnection(ModelControllerClient client) {
        this.client = client;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, IOException {
        return null;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        return null;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, IOException {
        return null;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        return null;
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
        return null;
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) throws IOException {
        return null;
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws IOException {
        return null;
    }

    @Override
    public boolean isRegistered(ObjectName name) throws IOException {
        return false;
    }

    @Override
    public Integer getMBeanCount() throws IOException {
        return null;
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        return null;
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        return null;
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        return null;
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        File notifications = File.createTempFile("arq", "notifications");
        FakeJMXNotificationThread thread = new FakeJMXNotificationThread(notifications, this.listeners);
        thread.start();
        ModelNode request = new ModelNode();
        request.get("operation").set(INVOKE_MBEAN_RAW);
        request.get("address").add("subsystem", JMX);
        request.get(MBEAN_NAME).set(name.toString());
        request.get(MBEAN_OPERATION_NAME).set(operationName);
        request.get(NOTIFICATION_FILE).set(notifications.getAbsolutePath());
        if (signature != null) {
            for (String string : signature) {
                request.get(SIGNATURE).add(string);
            }
        }
        if (params != null) {
            for (Object object : params) {
                request.get(PARAMETERS).add(this.getBytes(object));
            }
        }
        ModelNode response = this.client.execute(request);
        thread.done();
        notifications.delete();
        if (!"success".equals(response.get("outcome").asString())) {
            throw new IOException("Failed operation: " + response.get("failure-description").toString());
        }
        byte[] bytes = response.get("result").asBytes();
        try {
            return new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    private byte[] getBytes(Object param) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(param);
        oos.flush();
        return out.toByteArray();
    }

    @Override
    public String getDefaultDomain() throws IOException {
        return null;
    }

    @Override
    public String[] getDomains() throws IOException {
        return new String[0];
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        this.listeners.add(listener);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.listeners.remove(listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.listeners.remove(listener);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        ModelNode request = new ModelNode();
        request.get("operation").set(GET_MBEAN_INFO_RAW);
        request.get("address").add("subsystem", JMX);
        request.get(MBEAN_NAME).set(name.toString());
        ModelNode response = this.client.execute(request);
        if (!"success".equals(response.get("outcome").asString())) {
            throw new IOException("Failed operation: " + response.get("failure-description").toString());
        }
        byte[] bytes = response.get("result").asBytes();
        try {
            return (MBeanInfo)MBeanInfo.class.cast(new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject());
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        return false;
    }

    public static class FakeJMXNotificationThread
    extends Thread {
        private final File file;
        private final List<NotificationListener> listeners;
        private final AtomicBoolean done = new AtomicBoolean(false);

        public FakeJMXNotificationThread(File file, List<NotificationListener> listeners) {
            this.file = file;
            this.listeners = listeners;
        }

        public void done() {
            this.done.set(true);
            this.interrupt();
        }

        @Override
        public void run() {
            ObjectInputStream ois;
            PollingFileInputStream is;
            try {
                is = new PollingFileInputStream(new FileInputStream(this.file), this.done);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return;
            }
            try {
                ois = new ObjectInputStream(is);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    is.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                return;
            }
            while (!this.done.get()) {
                try {
                    Notification n = (Notification)ois.readObject();
                    for (NotificationListener listener : this.listeners) {
                        listener.handleNotification(n, null);
                    }
                }
                catch (Exception e) {
                }
            }
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

