/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.InputStream;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public interface OperationContext {
    public void addStep(OperationStepHandler var1, Stage var2) throws IllegalArgumentException;

    public void addStep(OperationStepHandler var1, Stage var2, boolean var3) throws IllegalArgumentException;

    public void addStep(ModelNode var1, OperationStepHandler var2, Stage var3) throws IllegalArgumentException;

    public void addStep(ModelNode var1, ModelNode var2, OperationStepHandler var3, Stage var4) throws IllegalArgumentException;

    public void addStep(ModelNode var1, ModelNode var2, OperationStepHandler var3, Stage var4, boolean var5) throws IllegalArgumentException;

    public InputStream getAttachmentStream(int var1);

    public int getAttachmentStreamCount();

    public ModelNode getResult();

    public boolean hasResult();

    public ModelNode getFailureDescription();

    public boolean hasFailureDescription();

    public ModelNode getServerResults();

    public ModelNode getResponseHeaders();

    public ResultAction completeStep();

    public void completeStep(RollbackHandler var1);

    public ProcessType getProcessType();

    public RunningMode getRunningMode();

    @Deprecated
    public Type getType();

    public boolean isBooting();

    public boolean isNormalServer();

    public boolean isRollbackOnly();

    public void setRollbackOnly();

    public boolean isRollbackOnRuntimeFailure();

    public boolean isResourceServiceRestartAllowed();

    public void reloadRequired();

    public void restartRequired();

    public void revertReloadRequired();

    public void revertRestartRequired();

    public void runtimeUpdateSkipped();

    public ImmutableManagementResourceRegistration getResourceRegistration();

    public ManagementResourceRegistration getResourceRegistrationForUpdate();

    public ImmutableManagementResourceRegistration getRootResourceRegistration();

    public ServiceRegistry getServiceRegistry(boolean var1) throws UnsupportedOperationException;

    public ServiceController<?> removeService(ServiceName var1) throws UnsupportedOperationException;

    public void removeService(ServiceController<?> var1) throws UnsupportedOperationException;

    public ServiceTarget getServiceTarget() throws UnsupportedOperationException;

    @Deprecated
    public ModelNode readModel(PathAddress var1);

    @Deprecated
    public ModelNode readModelForUpdate(PathAddress var1);

    public void acquireControllerLock();

    public Resource createResource(PathAddress var1) throws UnsupportedOperationException;

    public void addResource(PathAddress var1, Resource var2);

    public Resource readResource(PathAddress var1);

    public Resource readResource(PathAddress var1, boolean var2);

    public Resource readResourceFromRoot(PathAddress var1);

    public Resource readResourceFromRoot(PathAddress var1, boolean var2);

    public Resource readResourceForUpdate(PathAddress var1);

    public Resource removeResource(PathAddress var1) throws UnsupportedOperationException;

    @Deprecated
    public Resource getRootResource();

    public Resource getOriginalRootResource();

    public boolean isModelAffected();

    public boolean isResourceRegistryAffected();

    public boolean isRuntimeAffected();

    public Stage getCurrentStage();

    public void report(MessageSeverity var1, String var2);

    public boolean markResourceRestarted(PathAddress var1, Object var2);

    public boolean revertResourceRestarted(PathAddress var1, Object var2);

    public ModelNode resolveExpressions(ModelNode var1) throws OperationFailedException;

    public <T> T getAttachment(AttachmentKey<T> var1);

    public <T> T attach(AttachmentKey<T> var1, T var2);

    public <T> T attachIfAbsent(AttachmentKey<T> var1, T var2);

    public <T> T detach(AttachmentKey<T> var1);

    public static final class AttachmentKey<T> {
        private final Class<T> valueClass;

        private AttachmentKey(Class<T> valueClass) {
            this.valueClass = valueClass;
        }

        public T cast(Object value) {
            return this.valueClass.cast(value);
        }

        public static <T> AttachmentKey<T> create(Class<? super T> valueClass) {
            return new AttachmentKey<T>(valueClass);
        }
    }

    public static interface RollbackHandler {
        public static final RollbackHandler NOOP_ROLLBACK_HANDLER = new RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
            }
        };

        public void handleRollback(OperationContext var1, ModelNode var2);
    }

    public static enum ResultAction {
        KEEP,
        ROLLBACK;

    }

    @Deprecated
    public static enum Type {
        HOST,
        SERVER,
        MANAGEMENT;


        @Deprecated
        static Type getType(ProcessType processType, RunningMode runningMode) {
            if (processType.isServer()) {
                if (runningMode == RunningMode.NORMAL) {
                    return SERVER;
                }
                return MANAGEMENT;
            }
            return HOST;
        }
    }

    public static enum Stage {
        IMMEDIATE,
        MODEL,
        RUNTIME,
        VERIFY,
        DOMAIN,
        DONE;


        boolean hasNext() {
            return this != DONE;
        }

        Stage next() {
            switch (this) {
                case MODEL: {
                    return RUNTIME;
                }
                case RUNTIME: {
                    return VERIFY;
                }
                case VERIFY: {
                    return DOMAIN;
                }
                case DOMAIN: {
                    return DONE;
                }
            }
            throw new IllegalStateException();
        }
    }
}

