/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.interfaces;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.interfaces.AbstractInterfaceCriteria;
import org.jboss.as.controller.interfaces.InterfaceCriteria;

public final class OverallInterfaceCriteria
implements InterfaceCriteria {
    private static final long serialVersionUID = -5417786897309925997L;
    private final String interfaceName;
    private final Set<InterfaceCriteria> interfaceCriteria;

    public OverallInterfaceCriteria(String interfaceName, Set<InterfaceCriteria> criteria) {
        this.interfaceName = interfaceName;
        this.interfaceCriteria = criteria;
    }

    @Override
    public Map<NetworkInterface, Set<InetAddress>> getAcceptableAddresses(Map<NetworkInterface, Set<InetAddress>> candidates) throws SocketException {
        InterfaceCriteria criteria;
        Map<NetworkInterface, Set<InetAddress>> result = AbstractInterfaceCriteria.cloneCandidates(candidates);
        Iterator<InterfaceCriteria> i$ = this.interfaceCriteria.iterator();
        while (i$.hasNext() && (result = (criteria = i$.next()).getAcceptableAddresses(result)).size() != 0) {
        }
        if (result.size() > 0) {
            if (OverallInterfaceCriteria.hasMultipleMatches(result)) {
                result = OverallInterfaceCriteria.pruneAliasDuplicates(result);
            }
            if (OverallInterfaceCriteria.hasMultipleMatches(result)) {
                result = this.pruneIPTypes(result);
            }
            if (OverallInterfaceCriteria.hasMultipleMatches(result)) {
                Map<NetworkInterface, Set<InetAddress>> selected = OverallInterfaceCriteria.selectInterfaceAndAddress(result);
                if (this.interfaceName != null) {
                    Map.Entry<NetworkInterface, Set<InetAddress>> entry = selected.entrySet().iterator().next();
                    OverallInterfaceCriteria.warnMultipleValidInterfaces(this.interfaceName, result, entry.getKey(), entry.getValue().iterator().next());
                }
                result = selected;
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OverallInterfaceCriteria(");
        for (InterfaceCriteria criteria : this.interfaceCriteria) {
            sb.append(criteria.toString());
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    private Map<NetworkInterface, Set<InetAddress>> pruneIPTypes(Map<NetworkInterface, Set<InetAddress>> candidates) {
        Boolean preferIPv6Stack;
        Boolean preferIPv4Stack = OverallInterfaceCriteria.getBoolean("java.net.preferIPv4Stack");
        Boolean bl = preferIPv6Stack = preferIPv4Stack != null && preferIPv4Stack == false ? Boolean.TRUE : OverallInterfaceCriteria.getBoolean("java.net.preferIPv6Addresses");
        if (preferIPv4Stack == null && preferIPv6Stack == null) {
            return candidates;
        }
        HashMap<NetworkInterface, Set<InetAddress>> result = new HashMap<NetworkInterface, Set<InetAddress>>();
        for (Map.Entry<NetworkInterface, Set<InetAddress>> entry : candidates.entrySet()) {
            HashSet<InetAddress> good = null;
            for (InetAddress address : entry.getValue()) {
                if ((preferIPv4Stack == null || !preferIPv4Stack.booleanValue() || !(address instanceof Inet4Address)) && (preferIPv6Stack == null || !preferIPv6Stack.booleanValue() || !(address instanceof Inet6Address))) continue;
                if (good == null) {
                    good = new HashSet<InetAddress>();
                    result.put(entry.getKey(), good);
                }
                good.add(address);
            }
        }
        return result.size() == 0 ? candidates : result;
    }

    static Map<NetworkInterface, Set<InetAddress>> pruneAliasDuplicates(Map<NetworkInterface, Set<InetAddress>> result) {
        HashMap<NetworkInterface, Set<InetAddress>> pruned = new HashMap<NetworkInterface, Set<InetAddress>>();
        for (Map.Entry<NetworkInterface, Set<InetAddress>> entry : result.entrySet()) {
            NetworkInterface ni = entry.getKey();
            if (ni.getParent() != null) {
                pruned.put(ni, entry.getValue());
                continue;
            }
            HashSet retained = new HashSet(entry.getValue());
            Enumeration<NetworkInterface> subInterfaces = ni.getSubInterfaces();
            while (subInterfaces.hasMoreElements()) {
                NetworkInterface sub = subInterfaces.nextElement();
                Set<InetAddress> subAddresses = result.get(sub);
                if (subAddresses == null) continue;
                retained.removeAll(subAddresses);
            }
            if (retained.size() <= 0) continue;
            pruned.put(ni, retained);
        }
        return pruned;
    }

    private static Boolean getBoolean(final String property) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    String value = System.getProperty(property);
                    return value == null ? null : Boolean.valueOf(value.equalsIgnoreCase("true"));
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    private static Map<NetworkInterface, Set<InetAddress>> selectInterfaceAndAddress(Map<NetworkInterface, Set<InetAddress>> acceptable) throws SocketException {
        HashMap<NetworkInterface, Set<InetAddress>> preferred;
        if (acceptable.size() > 1) {
            preferred = new HashMap<NetworkInterface, Set<InetAddress>>();
            for (NetworkInterface networkInterface : acceptable.keySet()) {
                if (!networkInterface.isUp()) continue;
                preferred.put(networkInterface, acceptable.get(networkInterface));
            }
            if (preferred.size() > 0) {
                acceptable = preferred;
            }
        }
        if (acceptable.size() > 1) {
            preferred = new HashMap();
            for (NetworkInterface networkInterface : acceptable.keySet()) {
                if (networkInterface.isLoopback()) continue;
                preferred.put(networkInterface, acceptable.get(networkInterface));
            }
            if (preferred.size() > 0) {
                acceptable = preferred;
            }
        }
        if (acceptable.size() > 1) {
            preferred = new HashMap();
            for (NetworkInterface networkInterface : acceptable.keySet()) {
                if (networkInterface.isPointToPoint()) continue;
                preferred.put(networkInterface, acceptable.get(networkInterface));
            }
            if (preferred.size() > 0) {
                acceptable = preferred;
            }
        }
        if (OverallInterfaceCriteria.hasMultipleMatches(acceptable)) {
            preferred = new HashMap();
            for (Map.Entry entry : acceptable.entrySet()) {
                Set acceptableAddresses = (Set)entry.getValue();
                if (acceptableAddresses.size() > 1) {
                    HashSet<InetAddress> preferredAddresses = null;
                    for (InetAddress addr : acceptableAddresses) {
                        if (addr.isLinkLocalAddress()) continue;
                        if (preferredAddresses == null) {
                            preferredAddresses = new HashSet<InetAddress>();
                            preferred.put((NetworkInterface)entry.getKey(), (Set<InetAddress>)preferredAddresses);
                        }
                        preferredAddresses.add(addr);
                    }
                    continue;
                }
                acceptable.put((NetworkInterface)entry.getKey(), acceptableAddresses);
            }
            if (preferred.size() > 0) {
                acceptable = preferred;
            }
        }
        Map.Entry<NetworkInterface, Set<InetAddress>> entry = acceptable.entrySet().iterator().next();
        return Collections.singletonMap(entry.getKey(), Collections.singleton(entry.getValue().iterator().next()));
    }

    private static boolean hasMultipleMatches(Map<NetworkInterface, Set<InetAddress>> map) {
        return map.size() > 1 || map.size() == 1 && map.values().iterator().next().size() > 1;
    }

    private static void warnMultipleValidInterfaces(String interfaceName, Map<NetworkInterface, Set<InetAddress>> acceptable, NetworkInterface selectedInterface, InetAddress selectedAddress) {
        HashSet<String> nis = new HashSet<String>();
        HashSet<InetAddress> addresses = new HashSet<InetAddress>();
        for (Map.Entry<NetworkInterface, Set<InetAddress>> entry : acceptable.entrySet()) {
            nis.add(entry.getKey().getName());
            addresses.addAll((Collection<InetAddress>)entry.getValue());
        }
        ControllerLogger.ROOT_LOGGER.multipleMatchingAddresses(interfaceName, addresses, nis, selectedAddress, selectedInterface.getName());
    }
}

