/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jboss.as.controller.security.SecurityContext;

class SecurityActions {
    SecurityActions() {
    }

    static String getSystemProperty(final String key, final String defaultValue) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(key, defaultValue);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, defaultValue);
            }
        });
    }

    static void setSecurityContextSubject(final Subject subject) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContext.setSubject(subject);
                return null;
            }
        });
    }

    static void clearSubjectSecurityContext() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContext.clearSubject();
                return null;
            }
        });
    }
}

