/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReadTransformedResourceOperation
implements OperationStepHandler {
    private final ParametersValidator validator = new ParametersValidator();
    public static DescriptionProvider DESCRIPTION = new DescriptionProvider(){

        @Override
        public ModelNode getModelDescription(Locale locale) {
            return new ModelNode();
        }
    };

    public ReadTransformedResourceOperation() {
        this.validator.registerValidator("subsystem", new ModelTypeValidator(ModelType.STRING, false));
    }

    private ModelNode transformReadResourceResult(ImmutableManagementResourceRegistration managementResourceRegistration, ModelNode original, String subsystem, int major, int minor) {
        ModelNode rootData = original.get("result");
        Resource root = TransformerRegistry.modelToResource(managementResourceRegistration, rootData);
        Resource transformed = TransformerRegistry.getInstance().getTransformedSubsystemResource(root, managementResourceRegistration, subsystem, major, minor);
        return Resource.Tools.readModel(transformed);
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final String subsystem = operation.get("subsystem").asString();
        final int major = operation.get("management-major-version").asInt();
        final int minor = operation.get("management-minor-version").asInt();
        final ImmutableManagementResourceRegistration rr = context.getResourceRegistration();
        final ModelNode readResourceResult = new ModelNode();
        context.addStep(new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode transformed = ReadTransformedResourceOperation.this.transformReadResourceResult(rr, readResourceResult, subsystem, major, minor);
                context.getResult().set(transformed);
                context.completeStep();
            }
        }, OperationContext.Stage.IMMEDIATE);
        ModelNode op = new ModelNode();
        op.get("operation").set("read-resource");
        op.get("address").set(PathAddress.EMPTY_ADDRESS.toModelNode());
        op.get("recursive").set(true);
        context.addStep(readResourceResult, op, GlobalOperationHandlers.READ_RESOURCE, OperationContext.Stage.IMMEDIATE);
        context.completeStep();
    }
}

