/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.domain.http.server.ConsoleMode;
import org.jboss.as.domain.http.server.DomainApiHandler;
import org.jboss.as.domain.http.server.ErrorHandler;
import org.jboss.as.domain.http.server.ManagementHttpHandler;
import org.jboss.as.domain.http.server.ResourceHandler;
import org.jboss.as.domain.http.server.RootHandler;
import org.jboss.as.domain.http.server.security.BasicAuthenticator;
import org.jboss.as.domain.http.server.security.ClientCertAuthenticator;
import org.jboss.as.domain.http.server.security.DigestAuthenticator;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.DomainCallbackHandler;
import org.jboss.com.sun.net.httpserver.Authenticator;
import org.jboss.com.sun.net.httpserver.HttpServer;
import org.jboss.com.sun.net.httpserver.HttpsConfigurator;
import org.jboss.com.sun.net.httpserver.HttpsParameters;
import org.jboss.com.sun.net.httpserver.HttpsServer;
import org.jboss.modules.ModuleLoadException;
import org.jboss.sasl.callback.DigestHashCallback;

public class ManagementHttpServer {
    private final HttpServer httpServer;
    private final HttpServer secureHttpServer;
    private SecurityRealm securityRealm;
    private List<ManagementHttpHandler> handlers = new LinkedList<ManagementHttpHandler>();

    private ManagementHttpServer(HttpServer httpServer, HttpServer secureHttpServer, SecurityRealm securityRealm) {
        this.httpServer = httpServer;
        this.secureHttpServer = secureHttpServer;
        this.securityRealm = securityRealm;
    }

    void addHandler(ManagementHttpHandler handler) {
        this.handlers.add(handler);
    }

    public void start() {
        this.start(this.httpServer);
        this.start(this.secureHttpServer);
    }

    private void start(HttpServer httpServer) {
        if (httpServer == null) {
            return;
        }
        for (ManagementHttpHandler current : this.handlers) {
            current.start(httpServer, this.securityRealm);
        }
        httpServer.start();
    }

    public void stop() {
        this.stop(this.httpServer);
        this.stop(this.secureHttpServer);
    }

    private void stop(HttpServer httpServer) {
        if (httpServer == null) {
            return;
        }
        httpServer.stop(0);
        for (ManagementHttpHandler current : this.handlers) {
            current.stop(httpServer);
        }
    }

    public static ManagementHttpServer create(InetSocketAddress bindAddress, InetSocketAddress secureBindAddress, int backlog, ModelControllerClient modelControllerClient, Executor executor, SecurityRealm securityRealm, ConsoleMode consoleMode) throws IOException {
        ResourceHandler consoleHandler;
        CertAuth certAuthMode;
        HashMap<String, String> configuration = new HashMap<String, String>(1);
        configuration.put("sun.net.httpserver.maxReqTime", "15");
        Object auth = null;
        if (securityRealm != null) {
            DomainCallbackHandler callbackHandler = securityRealm.getCallbackHandler();
            Class[] supportedCallbacks = callbackHandler.getSupportedCallbacks();
            if (DigestAuthenticator.requiredCallbacksSupported(supportedCallbacks)) {
                auth = new DigestAuthenticator((CallbackHandler)callbackHandler, securityRealm.getName(), ManagementHttpServer.contains(DigestHashCallback.class, supportedCallbacks));
            } else if (BasicAuthenticator.requiredCallbacksSupported(supportedCallbacks)) {
                auth = new BasicAuthenticator(callbackHandler, securityRealm.getName());
            }
            if (securityRealm.hasTrustStore()) {
                if (auth == null) {
                    certAuthMode = CertAuth.NEED;
                    auth = new ClientCertAuthenticator(securityRealm.getName());
                } else {
                    certAuthMode = CertAuth.WANT;
                }
            } else {
                certAuthMode = CertAuth.NONE;
            }
        } else {
            certAuthMode = CertAuth.NONE;
        }
        HttpServer httpServer = null;
        if (bindAddress != null) {
            httpServer = HttpServer.create((InetSocketAddress)bindAddress, (int)backlog, configuration);
            httpServer.setExecutor(executor);
        }
        HttpsServer secureHttpServer = null;
        if (secureBindAddress != null) {
            secureHttpServer = HttpsServer.create((InetSocketAddress)secureBindAddress, (int)backlog, configuration);
            final SSLContext context = securityRealm.getSSLContext();
            secureHttpServer.setHttpsConfigurator(new HttpsConfigurator(context){

                public void configure(HttpsParameters params) {
                    SSLParameters sslparams = context.getDefaultSSLParameters();
                    switch (certAuthMode) {
                        case NEED: {
                            sslparams.setNeedClientAuth(true);
                            break;
                        }
                        case WANT: {
                            sslparams.setWantClientAuth(true);
                        }
                    }
                    params.setSSLParameters(sslparams);
                }
            });
            secureHttpServer.setExecutor(executor);
        }
        ManagementHttpServer managementHttpServer = new ManagementHttpServer(httpServer, (HttpServer)secureHttpServer, securityRealm);
        try {
            consoleHandler = consoleMode.createConsoleHandler();
        }
        catch (ModuleLoadException e) {
            throw new IOException("Unable to load resource handler", e);
        }
        managementHttpServer.addHandler(new RootHandler(consoleHandler));
        managementHttpServer.addHandler(new DomainApiHandler(modelControllerClient, (Authenticator)auth));
        if (consoleHandler != null) {
            managementHttpServer.addHandler(consoleHandler);
        }
        try {
            managementHttpServer.addHandler(new ErrorHandler());
        }
        catch (ModuleLoadException e) {
            throw new IOException("Unable to load resource handler", e);
        }
        return managementHttpServer;
    }

    private static boolean contains(Class clazz, Class[] classes) {
        for (Class current : classes) {
            if (!current.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    private static enum CertAuth {
        NONE,
        WANT,
        NEED;

    }
}

