/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.UnknownHostException;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.services.net.LocalDestinationOutboundSocketBindingResourceDefinition;
import org.jboss.as.server.services.net.LocalDestinationOutboundSocketBindingService;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.as.server.services.net.OutboundSocketBindingResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class LocalDestinationOutboundSocketBindingAddHandler
extends AbstractAddStepHandler {
    static final LocalDestinationOutboundSocketBindingAddHandler INSTANCE = new LocalDestinationOutboundSocketBindingAddHandler();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition ad : LocalDestinationOutboundSocketBindingResourceDefinition.ATTRIBUTES) {
            ad.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> serviceControllers) throws OperationFailedException {
        ServiceController<OutboundSocketBinding> outboundSocketBindingServiceController;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String outboundSocketName = address.getLastElement().getValue();
        try {
            outboundSocketBindingServiceController = LocalDestinationOutboundSocketBindingAddHandler.installOutboundSocketBindingService(context, model, outboundSocketName);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        serviceControllers.add(outboundSocketBindingServiceController);
    }

    public static ServiceController<OutboundSocketBinding> installOutboundSocketBindingService(OperationContext context, ModelNode model, String outboundSocketName) throws OperationFailedException, UnknownHostException {
        ServiceTarget serviceTarget = context.getServiceTarget();
        String socketBindingRef = LocalDestinationOutboundSocketBindingResourceDefinition.SOCKET_BINDING_REF.resolveModelAttribute(context, model).asString();
        ModelNode sourceInterfaceModelNode = OutboundSocketBindingResourceDefinition.SOURCE_INTERFACE.resolveModelAttribute(context, model);
        String sourceInterfaceName = sourceInterfaceModelNode.isDefined() ? sourceInterfaceModelNode.asString() : null;
        ModelNode sourcePortModelNode = OutboundSocketBindingResourceDefinition.SOURCE_PORT.resolveModelAttribute(context, model);
        Integer sourcePort = sourcePortModelNode.isDefined() ? Integer.valueOf(sourcePortModelNode.asInt()) : null;
        ModelNode fixedSourcePortModelNode = OutboundSocketBindingResourceDefinition.FIXED_SOURCE_PORT.resolveModelAttribute(context, model);
        boolean fixedSourcePort = fixedSourcePortModelNode.isDefined() ? fixedSourcePortModelNode.asBoolean() : false;
        LocalDestinationOutboundSocketBindingService outboundSocketBindingService = new LocalDestinationOutboundSocketBindingService(outboundSocketName, sourcePort, fixedSourcePort);
        ServiceBuilder serviceBuilder = serviceTarget.addService(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{outboundSocketName}), (Service)outboundSocketBindingService);
        serviceBuilder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketBindingRef}), SocketBinding.class, outboundSocketBindingService.getLocalDestinationSocketBindingInjector());
        if (sourceInterfaceName != null) {
            serviceBuilder.addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{sourceInterfaceName}), NetworkInterfaceBinding.class, outboundSocketBindingService.getSourceNetworkInterfaceBindingInjector());
        }
        serviceBuilder.addDependency(SocketBindingManager.SOCKET_BINDING_MANAGER, SocketBindingManager.class, outboundSocketBindingService.getSocketBindingManagerInjector());
        return serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }
}

