/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.scoped;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javassist.CtClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftValueHashMap
extends AbstractMap<String, CtClass>
implements Map<String, CtClass> {
    private Map<String, SoftValueRef> hash;
    private ReferenceQueue<CtClass> queue = new ReferenceQueue();

    @Override
    public Set<Map.Entry<String, CtClass>> entrySet() {
        throw new UnsupportedOperationException();
    }

    private void processQueue() {
        SoftValueRef ref;
        while ((ref = (SoftValueRef)this.queue.poll()) != null) {
            if (ref != this.hash.get(ref.key)) continue;
            this.hash.remove(ref.key);
        }
    }

    public SoftValueHashMap(int initialCapacity, float loadFactor) {
        this.hash = new HashMap<String, SoftValueRef>(initialCapacity, loadFactor);
    }

    public SoftValueHashMap(int initialCapacity) {
        this.hash = new HashMap<String, SoftValueRef>(initialCapacity);
    }

    public SoftValueHashMap() {
        this.hash = new HashMap<String, SoftValueRef>();
    }

    public SoftValueHashMap(Map<String, CtClass> t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    @Override
    public int size() {
        this.processQueue();
        return this.hash.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.hash.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return this.hash.containsKey(key);
    }

    @Override
    public CtClass get(Object key) {
        this.processQueue();
        SoftReference ref = this.hash.get(key);
        return ref == null ? null : (CtClass)ref.get();
    }

    @Override
    public CtClass put(String key, CtClass value) {
        this.processQueue();
        SoftValueRef rtn = this.hash.put(key, SoftValueRef.create(key, value, this.queue));
        return rtn == null ? null : (CtClass)rtn.get();
    }

    public SoftValueRef remove(String key) {
        this.processQueue();
        return this.hash.remove(key);
    }

    @Override
    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftValueRef
    extends SoftReference<CtClass> {
        public Object key;

        private SoftValueRef(String key, CtClass val, ReferenceQueue<CtClass> q) {
            super(val, q);
            this.key = key;
        }

        private static SoftValueRef create(String key, CtClass val, ReferenceQueue<CtClass> q) {
            if (val == null) {
                return null;
            }
            return new SoftValueRef(key, val, q);
        }
    }
}

