/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting;

import java.util.ArrayList;
import java.util.Map;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.remoting.ClusterConstants;
import org.jboss.ha.framework.server.HATarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicantsManagerInterceptor
implements Interceptor,
ClusterConstants {
    private final Map<String, HATarget> families;

    public ReplicantsManagerInterceptor(Map<String, HATarget> families) {
        this.families = families;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object response = invocation.invokeNext();
        String clientFamily = (String)invocation.getMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_FAMILY");
        HATarget target = this.families.get(clientFamily);
        if (target == null) {
            return response;
        }
        Long clientViewId = (Long)invocation.getMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_VIEW_ID");
        if (clientViewId == null) {
            return response;
        }
        if (clientViewId.longValue() != target.getCurrentViewId()) {
            invocation.addResponseAttachment((Object)"replicants", new ArrayList(target.getReplicantList()));
            invocation.addResponseAttachment((Object)"viewId", (Object)new Long(target.getCurrentViewId()));
        }
        return response;
    }
}

