/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.spi;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManagerFactory;
import org.jboss.web.tomcat.service.session.distributedcache.spi.TomcatClusterConfig;
import org.jboss.web.tomcat.service.session.distributedcache.spi.TomcatClusterDistributedCacheManagerFactory;

public class DistributedCacheManagerFactoryFactory {
    public static final String DEFAULT_CLASS_NAME = "org.jboss.web.tomcat.service.session.distributedcache.impl.DistributedCacheManagerFactoryImpl";
    private static final DistributedCacheManagerFactoryFactory instance = new DistributedCacheManagerFactoryFactory();
    private DistributedCacheManagerFactory distributedCacheManagerFactory;
    private String factoryClassName = "org.jboss.web.tomcat.service.session.distributedcache.impl.DistributedCacheManagerFactoryImpl";
    private Map<TomcatClusterConfig, TomcatClusterDistributedCacheManagerFactory> tomcatClusterFactories = new HashMap<TomcatClusterConfig, TomcatClusterDistributedCacheManagerFactory>();

    public static final DistributedCacheManagerFactoryFactory getInstance() {
        return instance;
    }

    public synchronized DistributedCacheManagerFactory getDistributedCacheManagerFactory() throws ClusteringNotSupportedException {
        if (this.distributedCacheManagerFactory == null) {
            this.distributedCacheManagerFactory = this.instantiateFactory();
            this.factoryClassName = this.distributedCacheManagerFactory.getClass().getName();
        }
        return this.distributedCacheManagerFactory;
    }

    public synchronized void setDistributedCacheManagerFactory(DistributedCacheManagerFactory distributedCacheManagerFactory) {
        this.distributedCacheManagerFactory = distributedCacheManagerFactory;
    }

    public synchronized TomcatClusterDistributedCacheManagerFactory getTomcatClusterDistributedCacheManagerFactory(TomcatClusterConfig config) throws ClusteringNotSupportedException {
        TomcatClusterDistributedCacheManagerFactory factory = this.tomcatClusterFactories.get(config);
        if (factory == null) {
            factory = (TomcatClusterDistributedCacheManagerFactory)this.instantiateFactory();
            this.tomcatClusterFactories.put(config, factory);
        }
        factory.setTomcatClusterConfig(config);
        return factory;
    }

    public synchronized void setTomcatClusterDistributedCacheManagerFactory(TomcatClusterConfig config, TomcatClusterDistributedCacheManagerFactory factory) {
        this.tomcatClusterFactories.put(config, factory);
    }

    public synchronized String getFactoryClassName() {
        return this.factoryClassName;
    }

    public synchronized void setFactoryClassName(String factoryClassName) {
        this.factoryClassName = factoryClassName == null ? DEFAULT_CLASS_NAME : factoryClassName;
    }

    private DistributedCacheManagerFactory instantiateFactory() throws ClusteringNotSupportedException {
        String className = this.factoryClassName == null ? DEFAULT_CLASS_NAME : this.factoryClassName;
        ClassLoader cl = this.getTCCL();
        try {
            return (DistributedCacheManagerFactory)cl.loadClass(className).newInstance();
        }
        catch (Exception e) {
            throw new ClusteringNotSupportedException("Cannot create " + DistributedCacheManagerFactory.class.getSimpleName(), e);
        }
    }

    private ClassLoader getTCCL() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private DistributedCacheManagerFactoryFactory() {
    }
}

