/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.helpers;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.annotations.AnnotationEnvironment;
import org.jboss.deployers.spi.structure.ClassPathEntry;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.spi.structure.StructureMetaDataFactory;
import org.jboss.deployers.vfs.spi.structure.CandidateAnnotationsCallback;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.deployers.vfs.spi.structure.StructureDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
import org.jboss.deployers.vfs.spi.structure.helpers.CandidateStructureVisitorFactory;
import org.jboss.deployers.vfs.spi.structure.helpers.DefaultCandidateStructureVisitorFactory;
import org.jboss.deployers.vfs.spi.structure.helpers.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.util.collection.CollectionsFactory;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.virtual.VisitorAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStructureDeployer
implements StructureDeployer {
    protected Logger log = Logger.getLogger(this.getClass());
    private int relativeOrder = Integer.MAX_VALUE;
    private CandidateStructureVisitorFactory candidateStructureVisitorFactory = DefaultCandidateStructureVisitorFactory.INSTANCE;
    private Integer contextInfoOrder;
    private boolean supportsCandidateAnnotations;
    private Set<Class<? extends Annotation>> candidateAnnotations;

    public static final String getRelativePath(StructureContext context, VirtualFile child) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        return AbstractStructureDeployer.getRelativePath(context.getParent(), child);
    }

    public static final String getRelativePath(VirtualFile parent, VirtualFile child) {
        if (child == null) {
            throw new IllegalArgumentException("Null child");
        }
        String childPath = child.getPathName();
        if (parent != null) {
            String parentPath = parent.getPathName();
            if (parentPath.length() == childPath.length()) {
                return "";
            }
            if (parentPath.length() < childPath.length()) {
                if (!parentPath.endsWith("/")) {
                    parentPath = parentPath + "/";
                }
                if (childPath.startsWith(parentPath)) {
                    return childPath.substring(parentPath.length());
                }
            }
        }
        if (childPath.endsWith("/")) {
            childPath = childPath.substring(0, childPath.length() - 1);
        }
        return childPath;
    }

    public int getRelativeOrder() {
        return this.relativeOrder;
    }

    public void setRelativeOrder(int order) {
        this.relativeOrder = order;
    }

    public void setContextInfoOrder(Integer contextInfoOrder) {
        this.contextInfoOrder = contextInfoOrder;
    }

    public Set<Class<? extends Annotation>> getCandidateAnnotations() {
        return this.candidateAnnotations;
    }

    public void setCandidateAnnotations(Set<Class<? extends Annotation>> candidateAnnotations) {
        this.candidateAnnotations = candidateAnnotations;
    }

    public void addCandidateAnnotation(Class<? extends Annotation> annotationClass) {
        if (this.candidateAnnotations == null) {
            this.candidateAnnotations = new LinkedHashSet<Class<? extends Annotation>>();
        }
        this.candidateAnnotations.add(annotationClass);
    }

    @Override
    public boolean determineStructure(StructureContext context) throws DeploymentException {
        return this.determineStructure(context.getRoot(), context.getParent(), context.getFile(), context.getMetaData(), context.getDeployers());
    }

    @Deprecated
    public boolean determineStructure(VirtualFile root, VirtualFile parent, VirtualFile file, StructureMetaData metaData, VFSStructuralDeployers deployers) throws DeploymentException {
        return false;
    }

    @Override
    public boolean isSupportsCandidateAnnotations() {
        return this.supportsCandidateAnnotations;
    }

    public void setSupportsCandidateAnnotations(boolean supportsCandidateAnnotations) {
        this.supportsCandidateAnnotations = supportsCandidateAnnotations;
    }

    public CandidateStructureVisitorFactory getCandidateStructureVisitorFactory() {
        return this.candidateStructureVisitorFactory;
    }

    public void setCandidateStructureVisitorFactory(CandidateStructureVisitorFactory candidateStructureVisitorFactory) {
        if (candidateStructureVisitorFactory == null) {
            throw new IllegalArgumentException("Null candidateStructureVisitorFactory");
        }
        this.candidateStructureVisitorFactory = candidateStructureVisitorFactory;
    }

    @Deprecated
    public boolean isTopLevel(VirtualFile parent) {
        return parent == null;
    }

    protected void addClassPath(StructureContext structureContext, VirtualFile entry, boolean includeEntry, boolean includeRootManifestCP, ContextInfo context) throws IOException {
        ArrayList<VirtualFile> paths;
        boolean trace;
        block5: {
            trace = this.log.isTraceEnabled();
            paths = new ArrayList<VirtualFile>();
            if (includeEntry) {
                paths.add(entry);
            }
            if (includeRootManifestCP && !AbstractStructureDeployer.isLeaf(entry)) {
                try {
                    VFSUtils.addManifestLocations((VirtualFile)entry, paths);
                }
                catch (Exception e) {
                    if (!trace) break block5;
                    this.log.trace((Object)"Failed to add manifest locations", (Throwable)e);
                }
            }
        }
        VirtualFile root = structureContext.getRoot();
        for (VirtualFile vf : paths) {
            String entryPath = AbstractStructureDeployer.getRelativePath(root, vf);
            ClassPathEntry cpe = StructureMetaDataFactory.createClassPathEntry((String)entryPath);
            context.addClassPathEntry(cpe);
            if (!trace) continue;
            this.log.trace((Object)("Added classpath entry " + entryPath + " for " + vf.getName() + " from " + root));
        }
    }

    @Deprecated
    protected void addClassPath(VirtualFile root, VirtualFile entry, boolean includeEntry, boolean includeRootManifestCP, ContextInfo context) throws IOException {
        ArrayList<VirtualFile> paths;
        boolean trace;
        block5: {
            trace = this.log.isTraceEnabled();
            paths = new ArrayList<VirtualFile>();
            if (includeEntry) {
                paths.add(entry);
            }
            if (includeRootManifestCP && !AbstractStructureDeployer.isLeaf(entry)) {
                try {
                    VFSUtils.addManifestLocations((VirtualFile)entry, paths);
                }
                catch (Exception e) {
                    if (!trace) break block5;
                    this.log.trace((Object)"Failed to add manifest locations", (Throwable)e);
                }
            }
        }
        for (VirtualFile vf : paths) {
            String entryPath = AbstractStructureDeployer.getRelativePath(root, vf);
            ClassPathEntry cpe = StructureMetaDataFactory.createClassPathEntry((String)entryPath);
            context.addClassPathEntry(cpe);
            if (!trace) continue;
            this.log.trace((Object)("Added classpath entry " + entryPath + " for " + vf.getName() + " from " + root));
        }
    }

    protected abstract AnnotationEnvironment createAnnotationEnvironment(VirtualFile var1);

    protected boolean checkCandidateAnnotations(StructureContext context, VirtualFile ... roots) {
        if (roots == null || roots.length == 0) {
            throw new IllegalArgumentException("Null or empty roots");
        }
        if (this.candidateAnnotations == null || this.candidateAnnotations.isEmpty()) {
            return true;
        }
        StructureContext parentContext = context.getParentContext();
        if (parentContext == null) {
            return true;
        }
        Set<CandidateAnnotationsCallback> callbacks = parentContext.getCallbacks(CandidateAnnotationsCallback.class);
        if (callbacks.isEmpty()) {
            return true;
        }
        boolean result = false;
        for (VirtualFile root : roots) {
            AnnotationEnvironment env = this.createAnnotationEnvironment(root);
            for (Class<? extends Annotation> annotationClass : this.candidateAnnotations) {
                if (!env.hasClassAnnotatedWith(annotationClass)) continue;
                result = true;
                for (CandidateAnnotationsCallback callback : callbacks) {
                    callback.executeCallback(root, context, env, annotationClass);
                }
            }
        }
        return result;
    }

    protected void addAllChildren(StructureContext context) throws Exception {
        this.addChildren(context, null);
    }

    protected void addChildren(StructureContext context, VisitorAttributes attributes) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        VirtualFile file = context.getFile();
        VirtualFileVisitor visitor = this.candidateStructureVisitorFactory.createVisitor(context, attributes);
        file.visit(visitor);
    }

    protected void addAllChildren(VirtualFile root, VirtualFile parent, StructureMetaData metaData, VFSStructuralDeployers deployers) throws Exception {
        this.addChildren(root, parent, metaData, deployers, null);
    }

    protected void addChildren(VirtualFile root, VirtualFile parent, StructureMetaData metaData, VFSStructuralDeployers deployers, VisitorAttributes attributes) throws Exception {
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        StructureContext context = new StructureContext(root, null, parent, metaData, deployers, null);
        this.addChildren(context, attributes);
    }

    protected static boolean isLeaf(VirtualFile file) throws IOException {
        return SecurityActions.isLeaf(file);
    }

    protected ContextInfo createContext(StructureContext context) {
        return this.createContext(context, (String)null);
    }

    protected ContextInfo createContext(StructureContext context, String metaDataPath) {
        ContextInfo result = this.applyMetadataPath(context, metaDataPath);
        this.applyStructure(context, result);
        return result;
    }

    @Deprecated
    protected ContextInfo createContext(VirtualFile root, StructureMetaData structureMetaData) {
        return this.createContext(root, (String)null, structureMetaData);
    }

    @Deprecated
    protected ContextInfo createContext(VirtualFile root, String metaDataPath, StructureMetaData structureMetaData) {
        ContextInfo result = this.applyMetadataPath(root, metaDataPath);
        this.applyStructure(root, structureMetaData, result);
        return result;
    }

    protected ContextInfo applyMetadataPath(StructureContext context, String metaDataPath) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (metaDataPath != null) {
            VirtualFile root = context.getFile();
            try {
                VirtualFile child = root.getChild(metaDataPath);
                if (child == null) {
                    metaDataPath = null;
                }
            }
            catch (IOException e) {
                this.log.warn((Object)("Not using metadata path " + metaDataPath + " for " + root.getName() + " reason: " + e.getMessage()));
                metaDataPath = null;
            }
        }
        if (metaDataPath != null) {
            return StructureMetaDataFactory.createContextInfo((String)"", (String)metaDataPath, null);
        }
        return StructureMetaDataFactory.createContextInfo((String)"", null);
    }

    @Deprecated
    protected ContextInfo applyMetadataPath(VirtualFile root, String metaDataPath) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        if (metaDataPath != null) {
            try {
                VirtualFile child = root.getChild(metaDataPath);
                if (child == null) {
                    metaDataPath = null;
                }
            }
            catch (IOException e) {
                this.log.warn((Object)("Not using metadata path " + metaDataPath + " for " + root.getName() + " reason: " + e.getMessage()));
                metaDataPath = null;
            }
        }
        if (metaDataPath != null) {
            return StructureMetaDataFactory.createContextInfo((String)"", (String)metaDataPath, null);
        }
        return StructureMetaDataFactory.createContextInfo((String)"", null);
    }

    protected ContextInfo createContext(StructureContext context, String[] metaDataPaths) {
        ContextInfo result = this.applyMetadataPaths(context, metaDataPaths);
        this.applyStructure(context, result);
        return result;
    }

    protected ContextInfo applyMetadataPaths(StructureContext context, String[] metaDataPaths) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        VirtualFile root = context.getFile();
        List metaDataPath = CollectionsFactory.createLazyList();
        if (metaDataPaths != null && metaDataPaths.length > 0) {
            for (String path : metaDataPaths) {
                try {
                    VirtualFile child = root.getChild(path);
                    if (child == null) continue;
                    metaDataPath.add(path);
                }
                catch (IOException e) {
                    this.log.warn((Object)("Not using metadata path " + path + " for " + root.getName() + " reason: " + e.getMessage()));
                }
            }
        }
        if (metaDataPath.isEmpty()) {
            return StructureMetaDataFactory.createContextInfo((String)"", null);
        }
        return StructureMetaDataFactory.createContextInfo((String)"", (List)metaDataPath, null);
    }

    @Deprecated
    protected ContextInfo createContext(VirtualFile root, String[] metaDataPaths, StructureMetaData structureMetaData) {
        ContextInfo result = this.applyMetadataPaths(root, metaDataPaths);
        this.applyStructure(root, structureMetaData, result);
        return result;
    }

    @Deprecated
    protected ContextInfo applyMetadataPaths(VirtualFile root, String[] metaDataPaths) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        List metaDataPath = CollectionsFactory.createLazyList();
        if (metaDataPaths != null && metaDataPaths.length > 0) {
            for (String path : metaDataPaths) {
                try {
                    VirtualFile child = root.getChild(path);
                    if (child == null) continue;
                    metaDataPath.add(path);
                }
                catch (IOException e) {
                    this.log.warn((Object)("Not using metadata path " + path + " for " + root.getName() + " reason: " + e.getMessage()));
                }
            }
        }
        if (metaDataPath.isEmpty()) {
            return StructureMetaDataFactory.createContextInfo((String)"", null);
        }
        return StructureMetaDataFactory.createContextInfo((String)"", (List)metaDataPath, null);
    }

    protected void applyStructure(StructureContext context, ContextInfo contextInfo) {
        boolean trace = this.log.isTraceEnabled();
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        VirtualFile root = context.getRoot();
        this.applyContextInfo(context, contextInfo);
        context.addChild(contextInfo);
        if (trace) {
            this.log.trace((Object)("Added context " + context + " from " + root.getName()));
        }
    }

    protected void applyContextInfo(StructureContext context, ContextInfo result) {
        if (result != null && this.contextInfoOrder != null) {
            result.setRelativeOrder(this.contextInfoOrder.intValue());
        }
    }

    @Deprecated
    protected void applyStructure(VirtualFile root, StructureMetaData structureMetaData, ContextInfo context) {
        boolean trace = this.log.isTraceEnabled();
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        if (structureMetaData == null) {
            throw new IllegalArgumentException("Null structure metadata");
        }
        this.applyContextInfo(root, context);
        structureMetaData.addContext(context);
        if (trace) {
            this.log.trace((Object)("Added context " + context + " from " + root.getName()));
        }
    }

    @Deprecated
    protected void applyContextInfo(VirtualFile root, ContextInfo result) {
        if (result != null && this.contextInfoOrder != null) {
            result.setRelativeOrder(this.contextInfoOrder.intValue());
        }
    }
}

