/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mcint.metadata.plugins;

import javax.ejb.EJB;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.ejb3.common.resolvers.spi.EjbReference;
import org.jboss.ejb3.common.resolvers.spi.EjbReferenceResolver;
import org.jboss.ejb3.mcint.metadata.plugins.AbstractEjbReferenceValueMetadata;
import org.jboss.kernel.plugins.annotations.FieldAnnotationPlugin;
import org.jboss.logging.Logger;
import org.jboss.reflect.spi.FieldInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbReferenceAnnotationPlugin
extends FieldAnnotationPlugin<EJB> {
    private static final Logger log = Logger.getLogger(EjbReferenceAnnotationPlugin.class);
    private static final Context defaultNamingContext;
    private EjbReferenceResolver resolver;
    private Context namingContext;

    public EjbReferenceAnnotationPlugin(EjbReferenceResolver resolver) {
        this(resolver, defaultNamingContext);
    }

    public EjbReferenceAnnotationPlugin(EjbReferenceResolver resolver, Context context) {
        super(EJB.class);
        assert (resolver != null) : "Resolver is required, but not specified.";
        assert (context != null) : "Naming context is required, but not specified.";
        this.setResolver(resolver);
        this.setNamingContext(context);
    }

    protected ValueMetaData createValueMetaData(FieldInfo propInfo, EJB annotation) {
        String beanName = annotation.beanName();
        String beanInterface = annotation.beanInterface().getName();
        String mappedName = annotation.mappedName();
        if (beanInterface == null || beanInterface.equals(Object.class.getName())) {
            String reflectType;
            beanInterface = reflectType = propInfo.getType().getName();
        }
        EjbReference reference = new EjbReference(beanName, beanInterface, mappedName);
        log.debug((Object)("Found @EJB reference " + reference));
        return new AbstractEjbReferenceValueMetadata(this.getResolver(), reference, this.getNamingContext());
    }

    public EjbReferenceResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(EjbReferenceResolver resolver) {
        this.resolver = resolver;
    }

    protected Context getNamingContext() {
        return this.namingContext;
    }

    protected void setNamingContext(Context namingContext) {
        this.namingContext = namingContext;
    }

    static {
        try {
            defaultNamingContext = new InitialContext();
        }
        catch (NamingException e) {
            throw new RuntimeException("Could not create the default naming context", e);
        }
    }
}

