package org.jboss.hal.client.configuration.subsystem.modcluster;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ModclusterView extends ModclusterView {

    private final Metadata metadata2;
    private final Metadata metadata1;
    private final Metadata metadata0;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ModclusterView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata2Template = AddressTemplate.of("/{selected.profile}/subsystem=modcluster/proxy=*/load-provider=dynamic/load-metric=*");
        this.metadata2 = mbuiContext.metadataRegistry().lookup(metadata2Template);
        AddressTemplate metadata1Template = AddressTemplate.of("/{selected.profile}/subsystem=modcluster/proxy=*/load-provider=dynamic/custom-load-metric=*");
        this.metadata1 = mbuiContext.metadataRegistry().lookup(metadata1Template);
        AddressTemplate metadata0Template = AddressTemplate.of("/{selected.profile}/subsystem=modcluster/proxy=*");
        this.metadata0 = mbuiContext.metadataRegistry().lookup(metadata0Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new GroupedForm.Builder<org.jboss.hal.dmr.ModelNode>("proxy-conf-form", metadata0)
            .customGroup("advertising", "Advertising")
                .include("advertise", "advertise-security-key", "advertise-socket", "balancer", "listener", "load-balancing-group")
            .end()
            .customGroup("sessions", "Sessions")
                .include("sticky-session", "sticky-session-force", "sticky-session-remove")
            .end()
            .customGroup("web-contexts", "Web Contexts")
                .include("auto-enable-context", "excluded-contexts", "session-draining-strategy")
            .end()
            .customGroup("proxies", "Proxies")
                .include("proxies", "proxy-url", "ssl-context")
            .end()
            .customGroup("networking", "Networking")
                .include("flush-packets", "flush-wait", "max-attempts", "node-timeout", "ping", "smax", "socket-timeout", "status-interval", "stop-context-timeout", "ttl", "worker-timeout")
            .end()
            .onSave((form, changedValues) -> {
                String name = presenter.getProxyName();
                saveForm("Configuration", name, metadata0Template.resolve(statementContext(), name), changedValues, metadata0);
            })
            .prepareReset(form -> {
                String name = presenter.getProxyName();
                resetForm("Configuration", name, metadata0Template.resolve(statementContext(), name), form, metadata0);
            })
            .build();
        loadMetricForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("load-metrics-form", metadata2)
            .onSave((form, changedValues) -> presenter.saveLoadMetric(form, changedValues))
            .prepareReset(form -> presenter.prepareResetLoadMetric(form))
            .build();
        customLoadMetricForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("custom-load-metrics-form", metadata1)
            .onSave((form, changedValues) -> presenter.saveCustomLoadMetric(form, changedValues))
            .prepareReset(form -> presenter.prepareResetCustomLoadMetric(form))
            .build();

        loadMetricTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("load-metrics-table", metadata2)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addLoadMetric(), Constraint.parse("executable({selected.profile}/subsystem=modcluster/proxy=*/load-provider=dynamic/load-metric=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeLoadMetric(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=modcluster/proxy=*/load-provider=dynamic/load-metric=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        customLoadMetricTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("custom-load-metrics-table", metadata1)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addCustomLoadMetric(), Constraint.parse("executable({selected.profile}/subsystem=modcluster/proxy=*/load-provider=dynamic/custom-load-metric=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeCustomLoadMetric(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=modcluster/proxy=*/load-provider=dynamic/custom-load-metric=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html0;
        HTMLElement proxyItemElement = section()
            .add(html0 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata0.getDescription().getDescription()}</p>"))
                            .element())
            .add(configurationForm)
                    .element();
        expressionElements.put("html0", html0);
        navigation.addPrimary("proxy-item", "Configuration", "pficon pficon-settings", proxyItemElement);
        HTMLElement html2;
        HTMLElement customLoadMetricsItemElement = section()
            .add(html2 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Load Metrics</h1><p>${metadata1.getDescription().getDescription()}</p>"))
                            .element())
            .add(customLoadMetricTable)
            .add(customLoadMetricForm)
                    .element();
        expressionElements.put("html2", html2);
        navigation.addPrimary("custom-load-metrics-item", "Custom Load Metrics", "pficon pficon-service", customLoadMetricsItemElement);
        HTMLElement html5;
        HTMLElement loadMetricsItemElement = section()
            .add(html5 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Load Metrics</h1><p>${metadata2.getDescription().getDescription()}</p>"))
                            .element())
            .add(loadMetricTable)
            .add(loadMetricForm)
                    .element();
        expressionElements.put("html5", html5);
        navigation.addPrimary("load-metrics-item", "Load Metrics", "fa fa-map", loadMetricsItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(loadMetricTable);
        registerAttachable(loadMetricForm);
        registerAttachable(customLoadMetricTable);
        registerAttachable(customLoadMetricForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            loadMetricTable.bindForm(loadMetricForm);
            customLoadMetricTable.bindForm(customLoadMetricForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html0"), "${metadata0.getDescription().getDescription()}", String.valueOf(metadata0.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html2"), "${metadata1.getDescription().getDescription()}", String.valueOf(metadata1.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html5"), "${metadata2.getDescription().getDescription()}", String.valueOf(metadata2.getDescription().getDescription()));
    }
}
