/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor.mbui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ExpressionParser {
    private static final Pattern PATTERN = Pattern.compile("\\$\\{(.*?)\\}");

    private ExpressionParser() {
    }

    static Map<String, String> parse(String input) {
        if (input != null) {
            HashMap<String, String> matches = new HashMap<String, String>();
            Matcher matcher = PATTERN.matcher(input);
            while (matcher.find()) {
                String match = matcher.group();
                ExpressionParser.validate(match);
                matches.put(match, ExpressionParser.stripExpression(match));
            }
            return matches;
        }
        return Collections.emptyMap();
    }

    private static void validate(String pattern) {
        if (!ExpressionParser.isExpression(pattern)) {
            throw new IllegalArgumentException("Invalid expression: " + pattern);
        }
        if (pattern.lastIndexOf("${") != 0 || pattern.indexOf("}") != pattern.length() - 1) {
            throw new IllegalArgumentException("Invalid expression: " + pattern);
        }
    }

    static boolean isExpression(String value) {
        return value != null && value.contains("${") && value.indexOf("}") > 1;
    }

    static String stripExpression(String pattern) {
        if (ExpressionParser.isExpression(pattern)) {
            int start = "${".length();
            int end = pattern.length() - "}".length();
            return pattern.substring(start, end);
        }
        return pattern;
    }

    static String templateSafeValue(String value) {
        if (value != null) {
            return ExpressionParser.isExpression(value) ? ExpressionParser.stripExpression(value) : "\"" + value + "\"";
        }
        return null;
    }
}

