/*
 * Decompiled with CFR 0.152.
 */
package test.implementation.modelmbean;

import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.modelmbean.DescriptorSupport;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jboss.mx.modelmbean.XMBean;
import org.jboss.mx.modelmbean.XMBeanConstants;
import test.implementation.modelmbean.support.Test;

public class AttributeCacheTEST
extends TestCase
implements XMBeanConstants {
    public AttributeCacheTEST(String s) {
        super(s);
    }

    public void testImplicitDisabledAttributeCaching() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        Test resource = new Test();
        DescriptorSupport d = new DescriptorSupport();
        d.setField("xmbean.resource.reference", resource);
        d.setField("xmbean.resource.type", "file:./src/main/test/implementation/modelmbean/support/xml/TrivialManagementInterface.xml");
        d.setField("xmbean.metadata.sax.parser", "org.apache.crimson.parser.XMLReaderImpl");
        XMBean mmb = new XMBean((Object)d, "descriptor");
        ObjectName name = new ObjectName(":test=test");
        server.registerMBean(mmb, name);
        for (int i = 0; i < 10; ++i) {
            server.setAttribute(name, new Attribute("Something", "foo"));
            server.getAttribute(name, "Something");
        }
        AttributeCacheTEST.assertTrue((resource.getFooCount() == 10 ? 1 : 0) != 0);
        AttributeCacheTEST.assertTrue((resource.getBarCount() == 10 ? 1 : 0) != 0);
    }

    public void testExplicitDisabledAttributeCaching() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        Test resource = new Test();
        DescriptorSupport d = new DescriptorSupport();
        d.setField("xmbean.resource.reference", resource);
        d.setField("xmbean.resource.type", "file:./src/main/test/implementation/modelmbean/support/xml/TrivialManagementInterface2.xml");
        d.setField("xmbean.metadata.sax.parser", "org.apache.crimson.parser.XMLReaderImpl");
        XMBean mmb = new XMBean((Object)d, "descriptor");
        ObjectName name = new ObjectName(":test=test");
        server.registerMBean(mmb, name);
        for (int i = 0; i < 8; ++i) {
            server.setAttribute(name, new Attribute("Something", "foo"));
            server.getAttribute(name, "Something");
        }
        AttributeCacheTEST.assertTrue((resource.getFooCount() == 8 ? 1 : 0) != 0);
        AttributeCacheTEST.assertTrue((resource.getBarCount() == 8 ? 1 : 0) != 0);
    }

    public void testNeverStaleAttributeCaching() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        Test resource = new Test();
        DescriptorSupport d = new DescriptorSupport();
        d.setField("xmbean.resource.reference", resource);
        d.setField("xmbean.resource.type", "file:./src/main/test/implementation/modelmbean/support/xml/TrivialManagementInterface3.xml");
        d.setField("xmbean.metadata.sax.parser", "org.apache.crimson.parser.XMLReaderImpl");
        XMBean mmb = new XMBean((Object)d, "descriptor");
        ObjectName name = new ObjectName(":test=test");
        server.registerMBean(mmb, name);
        for (int i = 0; i < 11; ++i) {
            server.setAttribute(name, new Attribute("Something", "foo"));
            server.getAttribute(name, "Something");
        }
        AttributeCacheTEST.assertTrue((resource.getFooCount() == 11 ? 1 : 0) != 0);
        AttributeCacheTEST.assertTrue((resource.getBarCount() == 0 ? 1 : 0) != 0);
    }

    public void testCachedAttribute() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        Test resource = new Test();
        DescriptorSupport d = new DescriptorSupport();
        d.setField("xmbean.resource.reference", resource);
        d.setField("xmbean.resource.type", "file:./src/main/test/implementation/modelmbean/support/xml/TrivialManagementInterface4.xml");
        d.setField("xmbean.metadata.sax.parser", "org.apache.crimson.parser.XMLReaderImpl");
        XMBean mmb = new XMBean((Object)d, "descriptor");
        ObjectName name = new ObjectName(":test=test");
        server.registerMBean(mmb, name);
        for (int i = 0; i < 7; ++i) {
            server.setAttribute(name, new Attribute("Something", "foo"));
            server.getAttribute(name, "Something");
        }
        AttributeCacheTEST.assertTrue((resource.getFooCount() == 7 ? 1 : 0) != 0);
        AttributeCacheTEST.assertTrue((resource.getBarCount() == 0 ? 1 : 0) != 0);
    }

    public void testCachedAttribute2() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        Test resource = new Test();
        DescriptorSupport d = new DescriptorSupport();
        d.setField("xmbean.resource.reference", resource);
        d.setField("xmbean.resource.type", "file:./src/main/test/implementation/modelmbean/support/xml/TrivialManagementInterface5.xml");
        d.setField("xmbean.metadata.sax.parser", "org.apache.crimson.parser.XMLReaderImpl");
        XMBean mmb = new XMBean((Object)d, "descriptor");
        ObjectName name = new ObjectName(":test=test");
        server.registerMBean(mmb, name);
        server.getAttribute(name, "Something");
        AttributeCacheTEST.assertTrue((resource.getBarCount() == 1 ? 1 : 0) != 0);
        server.setAttribute(name, new Attribute("Something", "yksi"));
        AttributeCacheTEST.assertTrue((resource.getFooCount() == 1 ? 1 : 0) != 0);
        String str = (String)server.getAttribute(name, "Something");
        AttributeCacheTEST.assertTrue((resource.getBarCount() == 1 ? 1 : 0) != 0);
        AttributeCacheTEST.assertTrue((boolean)str.equals("yksi"));
        try {
            Thread.sleep(1100L);
        }
        catch (Throwable t) {
            // empty catch block
        }
        server.getAttribute(name, "Something");
        AttributeCacheTEST.assertTrue((resource.getBarCount() == 2 ? 1 : 0) != 0);
        server.setAttribute(name, new Attribute("Something", "kaksi"));
        AttributeCacheTEST.assertTrue((resource.getFooCount() == 2 ? 1 : 0) != 0);
        try {
            Thread.sleep(1100L);
        }
        catch (Throwable t) {
            // empty catch block
        }
        str = (String)server.getAttribute(name, "Something");
        AttributeCacheTEST.assertTrue((resource.getBarCount() == 3 ? 1 : 0) != 0);
        AttributeCacheTEST.assertTrue((boolean)str.equals("kaksi"));
        str = (String)server.getAttribute(name, "Something");
        AttributeCacheTEST.assertTrue((resource.getBarCount() == 3 ? 1 : 0) != 0);
        AttributeCacheTEST.assertTrue((boolean)str.equals("kaksi"));
    }

    public void testAttributeChangeNotifications() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        Test resource = new Test();
        DescriptorSupport d = new DescriptorSupport();
        d.setField("xmbean.resource.reference", resource);
        d.setField("xmbean.resource.type", "file:./src/main/test/implementation/modelmbean/support/xml/TrivialManagementInterface5.xml");
        d.setField("xmbean.metadata.sax.parser", "org.apache.crimson.parser.XMLReaderImpl");
        XMBean mmb = new XMBean((Object)d, "descriptor");
        ObjectName name = new ObjectName(":test=test");
        server.registerMBean(mmb, name);
        class MyNotificationListener
        implements NotificationListener {
            int notifCount = 0;

            MyNotificationListener() {
            }

            public void handleNotification(Notification notification, Object handback) {
                AttributeChangeNotification notif = (AttributeChangeNotification)notification;
                Assert.assertTrue((boolean)notif.getNewValue().equals("somevalue"));
                ++this.notifCount;
            }
        }
        MyNotificationListener listener = new MyNotificationListener();
        server.addNotificationListener(name, listener, null, null);
        for (int i = 0; i < 10; ++i) {
            server.setAttribute(name, new Attribute("Something", "somevalue"));
        }
        AttributeCacheTEST.assertTrue((listener.notifCount == 10 ? 1 : 0) != 0);
    }
}

