/*
 * Decompiled with CFR 0.152.
 */
package test.stress.timer;

import java.util.Date;
import java.util.Random;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.timer.Timer;
import junit.framework.TestCase;
import test.stress.timer.TimerSUITE;

public class TimerTestCase
extends TestCase
implements NotificationListener {
    String TIMER_TYPE = "TimerType";
    String MESSAGE = "Message";
    String USER_DATA = "UserData";
    MBeanServer server;
    ObjectName timerName;
    Timer timer;
    int notifications = 0;
    int target = 0;
    int nextPercentage = 10;

    public TimerTestCase(String s) {
        super(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTortureOne() throws Exception {
        this.target = TimerSUITE.TIMERS * TimerSUITE.NOTIFICATIONS;
        System.err.println("Timer Torture One: target=" + this.target);
        this.initTest();
        try {
            this.initTimer();
            this.startTimer();
            this.nextPercentage = 10;
            Random random = new Random();
            for (int i = 0; i < TimerSUITE.TIMERS; ++i) {
                this.addNotification(TimerSUITE.OFFSET, random.nextInt(TimerSUITE.PERIOD), TimerSUITE.NOTIFICATIONS);
            }
            for (int k = 0; k < this.target; ++k) {
                Integer id = this.addNotification(3600000L, 3600000L, 1L);
                this.timer.getAllNotificationIDs();
                this.timer.getDate(id);
                this.timer.getNbNotifications();
                this.timer.getNbOccurences(id);
                this.timer.getNotificationIDs(this.TIMER_TYPE);
                this.timer.getNotificationUserData(id);
                this.timer.getPeriod(id);
                this.timer.getSendPastNotifications();
                this.timer.isActive();
                this.timer.isEmpty();
                this.timer.setSendPastNotifications(true);
                this.removeNotification(id);
            }
            for (int j = 0; j < TimerSUITE.NOTIFICATIONS && this.notifications < this.target; ++j) {
                int lastNotifications = this.notifications;
                this.sleep(TimerSUITE.PERIOD * 10);
                if (lastNotifications != this.notifications) continue;
                this.sleep(TimerSUITE.PERIOD * 10);
                if (lastNotifications == this.notifications) break;
            }
            TimerTestCase.assertTrue((this.notifications == this.target ? 1 : 0) != 0);
        }
        finally {
            this.endTest();
        }
    }

    private void initTest() {
        this.notifications = 0;
        this.server = MBeanServerFactory.createMBeanServer();
    }

    private void endTest() throws Exception {
        this.server.removeNotificationListener(this.timerName, this);
        this.stopTimer();
        MBeanServerFactory.releaseMBeanServer(this.server);
    }

    private void initTimer() {
        try {
            this.timer = new Timer();
            this.timerName = new ObjectName("test:type=timer");
            this.server.registerMBean(this.timer, this.timerName);
            this.server.addNotificationListener(this.timerName, this, null, null);
        }
        catch (Exception e) {
            TimerTestCase.fail((String)e.toString());
        }
    }

    private void startTimer() {
        this.timer.start();
    }

    private void stopTimer() {
        this.timer.removeAllNotifications();
        this.timer.stop();
    }

    private Integer addNotification(long offset, long period, long occurs) {
        return this.timer.addNotification(this.TIMER_TYPE, this.MESSAGE, this.USER_DATA, this.timeOffset(offset), period, occurs);
    }

    private void removeNotification(Integer id) throws Exception {
        this.timer.removeNotification(id);
    }

    public synchronized void handleNotification(Notification n, Object ignored) {
        ++this.notifications;
        float percentage = 100 * this.notifications / this.target;
        if (percentage >= (float)this.nextPercentage) {
            System.err.println("Done " + this.nextPercentage + "%");
            this.nextPercentage += 10;
        }
    }

    private Date timeOffset(long offset) {
        return new Date(System.currentTimeMillis() + offset);
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

