/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration.password;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import org.jboss.security.integration.password.PasswordMaskManagement;
import org.jboss.security.plugins.FilePassword;

public class PasswordTool {
    private static PasswordMaskManagement pwm = null;

    public PasswordTool() {
        if (pwm == null) {
            pwm = new PasswordMaskManagement();
            ShutdownHook sh = new ShutdownHook(pwm);
            Runtime.getRuntime().addShutdownHook(sh);
        }
    }

    public static void main(String[] args) {
        System.out.println("**********************************");
        System.out.println("****  JBoss Password Tool********");
        System.out.println("**********************************");
        new PasswordTool();
        try {
            pwm.load();
        }
        catch (Exception e) {
            System.out.println("Error while trying to load data:" + e.getMessage());
            System.out.println("Maybe it does not exist and need to be created.");
        }
        Scanner in = new Scanner(System.in);
        block13: while (true) {
            String commandStr = "0: Encrypt Keystore Password 1:Specify KeyStore 2:Create Password  3: Remove a domain 4:Enquire Domain 5:Exit";
            System.out.println(commandStr);
            int choice = in.nextInt();
            switch (choice) {
                case 0: {
                    System.out.println("Enter Keystore password");
                    String passStr = in.next();
                    String saltStr = "";
                    do {
                        System.out.println("Enter Salt (String should be at least 8 characters)");
                    } while ((saltStr = in.next()).length() < 8);
                    System.out.println("Enter Iterator Count (integer value)");
                    int iterationCount = in.nextInt();
                    String ksPassFileName = PasswordMaskManagement.keystorePassEncFileName;
                    String[] filePasswordArgs = new String[]{saltStr, iterationCount + "", passStr, ksPassFileName};
                    try {
                        File passwordDir = new File("password");
                        if (!passwordDir.exists()) {
                            passwordDir.mkdir();
                        }
                        FilePassword.main((String[])filePasswordArgs);
                    }
                    catch (Exception e1) {
                        throw new RuntimeException(e1);
                    }
                    System.out.println("Keystore Password encrypted into " + ksPassFileName);
                    continue block13;
                }
                case 1: {
                    System.out.println("Enter Keystore location including the file name");
                    String loc = in.next();
                    System.out.println("Enter Keystore alias");
                    String alias = in.next();
                    try {
                        pwm.setKeyStoreDetails(loc, alias);
                    }
                    catch (Exception e) {
                        System.out.println("Exception being raised. Try to first encrypt the keystore password.");
                        System.out.println("or check the keystore location.");
                    }
                    PasswordTool.load();
                    continue block13;
                }
                case 2: {
                    if (pwm.keyStoreExists()) {
                        System.out.println("Enter security domain:");
                        String domain = in.next();
                        System.out.println("Enter passwd:");
                        String p = in.next();
                        pwm.storePassword(domain, p.toCharArray());
                        System.out.println("Password created for domain:" + domain);
                        continue block13;
                    }
                    System.out.println("Enter Keystore details first");
                    continue block13;
                }
                case 3: {
                    if (pwm.keyStoreExists()) {
                        System.out.println("Enter security domain to be removed:");
                        String domainToRemove = in.next();
                        pwm.removePassword(domainToRemove);
                        continue block13;
                    }
                    System.out.println("Enter Keystore details first");
                    continue block13;
                }
                case 4: {
                    if (pwm.keyStoreExists()) {
                        System.out.println("Enter security domain to enquire:");
                        String domainToEnquire = in.next();
                        System.out.println("Exists = " + pwm.exists(domainToEnquire));
                        continue block13;
                    }
                    System.out.println("Enter Keystore details first");
                    continue block13;
                }
            }
            System.exit(0);
        }
    }

    private static void load() {
        try {
            pwm.load();
        }
        catch (FileNotFoundException ignore) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ShutdownHook
    extends Thread {
        private PasswordMaskManagement pmm;

        public ShutdownHook(PasswordMaskManagement pmm) {
            this.pmm = pmm;
        }

        public void run() {
            try {
                System.out.println(this.getClass().getName() + " run called");
                this.pmm.store();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

