/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.jndi;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

class SecurityAssociationActions {
    SecurityAssociationActions() {
    }

    static void setSecurityContext(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static SecurityContext getSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static SecurityContext createSecurityContext(final Principal p, final Object cred, final Subject subject) {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                SecurityContext sc = null;
                try {
                    sc = SecurityContextFactory.createSecurityContext((Principal)p, (Object)cred, (Subject)subject, (String)"CLIENT_LOGIN_MODULE");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return sc;
            }
        });
    }

    static void pushSecurityContext(final Principal p, final Object cred, final Subject subject, final String securityDomain) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContext sc;
                try {
                    sc = SecurityContextFactory.createSecurityContext((Principal)p, (Object)cred, (Subject)subject, (String)securityDomain);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                SecurityAssociationActions.setSecurityContext(sc);
                if (SecurityAssociationActions.getServer() == Boolean.FALSE) {
                    SecurityAssociation.pushSubjectContext((Subject)subject, (Principal)p, (Object)cred);
                }
                return null;
            }
        });
    }

    static Boolean getServer() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return SecurityAssociation.isServer();
            }
        });
    }

    static void setServer() {
        AccessController.doPrivileged(SetServerAction.ACTION);
    }

    static void setPrincipalInfo(Principal principal, Object credential, Subject subject) {
        SetPrincipalInfoAction action = new SetPrincipalInfoAction(principal, credential, subject);
        AccessController.doPrivileged(action);
    }

    static void popPrincipalInfo() {
        PopPrincipalInfoAction action = new PopPrincipalInfoAction();
        AccessController.doPrivileged(action);
    }

    static ClassLoader getContextClassLoader() {
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(GetTCLAction.ACTION);
        return loader;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetServerAction
    implements PrivilegedAction<Object> {
        static PrivilegedAction<Object> ACTION = new SetServerAction();

        private SetServerAction() {
        }

        @Override
        public Object run() {
            SecurityAssociation.setServer();
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetTCLAction
    implements PrivilegedAction<Object> {
        static PrivilegedAction<Object> ACTION = new GetTCLAction();

        private GetTCLAction() {
        }

        @Override
        public Object run() {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PopPrincipalInfoAction
    implements PrivilegedAction<Object> {
        private PopPrincipalInfoAction() {
        }

        @Override
        public Object run() {
            if (!SecurityAssociationActions.getServer().booleanValue()) {
                SecurityAssociation.popSubjectContext();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetPrincipalInfoAction
    implements PrivilegedAction<Object> {
        Principal principal;
        Object credential;
        Subject subject;

        SetPrincipalInfoAction(Principal principal, Object credential, Subject subject) {
            this.principal = principal;
            this.credential = credential;
            this.subject = subject;
        }

        @Override
        public Object run() {
            if (!SecurityAssociationActions.getServer().booleanValue()) {
                SecurityAssociation.pushSubjectContext((Subject)this.subject, (Principal)this.principal, (Object)this.credential);
            }
            SecurityContext sc = null;
            try {
                sc = SecurityContextFactory.createSecurityContext((Principal)this.principal, (Object)this.credential, (Subject)this.subject, (String)"CLIENT_LOGIN_MODULE");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            SecurityAssociationActions.setSecurityContext(sc);
            this.credential = null;
            this.principal = null;
            this.subject = null;
            return null;
        }
    }
}

