/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.aop.microcontainer.aspects.jmx;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * A temporary home for this annotation interface
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @author Brian Stansberry
 * 
 * @version $Revision: 58352 $
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface JMX 
{
   /**
    * The mbean interface the annotated object should expose. Ignored if 
    * {@link #registerDirectly()} is <code>true</code>. 
    * 
    * @return the mbean interface
    */
   Class exposedInterface();
   
   /**
    * String form of the ObjectName for the mbean.
    * 
    * @return the object name
    */
   String name() default "";
   
   /**
    * Should the annotated object itself be directly registered with
    * the MBeanServer, or should a <code>javax.management.StandardMBean</code>
    * be created using the object and the 
    * {@link #exposedInterface() exposed interface}?
    * 
    * @return  <code>true</code> if the object should be registered directly,
    *          <code>false</code> if a StandardMBean should be created.
    */
   boolean registerDirectly() default false;
}
