/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel;

import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.bootstrap.KernelInitializer;
import org.jboss.kernel.spi.config.KernelConfig;
import org.jboss.logging.Logger;

public class KernelFactory {
    private static final KernelFactory singleton = new KernelFactory();
    protected final Logger log = Logger.getLogger(this.getClass());

    private KernelFactory() {
    }

    public static Kernel newInstance(KernelConfig cfg) {
        return singleton.assembleNewKernel(cfg);
    }

    protected Kernel assembleNewKernel(KernelConfig cfg) throws RuntimeException {
        long begin = 0L;
        long end = 0L;
        this.log.debug((Object)"Starting JBoss Kernel construction...");
        begin = System.currentTimeMillis();
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Using KernelConfig: " + cfg));
        }
        Kernel kernel = this.createKernel();
        if (trace) {
            this.log.trace((Object)("Using Kernel: " + kernel));
        }
        KernelInitializer initializer = this.createKernelInitializer(cfg);
        if (trace) {
            this.log.trace((Object)("Using KernelInitializer: " + initializer));
        }
        this.configureKernel(kernel, cfg);
        if (trace) {
            this.log.trace((Object)"Configured kernel from KernelConfig");
        }
        this.initializeKernel(kernel, initializer);
        if (trace) {
            this.log.trace((Object)"Kernel instance initialzed");
        }
        end = System.currentTimeMillis();
        this.log.debug((Object)("Completed JBoss Kernel construction.  Duration: " + (end - begin) + " milliseconds"));
        return kernel;
    }

    protected Kernel createKernel() {
        return new Kernel();
    }

    protected KernelInitializer createKernelInitializer(KernelConfig config) {
        try {
            return config.createKernelInitializer();
        }
        catch (Throwable t) {
            String msg = "Unable to create a KernelInitializer based on the specified KernelConfig";
            throw new RuntimeException(msg, t);
        }
    }

    protected void configureKernel(Kernel kernel, KernelConfig cfg) {
        kernel.setConfig(cfg);
        try {
            cfg.setKernel(kernel);
        }
        catch (Throwable t) {
            String msg = "Unable to update the KernelConfig with the specified Kernel";
            throw new RuntimeException(msg, t);
        }
    }

    protected void initializeKernel(Kernel kernel, KernelInitializer initializer) {
        try {
            initializer.initKernel(kernel);
        }
        catch (Throwable t) {
            String msg = "Unable to properly initialize the Kernel";
            throw new RuntimeException(msg, t);
        }
    }
}

